/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro.mapreduce;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.trevni.avro.WordCountUtil;
import org.apache.trevni.avro.mapreduce.AvroTrevniKeyValueInputFormat;
import org.apache.trevni.avro.mapreduce.AvroTrevniKeyValueOutputFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestKeyValueWordCount {
    private static long total = 0L;
    static final Schema STRING = Schema.create((Schema.Type)Schema.Type.STRING);
    static final Schema LONG;

    @Test
    void iOFormat() throws Exception {
        this.checkOutputFormat();
        this.checkInputFormat();
    }

    public void checkOutputFormat() throws Exception {
        Job job = Job.getInstance();
        WordCountUtil wordCountUtil = new WordCountUtil("trevniMapReduceKeyValueTest", "part-r-00000");
        wordCountUtil.writeLinesFile();
        AvroJob.setInputKeySchema((Job)job, (Schema)STRING);
        AvroJob.setOutputKeySchema((Job)job, (Schema)STRING);
        AvroJob.setOutputValueSchema((Job)job, (Schema)LONG);
        job.setMapperClass(WordCountMapper.class);
        job.setReducerClass(WordCountReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(wordCountUtil.getDir().toString() + "/in")});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(wordCountUtil.getDir().toString() + "/out"));
        FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        job.setInputFormatClass(AvroKeyInputFormat.class);
        job.setOutputFormatClass(AvroTrevniKeyValueOutputFormat.class);
        job.waitForCompletion(true);
        wordCountUtil.validateCountsFileGenericRecord();
    }

    public void checkInputFormat() throws Exception {
        Job job = Job.getInstance();
        WordCountUtil wordCountUtil = new WordCountUtil("trevniMapReduceKeyValueTest");
        job.setMapperClass(Counter.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(wordCountUtil.getDir().toString() + "/out/*")});
        job.setInputFormatClass(AvroTrevniKeyValueInputFormat.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(NullOutputFormat.class);
        total = 0L;
        job.waitForCompletion(true);
        Assertions.assertEquals((long)WordCountUtil.TOTAL, (long)total);
    }

    static {
        GenericData.setStringType((Schema)STRING, (GenericData.StringType)GenericData.StringType.String);
        LONG = Schema.create((Schema.Type)Schema.Type.LONG);
    }

    private static class WordCountMapper
    extends Mapper<AvroKey<String>, NullWritable, Text, LongWritable> {
        private LongWritable mCount = new LongWritable();
        private Text mText = new Text();

        private WordCountMapper() {
        }

        protected void setup(Mapper.Context context) {
            this.mCount.set(1L);
        }

        protected void map(AvroKey<String> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                StringTokenizer tokens = new StringTokenizer((String)key.datum());
                while (tokens.hasMoreTokens()) {
                    this.mText.set(tokens.nextToken());
                    context.write((Object)this.mText, (Object)this.mCount);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(key + " " + (String)key.datum(), e);
            }
        }
    }

    private static class WordCountReducer
    extends Reducer<Text, LongWritable, AvroKey<String>, AvroValue<Long>> {
        AvroKey<String> resultKey = new AvroKey();
        AvroValue<Long> resultValue = new AvroValue();

        private WordCountReducer() {
        }

        protected void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long sum = 0L;
            for (LongWritable value : values) {
                sum += value.get();
            }
            this.resultKey.datum((Object)key.toString());
            this.resultValue.datum((Object)sum);
            context.write(this.resultKey, this.resultValue);
        }
    }

    public static class Counter
    extends Mapper<AvroKey<String>, AvroValue<Long>, NullWritable, NullWritable> {
        protected void map(AvroKey<String> key, AvroValue<Long> value, Mapper.Context context) throws IOException, InterruptedException {
            total += ((Long)value.datum()).longValue();
        }
    }
}

