/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.Pair;
import org.apache.avro.specific.SpecificData;
import org.apache.hadoop.fs.FileUtil;
import org.apache.trevni.avro.AvroColumnReader;
import org.junit.jupiter.api.Assertions;

public class WordCountUtil {
    public File dir;
    public File linesFiles;
    public File countFiles;
    public static final String[] LINES = new String[]{"the quick brown fox jumps over the lazy dog", "the cow jumps over the moon", "the rain in spain falls mainly on the plains"};
    public static final Map<String, Long> COUNTS = new TreeMap<String, Long>();
    public static final long TOTAL;

    public WordCountUtil(String testName) {
        this(testName, "part-00000");
    }

    public WordCountUtil(String testName, String partDirName) {
        this.dir = new File("target/wc", testName);
        this.linesFiles = new File(new File(this.dir, "in"), "lines.avro");
        this.countFiles = new File(new File(this.dir, "out"), partDirName + "/part-0.trv");
    }

    public File getDir() {
        return this.dir;
    }

    public void writeLinesFile() throws IOException {
        FileUtil.fullyDelete((File)this.dir);
        GenericDatumWriter writer = new GenericDatumWriter();
        DataFileWriter out = new DataFileWriter((DatumWriter)writer);
        this.linesFiles.getParentFile().mkdirs();
        out.create(Schema.create((Schema.Type)Schema.Type.STRING), this.linesFiles);
        for (String line : LINES) {
            out.append((Object)line);
        }
        out.close();
    }

    public void validateCountsFile() throws Exception {
        AvroColumnReader reader = new AvroColumnReader(new AvroColumnReader.Params(this.countFiles).setModel((GenericData)SpecificData.get()));
        int numWords = 0;
        for (Pair wc : reader) {
            Assertions.assertEquals((Long)COUNTS.get(wc.key()), (Long)((Long)wc.value()), (String)((String)wc.key()));
            ++numWords;
        }
        reader.close();
        Assertions.assertEquals((int)COUNTS.size(), (int)numWords);
    }

    public void validateCountsFileGenericRecord() throws Exception {
        AvroColumnReader reader = new AvroColumnReader(new AvroColumnReader.Params(this.countFiles).setModel((GenericData)SpecificData.get()));
        int numWords = 0;
        for (GenericRecord wc : reader) {
            Assertions.assertEquals((Object)COUNTS.get(wc.get("key")), (Object)wc.get("value"), (String)((String)wc.get("key")));
            ++numWords;
        }
        reader.close();
        Assertions.assertEquals((int)COUNTS.size(), (int)numWords);
    }

    static {
        long total = 0L;
        for (String line : LINES) {
            StringTokenizer tokens = new StringTokenizer(line);
            while (tokens.hasMoreTokens()) {
                String word = tokens.nextToken();
                long count = COUNTS.getOrDefault(word, 0L);
                ++total;
                COUNTS.put(word, ++count);
            }
        }
        TOTAL = total;
    }
}

