/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.avro.util.UtfTextUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UtfTextUtilsTest {
    UtfTextUtilsTest() {
    }

    @Test
    void validateCharsetDetectionWithBOM() {
        Assertions.assertEquals((Object)"UTF-32", (Object)this.testDetection("0000FEFF").name());
        Assertions.assertEquals((Object)"UTF-32", (Object)this.testDetection("FFFE0000").name());
        Assertions.assertEquals((Object)"UTF-16", (Object)this.testDetection("FEFF0041").name());
        Assertions.assertEquals((Object)"UTF-16", (Object)this.testDetection("FFFE4100").name());
        Assertions.assertEquals((Object)"UTF-8", (Object)this.testDetection("EFBBBF41").name());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testDetection("0000FFFE"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testDetection("FEFF0000"));
    }

    @Test
    void validateCharsetDetectionWithoutBOM() {
        Assertions.assertEquals((Object)"UTF-32BE", (Object)this.testDetection("00000041").name());
        Assertions.assertEquals((Object)"UTF-32LE", (Object)this.testDetection("41000000").name());
        Assertions.assertEquals((Object)"UTF-16BE", (Object)this.testDetection("00410042").name());
        Assertions.assertEquals((Object)"UTF-16LE", (Object)this.testDetection("41004200").name());
        Assertions.assertEquals((Object)"UTF-8", (Object)this.testDetection("41424344").name());
        Assertions.assertEquals((Object)"UTF-8", (Object)this.testDetection("414243").name());
        Assertions.assertEquals((Object)"UTF-16BE", (Object)this.testDetection("0041").name());
        Assertions.assertEquals((Object)"UTF-16LE", (Object)this.testDetection("4100").name());
        Assertions.assertEquals((Object)"UTF-8", (Object)this.testDetection("4142").name());
        Assertions.assertEquals((Object)"UTF-8", (Object)this.testDetection("41").name());
        Assertions.assertEquals((Object)"UTF-8", (Object)this.testDetection("").name());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testDetection("00004100"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.testDetection("00410000"));
    }

    private Charset testDetection(String hexBytes) {
        return UtfTextUtils.detectUtfCharset((byte[])UtfTextUtilsTest.hexBytes(hexBytes));
    }

    private static byte[] hexBytes(String hexBytes) {
        byte[] bytes = new byte[hexBytes.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int index = i * 2;
            bytes[i] = (byte)Integer.parseUnsignedInt(hexBytes.substring(index, index + 2), 16);
        }
        return bytes;
    }

    @Test
    void validateTextConversionFromBytes() {
        Assertions.assertEquals((Object)"A", (Object)UtfTextUtils.asString((byte[])UtfTextUtilsTest.hexBytes("EFBBBF41"), (Charset)StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"A", (Object)UtfTextUtils.asString((byte[])UtfTextUtilsTest.hexBytes("EFBBBF41"), null));
        Assertions.assertEquals((Object)"A", (Object)UtfTextUtils.asString((byte[])UtfTextUtilsTest.hexBytes("41"), (Charset)StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"A", (Object)UtfTextUtils.asString((byte[])UtfTextUtilsTest.hexBytes("41"), null));
    }

    @Test
    void validateTextConversionFromStreams() throws IOException {
        Assertions.assertEquals((Object)"A", (Object)UtfTextUtils.readAllBytes((InputStream)new ByteArrayInputStream(UtfTextUtilsTest.hexBytes("EFBBBF41")), (Charset)StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"A", (Object)UtfTextUtils.readAllBytes((InputStream)new ByteArrayInputStream(UtfTextUtilsTest.hexBytes("EFBBBF41")), null));
        Assertions.assertEquals((Object)"A", (Object)UtfTextUtils.readAllBytes((InputStream)new ByteArrayInputStream(UtfTextUtilsTest.hexBytes("41")), (Charset)StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"A", (Object)UtfTextUtils.readAllBytes((InputStream)new ByteArrayInputStream(UtfTextUtilsTest.hexBytes("41")), null));
        Assertions.assertThrows(IOException.class, () -> UtfTextUtils.readAllBytes((InputStream)new ByteArrayInputStream(UtfTextUtilsTest.hexBytes("0000FFFE")), null));
    }

    @Test
    void validateSupportForUnmarkableStreams() throws IOException {
        Assertions.assertEquals((Object)"ABCD", (Object)UtfTextUtils.readAllBytes((InputStream)new UnmarkableInputStream(new ByteArrayInputStream(UtfTextUtilsTest.hexBytes("41424344"))), null));
    }

    private static class UnmarkableInputStream
    extends FilterInputStream {
        public UnmarkableInputStream(InputStream input) {
            super(input);
        }

        @Override
        public synchronized void mark(int ignored) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

