/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.int$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSpecificData {
    private Class<?> intClass;
    private Class<?> integerClass;

    @BeforeEach
    public void setUp() {
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        this.intClass = SpecificData.get().getClass(intSchema);
        Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        Schema nullIntUnionSchema = Schema.createUnion(Arrays.asList(nullSchema, intSchema));
        this.integerClass = SpecificData.get().getClass(nullIntUnionSchema);
    }

    @Test
    void classTypes() {
        Assertions.assertTrue((boolean)this.intClass.isPrimitive());
        Assertions.assertFalse((boolean)this.integerClass.isPrimitive());
    }

    @Test
    void primitiveParam() throws Exception {
        Assertions.assertNotNull((Object)Reflection.class.getMethod("primitive", this.intClass));
    }

    @Test
    void primitiveParamError() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> Reflection.class.getMethod("primitiveWrapper", this.intClass));
    }

    @Test
    void primitiveWrapperParam() throws Exception {
        Assertions.assertNotNull((Object)Reflection.class.getMethod("primitiveWrapper", this.integerClass));
    }

    @Test
    void primitiveWrapperParamError() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> Reflection.class.getMethod("primitive", this.integerClass));
    }

    @Test
    void specificRecordBase() {
        TestRecord record = new TestRecord();
        record.put("x", 1);
        record.put("y", "str");
        Assertions.assertEquals((Object)1, (Object)record.get("x"));
        Assertions.assertEquals((Object)"str", (Object)record.get("y"));
    }

    @Test
    void externalizeable() throws Exception {
        TestRecord before = new TestRecord();
        before.put("x", 1);
        before.put("y", "str");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject((Object)before);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
        TestRecord after = (TestRecord)((Object)in.readObject());
        Assertions.assertEquals((Object)((Object)before), (Object)((Object)after));
    }

    @Test
    void nonStringable() throws Exception {
        Schema string = Schema.create((Schema.Type)Schema.Type.STRING);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)baos, null);
        SpecificDatumWriter writer = new SpecificDatumWriter(string);
        try {
            writer.write(new Object(), (Encoder)encoder);
            Assertions.fail((String)"Non stringable object should be rejected.");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    void testToByteArray() throws Exception {
        Schema string = Schema.create((Schema.Type)Schema.Type.STRING);
        SpecificDatumWriter writer = new SpecificDatumWriter(string);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)baos, null);
            writer.write((Object)"test", (Encoder)encoder);
            byte[] bytes = writer.toByteArray((Object)"test");
            Assertions.assertArrayEquals((byte[])baos.toByteArray(), (byte[])bytes);
        }
    }

    @Test
    void classNameContainingReservedWords() {
        Schema schema = Schema.createRecord((String)"AnyName", null, (String)"db.public.table", (boolean)false);
        Assertions.assertEquals((Object)"db.public$.table.AnyName", (Object)SpecificData.getClassName((Schema)schema));
    }

    @Test
    void testCanGetClassOfMangledType() {
        Assertions.assertEquals((Object)"org.apache.avro.specific.int$", (Object)SpecificData.getClassName((Schema)int$.getClassSchema()));
    }

    static class Reflection {
        Reflection() {
        }

        public void primitive(int i) {
        }

        public void primitiveWrapper(Integer i) {
        }
    }

    public static class TestRecord
    extends SpecificRecordBase {
        private static final Schema SCHEMA = Schema.createRecord((String)"TestRecord", null, null, (boolean)false);
        private int x;
        private String y;

        public void put(int i, Object v) {
            switch (i) {
                case 0: {
                    this.x = (Integer)v;
                    break;
                }
                case 1: {
                    this.y = (String)v;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        public Object get(int i) {
            switch (i) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
            }
            throw new RuntimeException();
        }

        public Schema getSchema() {
            return SCHEMA;
        }

        static {
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            fields.add(new Schema.Field("x", Schema.create((Schema.Type)Schema.Type.INT), null, null));
            Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
            GenericData.setStringType((Schema)stringSchema, (GenericData.StringType)GenericData.StringType.String);
            fields.add(new Schema.Field("y", stringSchema, null, null));
            SCHEMA.setFields(fields);
        }
    }
}

