/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.FieldAccessReflect;
import org.apache.avro.reflect.RecordWithStringUUID;
import org.apache.avro.reflect.RecordWithTimestamps;
import org.apache.avro.reflect.RecordWithUUID;
import org.apache.avro.reflect.RecordWithUUIDArray;
import org.apache.avro.reflect.RecordWithUUIDList;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestReflectLogicalTypes {
    @TempDir
    public File temp;
    public static final ReflectData REFLECT = new ReflectData();

    @BeforeAll
    public static void addUUID() {
        REFLECT.addLogicalTypeConversion((Conversion)new Conversions.UUIDConversion());
        REFLECT.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        REFLECT.addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMillisConversion());
    }

    @Test
    void reflectedSchema() {
        Schema expected = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDList.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        expected.getField("uuids").schema().addProp("java-class", List.class.getName());
        LogicalTypes.uuid().addToSchema(expected.getField("uuids").schema().getElementType());
        Schema actual = REFLECT.getSchema(RecordWithUUIDList.class);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"Should use the UUID logical type");
    }

    @Test
    void decimalBytes() throws IOException {
        Schema schema = REFLECT.getSchema(DecimalRecordBytes.class);
        Assertions.assertEquals((Object)"org.apache.avro.reflect.TestReflectLogicalTypes", (Object)schema.getNamespace(), (String)"Should have the correct record name");
        Assertions.assertEquals((Object)"DecimalRecordBytes", (Object)schema.getName(), (String)"Should have the correct record name");
        Assertions.assertEquals((Object)LogicalTypes.decimal((int)9, (int)2), (Object)LogicalTypes.fromSchema((Schema)schema.getField("decimal").schema()), (String)"Should have the correct logical type");
        DecimalRecordBytes record = new DecimalRecordBytes();
        record.decimal = new BigDecimal("3.14");
        File test = this.write((GenericData)REFLECT, schema, record);
        Assertions.assertEquals(Collections.singletonList(record), TestReflectLogicalTypes.read(REFLECT.createDatumReader(schema), test), (String)"Should match the decimal after round trip");
    }

    @Test
    void decimalFixed() throws IOException {
        Schema schema = REFLECT.getSchema(DecimalRecordFixed.class);
        Assertions.assertEquals((Object)"org.apache.avro.reflect.TestReflectLogicalTypes", (Object)schema.getNamespace(), (String)"Should have the correct record name");
        Assertions.assertEquals((Object)"DecimalRecordFixed", (Object)schema.getName(), (String)"Should have the correct record name");
        Assertions.assertEquals((Object)LogicalTypes.decimal((int)9, (int)2), (Object)LogicalTypes.fromSchema((Schema)schema.getField("decimal").schema()), (String)"Should have the correct logical type");
        DecimalRecordFixed record = new DecimalRecordFixed();
        record.decimal = new BigDecimal("3.14");
        File test = this.write((GenericData)REFLECT, schema, record);
        Assertions.assertEquals(Collections.singletonList(record), TestReflectLogicalTypes.read(REFLECT.createDatumReader(schema), test), (String)"Should match the decimal after round trip");
    }

    @Test
    void pairRecord() throws IOException {
        ReflectData model = new ReflectData();
        model.addLogicalTypeConversion((Conversion)new Conversion<Pair>(){

            public Class<Pair> getConvertedType() {
                return Pair.class;
            }

            public String getLogicalTypeName() {
                return "pair";
            }

            public Pair fromRecord(IndexedRecord value, Schema schema, LogicalType type) {
                return Pair.of(value.get(0), value.get(1));
            }

            public IndexedRecord toRecord(Pair value, Schema schema, LogicalType type) {
                GenericData.Record record = new GenericData.Record(schema);
                record.put(0, value.first);
                record.put(1, value.second);
                return record;
            }
        });
        LogicalTypes.register((String)"pair", (LogicalTypes.LogicalTypeFactory)new LogicalTypes.LogicalTypeFactory(){
            private final LogicalType pair = new LogicalType("pair");

            public LogicalType fromSchema(Schema schema) {
                return this.pair;
            }

            public String getTypeName() {
                return "pair";
            }
        });
        Schema schema = model.getSchema(PairRecord.class);
        Assertions.assertEquals((Object)"org.apache.avro.reflect.TestReflectLogicalTypes", (Object)schema.getNamespace(), (String)"Should have the correct record name");
        Assertions.assertEquals((Object)"PairRecord", (Object)schema.getName(), (String)"Should have the correct record name");
        Assertions.assertEquals((Object)"pair", (Object)LogicalTypes.fromSchema((Schema)schema.getField("pair").schema()).getName(), (String)"Should have the correct logical type");
        PairRecord record = new PairRecord();
        record.pair = Pair.of(34L, 35L);
        ArrayList<PairRecord> expected = new ArrayList<PairRecord>();
        expected.add(record);
        File test = this.write((GenericData)model, schema, record);
        Pair<Long, Long> actual = ((PairRecord)TestReflectLogicalTypes.read(model.createDatumReader((Schema)schema), (File)test).get((int)0)).pair;
        Assertions.assertEquals((long)34L, (long)((Long)actual.first), (String)"Data should match after serialization round-trip");
        Assertions.assertEquals((long)35L, (long)((Long)actual.second), (String)"Data should match after serialization round-trip");
    }

    @Test
    void readUUID() throws IOException {
        Schema uuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithStringUUID r1 = new RecordWithStringUUID();
        r1.uuid = u1.toString();
        RecordWithStringUUID r2 = new RecordWithStringUUID();
        r2.uuid = u2.toString();
        List<RecordWithUUID> expected = Arrays.asList(new RecordWithUUID(), new RecordWithUUID());
        expected.get((int)0).uuid = u1;
        expected.get((int)1).uuid = u2;
        File test = this.write(ReflectData.get().getSchema(RecordWithStringUUID.class), r1, r2);
        Assertions.assertEquals(expected, TestReflectLogicalTypes.read(REFLECT.createDatumReader(uuidSchema), test), (String)"Should convert Strings to UUIDs");
        Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidStringSchema.getField("uuid").schema());
        Assertions.assertEquals(Arrays.asList(r1, r2), TestReflectLogicalTypes.read(REFLECT.createDatumReader(uuidStringSchema), test), (String)"Should not convert to UUID if accessor is String");
    }

    @Test
    void writeUUID() throws IOException {
        Schema uuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithUUID r1 = new RecordWithUUID();
        r1.uuid = u1;
        RecordWithUUID r2 = new RecordWithUUID();
        r2.uuid = u2;
        List<RecordWithStringUUID> expected = Arrays.asList(new RecordWithStringUUID(), new RecordWithStringUUID());
        expected.get((int)0).uuid = u1.toString();
        expected.get((int)1).uuid = u2.toString();
        File test = this.write((GenericData)REFLECT, uuidSchema, r1, r2);
        Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
        Assertions.assertEquals(expected, TestReflectLogicalTypes.read(REFLECT.createDatumReader(uuidStringSchema), test), (String)"Should read uuid as String without UUID conversion");
        LogicalTypes.uuid().addToSchema(uuidStringSchema.getField("uuid").schema());
        Assertions.assertEquals(expected, TestReflectLogicalTypes.read(ReflectData.get().createDatumReader(uuidStringSchema), test), (String)"Should read uuid as String without UUID logical type");
    }

    @Test
    void writeNullableUUID() throws IOException {
        Schema nullableUuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().optionalString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema((Schema)nullableUuidSchema.getField("uuid").schema().getTypes().get(1));
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithUUID r1 = new RecordWithUUID();
        r1.uuid = u1;
        RecordWithUUID r2 = new RecordWithUUID();
        r2.uuid = u2;
        List<RecordWithStringUUID> expected = Arrays.asList(new RecordWithStringUUID(), new RecordWithStringUUID());
        expected.get((int)0).uuid = u1.toString();
        expected.get((int)1).uuid = u2.toString();
        File test = this.write((GenericData)REFLECT, nullableUuidSchema, r1, r2);
        Schema nullableUuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().optionalString("uuid").endRecord();
        Assertions.assertEquals(expected, TestReflectLogicalTypes.read(ReflectData.get().createDatumReader(nullableUuidStringSchema), test), (String)"Should read uuid as String without UUID conversion");
    }

    @Test
    void writeNullableUUIDReadRequiredString() throws IOException {
        Schema nullableUuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().optionalString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema((Schema)nullableUuidSchema.getField("uuid").schema().getTypes().get(1));
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithUUID r1 = new RecordWithUUID();
        r1.uuid = u1;
        RecordWithUUID r2 = new RecordWithUUID();
        r2.uuid = u2;
        List<RecordWithStringUUID> expected = Arrays.asList(new RecordWithStringUUID(), new RecordWithStringUUID());
        expected.get((int)0).uuid = u1.toString();
        expected.get((int)1).uuid = u2.toString();
        File test = this.write((GenericData)REFLECT, nullableUuidSchema, r1, r2);
        Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
        Assertions.assertEquals(expected, TestReflectLogicalTypes.read(REFLECT.createDatumReader(uuidStringSchema), test), (String)"Should read uuid as String without UUID conversion");
    }

    @Test
    void readUUIDMissingLogicalTypeReflect() throws IOException {
        Assumptions.assumeTrue((boolean)(ReflectionUtil.getFieldAccess() instanceof FieldAccessReflect));
        Schema uuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        UUID u1 = UUID.randomUUID();
        RecordWithStringUUID r1 = new RecordWithStringUUID();
        r1.uuid = u1.toString();
        File test = this.write(ReflectData.get().getSchema(RecordWithStringUUID.class), r1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> TestReflectLogicalTypes.read(ReflectData.get().createDatumReader(uuidSchema), test).get(0));
    }

    @Test
    void writeUUIDMissingLogicalType() throws IOException {
        Assertions.assertThrows(DataFileWriter.AppendWriteException.class, () -> {
            Schema uuidSchema = (Schema)SchemaBuilder.record((String)RecordWithUUID.class.getName()).fields().requiredString("uuid").endRecord();
            LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
            UUID u1 = UUID.randomUUID();
            UUID u2 = UUID.randomUUID();
            RecordWithUUID r1 = new RecordWithUUID();
            r1.uuid = u1;
            RecordWithUUID r2 = new RecordWithUUID();
            r2.uuid = u2;
            File test = this.write(uuidSchema, r1, r2);
            Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
            TestReflectLogicalTypes.read(ReflectData.get().createDatumReader(uuidStringSchema), test);
        });
    }

    @Test
    void readUUIDGenericRecord() throws IOException {
        Schema uuidSchema = (Schema)SchemaBuilder.record((String)"RecordWithUUID").fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        RecordWithStringUUID r1 = new RecordWithStringUUID();
        r1.uuid = u1.toString();
        RecordWithStringUUID r2 = new RecordWithStringUUID();
        r2.uuid = u2.toString();
        List<GenericData.Record> expected = Arrays.asList(new GenericData.Record(uuidSchema), new GenericData.Record(uuidSchema));
        expected.get(0).put("uuid", (Object)u1);
        expected.get(1).put("uuid", (Object)u2);
        File test = this.write(ReflectData.get().getSchema(RecordWithStringUUID.class), r1, r2);
        Assertions.assertEquals(expected, TestReflectLogicalTypes.read(REFLECT.createDatumReader(uuidSchema), test), (String)"Should convert Strings to UUIDs");
        Schema uuidStringSchema = (Schema)SchemaBuilder.record((String)RecordWithStringUUID.class.getName()).fields().requiredString("uuid").endRecord();
        LogicalTypes.uuid().addToSchema(uuidSchema.getField("uuid").schema());
        Assertions.assertEquals(Arrays.asList(r1, r2), TestReflectLogicalTypes.read(REFLECT.createDatumReader(uuidStringSchema), test), (String)"Should not convert to UUID if accessor is String");
    }

    @Test
    void readUUIDArray() throws IOException {
        Schema uuidArraySchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDArray.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        LogicalTypes.uuid().addToSchema(uuidArraySchema.getField("uuids").schema().getElementType());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        GenericData.Record r = new GenericData.Record(uuidArraySchema);
        r.put("uuids", Arrays.asList(u1.toString(), u2.toString()));
        RecordWithUUIDArray expected = new RecordWithUUIDArray();
        expected.uuids = new UUID[]{u1, u2};
        File test = this.write(uuidArraySchema, r);
        Assertions.assertEquals((Object)expected, TestReflectLogicalTypes.read(REFLECT.createDatumReader(uuidArraySchema), test).get(0), (String)"Should convert Strings to UUIDs");
    }

    @Test
    void writeUUIDArray() throws IOException {
        Schema uuidArraySchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDArray.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        LogicalTypes.uuid().addToSchema(uuidArraySchema.getField("uuids").schema().getElementType());
        Schema stringArraySchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"RecordWithUUIDArray").fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        stringArraySchema.getField("uuids").schema().addProp("java-class", List.class.getName());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        GenericData.Record expected = new GenericData.Record(stringArraySchema);
        ArrayList<String> uuids = new ArrayList<String>();
        uuids.add(u1.toString());
        uuids.add(u2.toString());
        expected.put("uuids", uuids);
        RecordWithUUIDArray r = new RecordWithUUIDArray();
        r.uuids = new UUID[]{u1, u2};
        File test = this.write((GenericData)REFLECT, uuidArraySchema, r);
        Assertions.assertEquals((Object)expected, TestReflectLogicalTypes.read(ReflectData.get().createDatumReader(stringArraySchema), test).get(0), (String)"Should read UUIDs as Strings");
    }

    @Test
    void readUUIDList() throws IOException {
        Schema uuidListSchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDList.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        uuidListSchema.getField("uuids").schema().addProp("java-class", List.class.getName());
        LogicalTypes.uuid().addToSchema(uuidListSchema.getField("uuids").schema().getElementType());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        GenericData.Record r = new GenericData.Record(uuidListSchema);
        r.put("uuids", Arrays.asList(u1.toString(), u2.toString()));
        RecordWithUUIDList expected = new RecordWithUUIDList();
        expected.uuids = Arrays.asList(u1, u2);
        File test = this.write(uuidListSchema, r);
        Assertions.assertEquals((Object)expected, TestReflectLogicalTypes.read(REFLECT.createDatumReader(uuidListSchema), test).get(0), (String)"Should convert Strings to UUIDs");
    }

    @Test
    void writeUUIDList() throws IOException {
        Schema uuidListSchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)RecordWithUUIDList.class.getName()).fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        uuidListSchema.getField("uuids").schema().addProp("java-class", List.class.getName());
        LogicalTypes.uuid().addToSchema(uuidListSchema.getField("uuids").schema().getElementType());
        Schema stringArraySchema = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"RecordWithUUIDArray").fields().name("uuids").type().array().items().stringType()).noDefault().endRecord();
        stringArraySchema.getField("uuids").schema().addProp("java-class", List.class.getName());
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        GenericData.Record expected = new GenericData.Record(stringArraySchema);
        expected.put("uuids", Arrays.asList(u1.toString(), u2.toString()));
        RecordWithUUIDList r = new RecordWithUUIDList();
        r.uuids = Arrays.asList(u1, u2);
        File test = this.write((GenericData)REFLECT, uuidListSchema, r);
        Assertions.assertEquals((Object)expected, TestReflectLogicalTypes.read(REFLECT.createDatumReader(stringArraySchema), test).get(0), (String)"Should read UUIDs as Strings");
    }

    @Test
    void reflectedSchemaLocalDateTime() {
        Schema actual = REFLECT.getSchema(RecordWithTimestamps.class);
        Assertions.assertEquals((Object)"org.apache.avro.reflect", (Object)actual.getNamespace(), (String)"Should have the correct record name");
        Assertions.assertEquals((Object)"RecordWithTimestamps", (Object)actual.getName(), (String)"Should have the correct record name");
        Assertions.assertEquals((Object)Schema.Type.LONG, (Object)actual.getField("localDateTime").schema().getType(), (String)"Should have the correct physical type");
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)LogicalTypes.fromSchema((Schema)actual.getField("localDateTime").schema()), (String)"Should have the correct logical type");
    }

    private static <D> List<D> read(DatumReader<D> reader, File file) throws IOException {
        ArrayList data = new ArrayList();
        try (DataFileReader fileReader = new DataFileReader(file, reader);){
            for (Object datum : fileReader) {
                data.add(datum);
            }
        }
        return data;
    }

    private <D> File write(Schema schema, D ... data) throws IOException {
        return this.write((GenericData)ReflectData.get(), schema, data);
    }

    private <D> File write(GenericData model, Schema schema, D ... data) throws IOException {
        File file = File.createTempFile("junit", null, this.temp);
        DatumWriter writer = model.createDatumWriter(schema);
        try (DataFileWriter fileWriter = new DataFileWriter(writer);){
            fileWriter.create(schema, file);
            for (D datum : data) {
                fileWriter.append(datum);
            }
        }
        return file;
    }

    public static class DecimalRecordBytes {
        @AvroSchema(value="{\"type\": \"bytes\",\"logicalType\": \"decimal\",\"precision\": 9,\"scale\": 2}")
        private BigDecimal decimal;

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DecimalRecordBytes that = (DecimalRecordBytes)other;
            if (this.decimal == null) {
                return that.decimal == null;
            }
            return this.decimal.equals(that.decimal);
        }

        public int hashCode() {
            return this.decimal != null ? this.decimal.hashCode() : 0;
        }
    }

    public static class DecimalRecordFixed {
        @AvroSchema(value="{\"name\": \"decimal_9\",\"type\": \"fixed\",\"size\": 4,\"logicalType\": \"decimal\",\"precision\": 9,\"scale\": 2}")
        private BigDecimal decimal;

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DecimalRecordFixed that = (DecimalRecordFixed)other;
            if (this.decimal == null) {
                return that.decimal == null;
            }
            return this.decimal.equals(that.decimal);
        }

        public int hashCode() {
            return this.decimal != null ? this.decimal.hashCode() : 0;
        }
    }

    public static class PairRecord {
        @AvroSchema(value="{\"name\": \"Pair\",\"type\": \"record\",\"fields\": [    {\"name\": \"x\", \"type\": \"long\"},    {\"name\": \"y\", \"type\": \"long\"}  ],\"logicalType\": \"pair\"}")
        Pair<Long, Long> pair;
    }

    public static class Pair<X, Y> {
        private final X first;
        private final Y second;

        private Pair(X first, Y second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Pair that = (Pair)other;
            if (this.first == null ? that.first != null : this.first.equals(that.first)) {
                return false;
            }
            if (this.second == null) {
                return that.second == null;
            }
            return !this.second.equals(that.second);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.first, this.second});
        }

        public static <X, Y> Pair<X, Y> of(X first, Y second) {
            return new Pair<X, Y>(first, second);
        }
    }
}

