/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io.parsing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.apache.avro.io.parsing.Symbol;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestResolvingGrammarGenerator2 {
    Schema point2dFullname = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Point").namespace("written")).fields().requiredDouble("x").requiredDouble("y").endRecord();
    Schema point3dNoDefault = (Schema)SchemaBuilder.record((String)"Point").fields().requiredDouble("x").requiredDouble("y").requiredDouble("z").endRecord();
    Schema point2d = (Schema)SchemaBuilder.record((String)"Point2D").fields().requiredDouble("x").requiredDouble("y").endRecord();
    Schema point3d = (Schema)SchemaBuilder.record((String)"Point3D").fields().requiredDouble("x").requiredDouble("y").name("z").type().doubleType().doubleDefault(0.0).endRecord();
    Schema point3dMatchName = (Schema)SchemaBuilder.record((String)"Point").fields().requiredDouble("x").requiredDouble("y").name("z").type().doubleType().doubleDefault(0.0).endRecord();

    @Test
    void fixed() throws IOException {
        new ResolvingGrammarGenerator().generate(Schema.createFixed((String)"MyFixed", null, null, (int)10), Schema.create((Schema.Type)Schema.Type.BYTES));
        new ResolvingGrammarGenerator().generate(Schema.create((Schema.Type)Schema.Type.BYTES), Schema.createFixed((String)"MyFixed", null, null, (int)10));
    }

    @Test
    void unionResolutionNoStructureMatch() throws Exception {
        Assertions.assertThrows(SchemaValidationException.class, () -> {
            Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point3dNoDefault));
            new SchemaValidatorBuilder().canBeReadStrategy().validateAll().validate(this.point2dFullname, Collections.singletonList(read));
        });
    }

    @Test
    void unionResolutionFirstStructureMatch2d() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point3dNoDefault, this.point2d, this.point3d));
        Symbol grammar = new ResolvingGrammarGenerator().generate(this.point2dFullname, read);
        Assertions.assertTrue((boolean)(grammar.production[1] instanceof Symbol.UnionAdjustAction));
        Symbol.UnionAdjustAction action = (Symbol.UnionAdjustAction)grammar.production[1];
        Assertions.assertEquals((int)2, (int)action.rindex);
    }

    @Test
    void unionResolutionFirstStructureMatch3d() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point3dNoDefault, this.point3d, this.point2d));
        Symbol grammar = new ResolvingGrammarGenerator().generate(this.point2dFullname, read);
        Assertions.assertTrue((boolean)(grammar.production[1] instanceof Symbol.UnionAdjustAction));
        Symbol.UnionAdjustAction action = (Symbol.UnionAdjustAction)grammar.production[1];
        Assertions.assertEquals((int)2, (int)action.rindex);
    }

    @Test
    void unionResolutionNamedStructureMatch() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point2d, this.point3dMatchName, this.point3d));
        Symbol grammar = new ResolvingGrammarGenerator().generate(this.point2dFullname, read);
        Assertions.assertTrue((boolean)(grammar.production[1] instanceof Symbol.UnionAdjustAction));
        Symbol.UnionAdjustAction action = (Symbol.UnionAdjustAction)grammar.production[1];
        Assertions.assertEquals((int)2, (int)action.rindex);
    }

    @Test
    void unionResolutionFullNameMatch() throws Exception {
        Schema read = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), this.point2d, this.point3dMatchName, this.point3d, this.point2dFullname));
        Symbol grammar = new ResolvingGrammarGenerator().generate(this.point2dFullname, read);
        Assertions.assertTrue((boolean)(grammar.production[1] instanceof Symbol.UnionAdjustAction));
        Symbol.UnionAdjustAction action = (Symbol.UnionAdjustAction)grammar.production[1];
        Assertions.assertEquals((int)4, (int)action.rindex);
    }

    @Test
    void avro2702StringProperties() throws IOException {
        Schema inner = (Schema)SchemaBuilder.builder().record("B").fields().requiredString("b1").endRecord();
        Schema outer = (Schema)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)SchemaBuilder.builder().record("A").fields().requiredString("a1").name("inner").type().unionOf().nullType().and().type(inner)).endUnion()).noDefault().endRecord();
        Schema outer2 = new Schema.Parser().parse(outer.toString());
        outer2.getField("a1").schema().addProp("avro.java.string", "String");
        Schema inner2 = (Schema)outer2.getField("inner").schema().getTypes().get(1);
        inner2.getField("b1").schema().addProp("avro.java.string", "String");
        MatcherAssert.assertThat((Object)outer, (Matcher)Matchers.not((Object)outer2));
        byte[] serialized = new byte[]{2, 97, 2, 2, 98};
        GenericRecord out = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)bais, null);
            GenericDatumReader r = new GenericDatumReader(outer, outer2, GenericData.get());
            out = (GenericRecord)r.read(null, (Decoder)decoder);
        }
        MatcherAssert.assertThat((Object)out.get("a1"), (Matcher)Matchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)((GenericRecord)out.get("inner")).get("b1"), (Matcher)Matchers.instanceOf(String.class));
    }
}

