/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.io.Encoder;
import org.apache.avro.util.Utf8;

public class LegacyBinaryEncoder
extends Encoder {
    protected OutputStream out;
    private final ByteWriter byteWriter;

    public LegacyBinaryEncoder(OutputStream out) {
        this.out = out;
        this.byteWriter = new SimpleByteWriter(out);
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void writeNull() throws IOException {
    }

    public void writeBoolean(boolean b) throws IOException {
        this.out.write(b ? 1 : 0);
    }

    public void writeInt(int n) throws IOException {
        LegacyBinaryEncoder.encodeLong(n, this.out);
    }

    public void writeLong(long n) throws IOException {
        LegacyBinaryEncoder.encodeLong(n, this.out);
    }

    public void writeFloat(float f) throws IOException {
        LegacyBinaryEncoder.encodeFloat(f, this.out);
    }

    public void writeDouble(double d) throws IOException {
        LegacyBinaryEncoder.encodeDouble(d, this.out);
    }

    public void writeString(Utf8 utf8) throws IOException {
        this.encodeString(utf8.getBytes(), 0, utf8.getByteLength());
    }

    public void writeString(String string) throws IOException {
        byte[] bytes = Utf8.getBytesFor((String)string);
        this.encodeString(bytes, 0, bytes.length);
    }

    private void encodeString(byte[] bytes, int offset, int length) throws IOException {
        LegacyBinaryEncoder.encodeLong(length, this.out);
        this.out.write(bytes, offset, length);
    }

    public void writeBytes(ByteBuffer bytes) throws IOException {
        this.byteWriter.write(bytes);
    }

    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        LegacyBinaryEncoder.encodeLong(len, this.out);
        this.out.write(bytes, start, len);
    }

    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.out.write(bytes, start, len);
    }

    public void writeEnum(int e) throws IOException {
        LegacyBinaryEncoder.encodeLong(e, this.out);
    }

    public void writeArrayStart() throws IOException {
    }

    public void setItemCount(long itemCount) throws IOException {
        if (itemCount > 0L) {
            this.writeLong(itemCount);
        }
    }

    public void startItem() throws IOException {
    }

    public void writeArrayEnd() throws IOException {
        LegacyBinaryEncoder.encodeLong(0L, this.out);
    }

    public void writeMapStart() throws IOException {
    }

    public void writeMapEnd() throws IOException {
        LegacyBinaryEncoder.encodeLong(0L, this.out);
    }

    public void writeIndex(int unionIndex) throws IOException {
        LegacyBinaryEncoder.encodeLong(unionIndex, this.out);
    }

    protected static void encodeLong(long n, OutputStream o) throws IOException {
        n = n << 1 ^ n >> 63;
        while ((n & 0xFFFFFFFFFFFFFF80L) != 0L) {
            o.write((byte)(n & 0x7FL | 0x80L));
            n >>>= 7;
        }
        o.write((byte)n);
    }

    protected static void encodeFloat(float f, OutputStream o) throws IOException {
        long bits = Float.floatToRawIntBits(f);
        o.write((int)bits & 0xFF);
        o.write((int)(bits >> 8) & 0xFF);
        o.write((int)(bits >> 16) & 0xFF);
        o.write((int)(bits >> 24) & 0xFF);
    }

    protected static void encodeDouble(double d, OutputStream o) throws IOException {
        long bits = Double.doubleToRawLongBits(d);
        o.write((int)bits & 0xFF);
        o.write((int)(bits >> 8) & 0xFF);
        o.write((int)(bits >> 16) & 0xFF);
        o.write((int)(bits >> 24) & 0xFF);
        o.write((int)(bits >> 32) & 0xFF);
        o.write((int)(bits >> 40) & 0xFF);
        o.write((int)(bits >> 48) & 0xFF);
        o.write((int)(bits >> 56) & 0xFF);
    }

    private static final class SimpleByteWriter
    implements ByteWriter {
        private final OutputStream out;

        public SimpleByteWriter(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(ByteBuffer bytes) throws IOException {
            LegacyBinaryEncoder.encodeLong(bytes.remaining(), this.out);
            this.out.write(bytes.array(), bytes.position(), bytes.remaining());
        }
    }

    private static interface ByteWriter {
        public void write(ByteBuffer var1) throws IOException;
    }
}

