/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGenericRecordBuilder {
    @Test
    void genericBuilder() {
        Schema schema = TestGenericRecordBuilder.recordSchema();
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        for (Schema.Field field : schema.getFields()) {
            Assertions.assertFalse((boolean)builder.has(field.name()), (String)("RecordBuilder should not have field " + field.name()));
            Assertions.assertNull((Object)builder.get(field.name()), (String)("Field " + field.name() + " should be null"));
        }
        builder.set("intField", (Object)1);
        List<String> anArray = Arrays.asList("one", "two", "three");
        builder.set("anArray", anArray);
        Assertions.assertTrue((boolean)builder.has("anArray"), (String)"anArray should be set");
        Assertions.assertEquals(anArray, (Object)builder.get("anArray"));
        Assertions.assertFalse((boolean)builder.has("id"), (String)"id should not be set");
        Assertions.assertNull((Object)builder.get("id"));
        GenericData.Record record = builder.build();
        Assertions.assertEquals((Object)1, (Object)record.get("intField"));
        Assertions.assertEquals(anArray, (Object)record.get("anArray"));
        Assertions.assertNotNull((Object)record.get("id"));
        Assertions.assertEquals((Object)"0", (Object)record.get("id").toString());
        Assertions.assertEquals((Object)builder, (Object)new GenericRecordBuilder(builder));
        Assertions.assertEquals((Object)record, (Object)new GenericRecordBuilder(record).build());
        builder.clear("intField");
        Assertions.assertFalse((boolean)builder.has("intField"));
        Assertions.assertNull((Object)builder.get("intField"));
    }

    @Test
    void attemptToSetNonNullableFieldToNull() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> new GenericRecordBuilder(TestGenericRecordBuilder.recordSchema()).set("intField", null));
    }

    @Test
    void buildWithoutSettingRequiredFields1() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> new GenericRecordBuilder(TestGenericRecordBuilder.recordSchema()).build());
    }

    @Test
    void buildWithoutSettingRequiredFields2() {
        try {
            new GenericRecordBuilder(TestGenericRecordBuilder.recordSchema()).set("anArray", Collections.singletonList("one")).build();
            Assertions.fail((String)("Should have thrown " + AvroRuntimeException.class.getCanonicalName()));
        }
        catch (AvroRuntimeException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("intField"));
        }
    }

    private static Schema recordSchema() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), null, (Object)"0"));
        fields.add(new Schema.Field("intField", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        fields.add(new Schema.Field("anArray", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), null, null));
        fields.add(new Schema.Field("optionalInt", Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.INT))), null, (Object)Schema.NULL_VALUE));
        Schema schema = Schema.createRecord((String)"Foo", (String)"test", (String)"mytest", (boolean)false);
        schema.setFields(fields);
        return schema;
    }
}

