/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.UnresolvedUnionException;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGenericDatumWriter {
    @Test
    void unionUnresolvedExceptionExplicitWhichField() throws IOException {
        Schema s = this.schemaWithExplicitNullDefault();
        GenericData.Record r = new GenericData.Record(s);
        r.put("f", (Object)100);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        try {
            new GenericDatumWriter(s).write((Object)r, (Encoder)EncoderFactory.get().jsonEncoder(s, (OutputStream)bao));
            Assertions.fail();
        }
        catch (UnresolvedUnionException uue) {
            Assertions.assertEquals((Object)"Not in union [\"null\",\"string\"]: 100 (field=f)", (Object)uue.getMessage());
        }
    }

    @Test
    void write() throws IOException {
        String json = "{\"type\": \"record\", \"name\": \"r\", \"fields\": [{ \"name\": \"f1\", \"type\": \"long\" }]}";
        Schema s = new Schema.Parser().parse(json);
        GenericData.Record r = new GenericData.Record(s);
        r.put("f1", (Object)100L);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        GenericDatumWriter w = new GenericDatumWriter(s);
        JsonEncoder e = EncoderFactory.get().jsonEncoder(s, (OutputStream)bao);
        w.write((Object)r, (Encoder)e);
        e.flush();
        Object o = new GenericDatumReader(s).read(null, (Decoder)DecoderFactory.get().jsonDecoder(s, (InputStream)new ByteArrayInputStream(bao.toByteArray())));
        Assertions.assertEquals((Object)r, (Object)o);
    }

    @Test
    void arrayConcurrentModification() throws Exception {
        String json = "{\"type\": \"array\", \"items\": \"int\" }";
        Schema s = new Schema.Parser().parse(json);
        GenericData.Array a = new GenericData.Array(1, s);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        GenericDatumWriter w = new GenericDatumWriter(s);
        CountDownLatch sizeWrittenSignal = new CountDownLatch(1);
        CountDownLatch eltAddedSignal = new CountDownLatch(1);
        TestEncoder e = new TestEncoder((Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)bao, null), sizeWrittenSignal, eltAddedSignal);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> result = executor.submit(() -> TestGenericDatumWriter.lambda$arrayConcurrentModification$0(w, (GenericArray)a, e));
        sizeWrittenSignal.await();
        a.add((Object)7);
        eltAddedSignal.countDown();
        try {
            result.get();
            Assertions.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ExecutionException ex) {
            Assertions.assertTrue((boolean)(ex.getCause() instanceof ConcurrentModificationException));
        }
    }

    @Test
    void mapConcurrentModification() throws Exception {
        String json = "{\"type\": \"map\", \"values\": \"int\" }";
        Schema s = new Schema.Parser().parse(json);
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        GenericDatumWriter w = new GenericDatumWriter(s);
        CountDownLatch sizeWrittenSignal = new CountDownLatch(1);
        CountDownLatch eltAddedSignal = new CountDownLatch(1);
        TestEncoder e = new TestEncoder((Encoder)EncoderFactory.get().directBinaryEncoder((OutputStream)bao, null), sizeWrittenSignal, eltAddedSignal);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> result = executor.submit(() -> {
            w.write((Object)m, (Encoder)e);
            return null;
        });
        sizeWrittenSignal.await();
        m.put("a", 7);
        eltAddedSignal.countDown();
        try {
            result.get();
            Assertions.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ExecutionException ex) {
            Assertions.assertTrue((boolean)(ex.getCause() instanceof ConcurrentModificationException));
        }
    }

    @Test
    void allowWritingPrimitives() throws IOException {
        Schema doubleType = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        Schema.Field field = new Schema.Field("double", doubleType);
        List<Schema.Field> fields = Collections.singletonList(field);
        Schema schema = Schema.createRecord((String)"test", (String)"doc", (String)"", (boolean)false, fields);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("double", (Object)456.4);
        record.put("double", (Object)100000L);
        record.put("double", (Object)444);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)bao);
        writer.write((Object)record, (Encoder)encoder);
    }

    @Test
    void writeDoesNotAllowStringForGenericEnum() throws IOException {
        Assertions.assertThrows(AvroTypeException.class, () -> {
            String json = "{\"type\": \"record\", \"name\": \"recordWithEnum\",\"fields\": [ {\"name\": \"field\", \"type\": {\"type\": \"enum\", \"name\": \"enum\", \"symbols\": [\"ONE\",\"TWO\",\"THREE\"] }}]}";
            Schema schema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"recordWithEnum\",\"fields\": [ {\"name\": \"field\", \"type\": {\"type\": \"enum\", \"name\": \"enum\", \"symbols\": [\"ONE\",\"TWO\",\"THREE\"] }}]}");
            GenericData.Record record = new GenericData.Record(schema);
            record.put("field", (Object)"ONE");
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)bao);
            writer.write((Object)record, (Encoder)encoder);
        });
    }

    @Test
    void writeDoesNotAllowJavaEnumForGenericEnum() throws IOException {
        Assertions.assertThrows(AvroTypeException.class, () -> {
            String json = "{\"type\": \"record\", \"name\": \"recordWithEnum\",\"fields\": [ {\"name\": \"field\", \"type\": {\"type\": \"enum\", \"name\": \"enum\", \"symbols\": [\"ONE\",\"TWO\",\"THREE\"] }}]}";
            Schema schema = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"recordWithEnum\",\"fields\": [ {\"name\": \"field\", \"type\": {\"type\": \"enum\", \"name\": \"enum\", \"symbols\": [\"ONE\",\"TWO\",\"THREE\"] }}]}");
            GenericData.Record record = new GenericData.Record(schema);
            record.put("field", (Object)AnEnum.ONE);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)bao);
            writer.write((Object)record, (Encoder)encoder);
        });
    }

    @Test
    void writeFieldWithDefaultWithExplicitNullDefaultInSchema() throws Exception {
        Schema schema = this.schemaWithExplicitNullDefault();
        GenericRecord record = this.createRecordWithDefaultField(schema);
        this.writeObject(record);
    }

    @Test
    void writeFieldWithDefaultWithoutExplicitNullDefaultInSchema() throws Exception {
        Schema schema = this.schemaWithoutExplicitNullDefault();
        GenericRecord record = this.createRecordWithDefaultField(schema);
        this.writeObject(record);
    }

    @Test
    void nestedNPEErrorClarity() throws Exception {
        GenericData.Record topLevelRecord = this.buildComplexRecord();
        Map map = (Map)((GenericData.Record)((List)((GenericData.Record)topLevelRecord.get("unionField")).get("arrayField")).get(0)).get("mapField");
        ((GenericData.Record)map.get("a")).put("strField", null);
        try {
            this.writeObject((GenericRecord)topLevelRecord);
            Assertions.fail((String)"expected to throw");
        }
        catch (NullPointerException expected) {
            Assertions.assertTrue((boolean)expected.getMessage().contains("RecordWithRequiredFields.unionField[UnionRecord].arrayField[0].mapField[\"a\"].strField"), (String)("unexpected message " + expected.getMessage()));
        }
    }

    @Test
    void nPEForMapKeyErrorClarity() throws Exception {
        GenericData.Record topLevelRecord = this.buildComplexRecord();
        Map map = (Map)((GenericData.Record)((List)((GenericData.Record)topLevelRecord.get("unionField")).get("arrayField")).get(0)).get("mapField");
        map.put(null, (GenericData.Record)map.get("a"));
        try {
            this.writeObject((GenericRecord)topLevelRecord);
            Assertions.fail((String)"expected to throw");
        }
        catch (NullPointerException expected) {
            Assertions.assertTrue((boolean)expected.getMessage().contains("null key in map at RecordWithRequiredFields.unionField[UnionRecord].arrayField[0].mapField"), (String)("unexpected message " + expected.getMessage()));
        }
    }

    @Test
    void shortPathNPEErrorClarity() throws Exception {
        try {
            this.writeObject(Schema.create((Schema.Type)Schema.Type.STRING), null);
            Assertions.fail((String)"expected to throw");
        }
        catch (NullPointerException expected) {
            Assertions.assertTrue((boolean)expected.getMessage().contains("null value for (non-nullable) string"), (String)("unexpected message " + expected.getMessage()));
        }
    }

    @Test
    void nestedCCEErrorClarity() throws Exception {
        GenericData.Record topLevelRecord = this.buildComplexRecord();
        Map map = (Map)((GenericData.Record)((List)((GenericData.Record)topLevelRecord.get("unionField")).get("arrayField")).get(0)).get("mapField");
        ((GenericData.Record)map.get("a")).put("strField", (Object)42);
        try {
            this.writeObject((GenericRecord)topLevelRecord);
            Assertions.fail((String)"expected to throw");
        }
        catch (ClassCastException expected) {
            Assertions.assertTrue((boolean)expected.getMessage().contains("RecordWithRequiredFields.unionField[UnionRecord].arrayField[0].mapField[\"a\"].strField"), (String)("unexpected message " + expected.getMessage()));
        }
    }

    @Test
    void shortPathCCEErrorClarity() throws Exception {
        try {
            this.writeObject(Schema.create((Schema.Type)Schema.Type.STRING), 42);
            Assertions.fail((String)"expected to throw");
        }
        catch (ClassCastException expected) {
            Assertions.assertTrue((boolean)expected.getMessage().contains("value 42 (a java.lang.Integer) cannot be cast to expected type string"), (String)("unexpected message " + expected.getMessage()));
        }
    }

    @Test
    void nestedATEErrorClarity() throws Exception {
        GenericData.Record topLevelRecord = this.buildComplexRecord();
        Map map = (Map)((GenericData.Record)((List)((GenericData.Record)topLevelRecord.get("unionField")).get("arrayField")).get(0)).get("mapField");
        ((GenericData.Record)map.get("a")).put("enumField", (Object)42);
        try {
            this.writeObject((GenericRecord)topLevelRecord);
            Assertions.fail((String)"expected to throw");
        }
        catch (AvroTypeException expected) {
            Assertions.assertTrue((boolean)expected.getMessage().contains("RecordWithRequiredFields.unionField[UnionRecord].arrayField[0].mapField[\"a\"].enumField"), (String)("unexpected message " + expected.getMessage()));
            Assertions.assertTrue((boolean)expected.getMessage().contains("42 (a java.lang.Integer) is not a MapRecordEnum"), (String)("unexpected message " + expected.getMessage()));
        }
    }

    private GenericData.Record buildComplexRecord() throws IOException {
        Schema schema = new Schema.Parser().parse(new File("target/test-classes/share/test/schemas/RecordWithRequiredFields.avsc"));
        GenericData.Record topLevelRecord = new GenericData.Record(schema);
        GenericData.Record unionRecord = new GenericData.Record((Schema)schema.getField("unionField").schema().getTypes().get(1));
        Schema arraySchema = unionRecord.getSchema().getField("arrayField").schema();
        GenericData.Record arrayRecord1 = new GenericData.Record(arraySchema.getElementType());
        GenericData.Record arrayRecord2 = new GenericData.Record(arraySchema.getElementType());
        GenericData.Array array = new GenericData.Array(arraySchema, Arrays.asList(arrayRecord1, arrayRecord2));
        Schema mapRecordSchema = arraySchema.getElementType().getField("mapField").schema().getValueType();
        GenericData.Record mapRecordA = new GenericData.Record(mapRecordSchema);
        Schema mapRecordEnumSchema = mapRecordSchema.getField("enumField").schema();
        mapRecordA.put("enumField", (Object)new GenericData.EnumSymbol(mapRecordEnumSchema, "B"));
        mapRecordA.put("strField", (Object)"4");
        arrayRecord1.put("strField", (Object)"2");
        HashMap<String, GenericData.Record> map1 = new HashMap<String, GenericData.Record>();
        map1.put("a", mapRecordA);
        arrayRecord1.put("mapField", map1);
        arrayRecord2.put("strField", (Object)"2");
        HashMap<String, GenericData.Record> map2 = new HashMap<String, GenericData.Record>();
        map2.put("a", mapRecordA);
        arrayRecord2.put("mapField", map2);
        unionRecord.put(unionRecord.getSchema().getField("strField").pos(), (Object)"1");
        unionRecord.put(unionRecord.getSchema().getField("arrayField").pos(), (Object)array);
        topLevelRecord.put(topLevelRecord.getSchema().getField("strField").pos(), (Object)"0");
        topLevelRecord.put(topLevelRecord.getSchema().getField("unionField").pos(), (Object)unionRecord);
        return topLevelRecord;
    }

    private Schema schemaWithExplicitNullDefault() {
        String schema = "{\"type\":\"record\",\"name\":\"my_record\",\"namespace\":\"mytest.namespace\",\"doc\":\"doc\",\"fields\":[{\"name\":\"f\",\"type\":[\"null\",\"string\"],\"doc\":\"field doc doc\", \"default\":null}]}";
        return new Schema.Parser().parse(schema);
    }

    private Schema schemaWithoutExplicitNullDefault() {
        String schema = "{\"type\":\"record\",\"name\":\"my_record\",\"namespace\":\"mytest.namespace\",\"doc\":\"doc\",\"fields\":[{\"name\":\"f\",\"type\":[\"null\",\"string\"],\"doc\":\"field doc doc\"}]}";
        return new Schema.Parser().parse(schema);
    }

    private void writeObject(GenericRecord datum) throws Exception {
        this.writeObject(datum.getSchema(), datum);
    }

    private void writeObject(Schema schema, Object datum) throws Exception {
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)new ByteArrayOutputStream(), null);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        writer.write(datum, (Encoder)encoder);
        encoder.flush();
    }

    private GenericRecord createRecordWithDefaultField(Schema schema) {
        GenericData.Record record = new GenericData.Record(schema);
        record.put("f", schema.getField("f").defaultVal());
        return record;
    }

    private static /* synthetic */ Void lambda$arrayConcurrentModification$0(GenericDatumWriter w, GenericArray a, TestEncoder e) throws Exception {
        w.write((Object)a, (Encoder)e);
        return null;
    }

    static class TestEncoder
    extends Encoder {
        Encoder e;
        CountDownLatch sizeWrittenSignal;
        CountDownLatch eltAddedSignal;

        TestEncoder(Encoder encoder, CountDownLatch sizeWrittenSignal, CountDownLatch eltAddedSignal) {
            this.e = encoder;
            this.sizeWrittenSignal = sizeWrittenSignal;
            this.eltAddedSignal = eltAddedSignal;
        }

        public void writeArrayStart() throws IOException {
            this.e.writeArrayStart();
            this.sizeWrittenSignal.countDown();
            try {
                this.eltAddedSignal.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void writeMapStart() throws IOException {
            this.e.writeMapStart();
            this.sizeWrittenSignal.countDown();
            try {
                this.eltAddedSignal.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void flush() throws IOException {
            this.e.flush();
        }

        public void writeNull() throws IOException {
            this.e.writeNull();
        }

        public void writeBoolean(boolean b) throws IOException {
            this.e.writeBoolean(b);
        }

        public void writeInt(int n) throws IOException {
            this.e.writeInt(n);
        }

        public void writeLong(long n) throws IOException {
            this.e.writeLong(n);
        }

        public void writeFloat(float f) throws IOException {
            this.e.writeFloat(f);
        }

        public void writeDouble(double d) throws IOException {
            this.e.writeDouble(d);
        }

        public void writeString(Utf8 utf8) throws IOException {
            this.e.writeString(utf8);
        }

        public void writeBytes(ByteBuffer bytes) throws IOException {
            this.e.writeBytes(bytes);
        }

        public void writeBytes(byte[] bytes, int start, int len) throws IOException {
            this.e.writeBytes(bytes, start, len);
        }

        public void writeFixed(byte[] bytes, int start, int len) throws IOException {
            this.e.writeFixed(bytes, start, len);
        }

        public void writeEnum(int en) throws IOException {
            this.e.writeEnum(en);
        }

        public void setItemCount(long itemCount) throws IOException {
            this.e.setItemCount(itemCount);
        }

        public void startItem() throws IOException {
            this.e.startItem();
        }

        public void writeArrayEnd() throws IOException {
            this.e.writeArrayEnd();
        }

        public void writeMapEnd() throws IOException {
            this.e.writeMapEnd();
        }

        public void writeIndex(int unionIndex) throws IOException {
            this.e.writeIndex(unionIndex);
        }
    }

    private static enum AnEnum {
        ONE,
        TWO,
        THREE;

    }
}

