/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import org.apache.avro.Schema;
import org.apache.avro.generic.PrimitivesArrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PrimitivesArraysTest {
    PrimitivesArraysTest() {
    }

    @Test
    void booleanArray() {
        int i;
        PrimitivesArrays.BooleanArray ba = new PrimitivesArrays.BooleanArray(4, Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.BOOLEAN)));
        Assertions.assertEquals((int)0, (int)ba.size());
        for (i = 1; i < 100; ++i) {
            if (i % 3 == 0 || i % 5 == 0) {
                ba.add(true);
                continue;
            }
            ba.add(false);
        }
        Assertions.assertEquals((int)99, (int)ba.size());
        for (i = 1; i < 100; ++i) {
            if (i % 3 == 0 || i % 5 == 0) {
                Assertions.assertTrue((boolean)ba.get(i - 1), (String)("Error for " + i));
                continue;
            }
            Assertions.assertFalse((boolean)ba.get(i - 1), (String)("Error for " + i));
        }
        Assertions.assertFalse((boolean)ba.remove(12));
        Assertions.assertEquals((int)98, (int)ba.size());
        for (i = 13; i < 99; ++i) {
            if ((i + 1) % 3 == 0 || (i + 1) % 5 == 0) {
                Assertions.assertTrue((boolean)ba.get(i - 1), (String)("After delete, Error for " + i));
                continue;
            }
            Assertions.assertFalse((boolean)ba.get(i - 1), (String)("After delete, Error for " + i));
        }
        ba.add(12, false);
        Assertions.assertEquals((int)99, (int)ba.size());
        for (i = 1; i < 100; ++i) {
            if (i % 3 == 0 || i % 5 == 0) {
                Assertions.assertTrue((boolean)ba.get(i - 1), (String)("Error for " + i));
                continue;
            }
            Assertions.assertFalse((boolean)ba.get(i - 1), (String)("Error for " + i));
        }
        Assertions.assertFalse((boolean)ba.remove(12));
        ba.add(12, true);
        for (i = 1; i < 100; ++i) {
            if (i % 3 == 0 || i % 5 == 0 || i == 13) {
                Assertions.assertTrue((boolean)ba.get(i - 1), (String)("Error for " + i));
                continue;
            }
            Assertions.assertFalse((boolean)ba.get(i - 1), (String)("Error for " + i));
        }
        ba.add(99, true);
        Assertions.assertTrue((boolean)ba.get(99), (String)"Error for 99");
        ba.remove(99);
        ba.reverse();
        for (i = 1; i < 100; ++i) {
            if (i % 3 == 0 || i % 5 == 0 || i == 13) {
                Assertions.assertTrue((boolean)ba.get(99 - i), (String)("Error for " + i));
                continue;
            }
            Assertions.assertFalse((boolean)ba.get(99 - i), (String)("Error for " + i));
        }
    }

    @Test
    void booleanArrayIterator() {
        boolean[] model;
        PrimitivesArrays.BooleanArray ba = new PrimitivesArrays.BooleanArray(4, Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.BOOLEAN)));
        for (boolean x : model = new boolean[]{true, false, false, true, true, true, false, false, true, false, false}) {
            ba.add(x);
        }
        Assertions.assertEquals((int)model.length, (int)ba.size());
        int index = 0;
        for (Boolean b : ba) {
            Assertions.assertEquals((Object)model[index], (Object)b);
            ++index;
        }
    }

    @Test
    void intArray() {
        int i;
        int i2;
        PrimitivesArrays.IntArray intArray = new PrimitivesArrays.IntArray(4, Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)));
        for (i2 = 1; i2 <= 100; ++i2) {
            intArray.add((Object)i2);
        }
        Assertions.assertEquals((int)100, (int)intArray.size());
        for (i2 = 1; i2 <= 100; ++i2) {
            Assertions.assertEquals((int)i2, (Integer)intArray.get(i2 - 1));
        }
        int expectedValue = 1;
        for (Integer value : intArray) {
            Assertions.assertEquals((int)expectedValue, (Integer)value);
            ++expectedValue;
        }
        intArray.remove(40);
        Assertions.assertEquals((int)99, (int)intArray.size());
        for (i = 1; i <= 99; ++i) {
            if (i <= 40) {
                Assertions.assertEquals((int)i, (Integer)intArray.get(i - 1));
                continue;
            }
            Assertions.assertEquals((int)(i + 1), (Integer)intArray.get(i - 1));
        }
        intArray.add(40, 41);
        Assertions.assertEquals((int)100, (int)intArray.size());
        for (i = 1; i <= 100; ++i) {
            Assertions.assertEquals((int)i, (Integer)intArray.get(i - 1));
        }
        intArray.set(40, 25);
        Assertions.assertEquals((int)25, (Integer)intArray.get(40));
        Assertions.assertEquals((int)0, (Integer)intArray.peek());
        intArray.set(40, 41);
        intArray.reverse();
        Assertions.assertEquals((int)100, (int)intArray.size());
        for (i = 1; i <= 100; ++i) {
            Assertions.assertEquals((int)(101 - i), (Integer)intArray.get(i - 1));
        }
    }

    @Test
    void longArray() {
        int i;
        PrimitivesArrays.LongArray longArray = new PrimitivesArrays.LongArray(4, Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.LONG)));
        for (long i2 = 1L; i2 <= 100L; ++i2) {
            longArray.add((Object)i2);
        }
        Assertions.assertEquals((long)100L, (long)longArray.size());
        for (int i3 = 1; i3 <= 100; ++i3) {
            Assertions.assertEquals((long)i3, (Long)longArray.get(i3 - 1));
        }
        int expectedValue = 1;
        for (Long value : longArray) {
            Assertions.assertEquals((long)expectedValue, (Long)value);
            ++expectedValue;
        }
        longArray.remove(40);
        Assertions.assertEquals((int)99, (int)longArray.size());
        for (i = 1; i <= 99; ++i) {
            if (i <= 40) {
                Assertions.assertEquals((long)i, (Long)longArray.get(i - 1));
                continue;
            }
            Assertions.assertEquals((long)(i + 1), (Long)longArray.get(i - 1));
        }
        longArray.add(40, 41L);
        Assertions.assertEquals((int)100, (int)longArray.size());
        for (i = 1; i <= 100; ++i) {
            Assertions.assertEquals((long)i, (Long)longArray.get(i - 1));
        }
        longArray.set(40, 25L);
        Assertions.assertEquals((long)25L, (Long)longArray.get(40));
        Assertions.assertEquals((long)0L, (Long)longArray.peek());
        longArray.set(40, 41L);
        longArray.reverse();
        Assertions.assertEquals((int)100, (int)longArray.size());
        for (i = 1; i <= 100; ++i) {
            Assertions.assertEquals((long)(101 - i), (Long)longArray.get(i - 1));
        }
    }

    @Test
    void floatArray() {
        int i;
        int i2;
        PrimitivesArrays.FloatArray floatArray = new PrimitivesArrays.FloatArray(4, Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.FLOAT)));
        for (i2 = 1; i2 <= 100; ++i2) {
            floatArray.add((Object)Float.valueOf((float)i2 * 3.3f));
        }
        Assertions.assertEquals((int)100, (int)floatArray.size());
        for (i2 = 1; i2 <= 100; ++i2) {
            Assertions.assertEquals((float)((float)i2 * 3.3f), (Float)floatArray.get(i2 - 1));
        }
        float expectedValue = 1.0f;
        for (Float value : floatArray) {
            Assertions.assertEquals((float)(expectedValue * 3.3f), (Float)value);
            expectedValue += 1.0f;
        }
        floatArray.remove(40);
        Assertions.assertEquals((int)99, (int)floatArray.size());
        for (i = 1; i <= 99; ++i) {
            if (i <= 40) {
                Assertions.assertEquals((float)((float)i * 3.3f), (Float)floatArray.get(i - 1));
                continue;
            }
            Assertions.assertEquals((float)((float)(i + 1) * 3.3f), (Float)floatArray.get(i - 1));
        }
        floatArray.add(40, 135.3f);
        Assertions.assertEquals((int)100, (int)floatArray.size());
        for (i = 1; i <= 100; ++i) {
            Assertions.assertEquals((float)((float)i * 3.3f), (Float)floatArray.get(i - 1));
        }
        floatArray.set(40, 25.2f);
        Assertions.assertEquals((float)25.2f, (Float)floatArray.get(40));
        Assertions.assertEquals((float)0.0f, (Float)floatArray.peek());
        floatArray.set(40, 135.3f);
        floatArray.reverse();
        Assertions.assertEquals((int)100, (int)floatArray.size());
        for (i = 1; i <= 100; ++i) {
            Assertions.assertEquals((float)((float)(101 - i) * 3.3f), (Float)floatArray.get(i - 1));
        }
    }

    @Test
    void doubleArray() {
        int i;
        int i2;
        PrimitivesArrays.DoubleArray doubleArray = new PrimitivesArrays.DoubleArray(4, Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.DOUBLE)));
        for (i2 = 1; i2 <= 100; ++i2) {
            doubleArray.add((Object)((double)i2 * 3.0));
        }
        Assertions.assertEquals((int)100, (int)doubleArray.size());
        for (i2 = 1; i2 <= 100; ++i2) {
            Assertions.assertEquals((double)((double)i2 * 3.0), (Double)doubleArray.get(i2 - 1));
        }
        double expectedValue = 1.0;
        for (Double value : doubleArray) {
            Assertions.assertEquals((double)(expectedValue * 3.0), (Double)value);
            expectedValue += 1.0;
        }
        doubleArray.remove(40);
        Assertions.assertEquals((int)99, (int)doubleArray.size());
        for (i = 1; i <= 99; ++i) {
            if (i <= 40) {
                Assertions.assertEquals((double)((double)i * 3.0), (Double)doubleArray.get(i - 1));
                continue;
            }
            Assertions.assertEquals((double)((double)(i + 1) * 3.0), (Double)doubleArray.get(i - 1));
        }
        doubleArray.add(40, 123.0);
        Assertions.assertEquals((int)100, (int)doubleArray.size());
        for (i = 1; i <= 100; ++i) {
            Assertions.assertEquals((double)((double)i * 3.0), (Double)doubleArray.get(i - 1));
        }
        doubleArray.set(40, 25.2);
        Assertions.assertEquals((double)25.2, (Double)doubleArray.get(40));
        Assertions.assertEquals((double)0.0, (Double)doubleArray.peek());
        doubleArray.set(40, 123.0);
        doubleArray.reverse();
        Assertions.assertEquals((int)100, (int)doubleArray.size());
        for (i = 1; i <= 100; ++i) {
            Assertions.assertEquals((double)((double)(101 - i) * 3.0), (Double)doubleArray.get(i - 1));
        }
    }

    @Test
    void testDoubleArrayPreservesPrecisionForNonFloatRepresentableValues() {
        PrimitivesArrays.DoubleArray doubleArray = new PrimitivesArrays.DoubleArray(1, Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.DOUBLE)));
        Double nonFloatDouble = 0.9;
        Assertions.assertNotEquals((double)0.9, (double)nonFloatDouble.floatValue());
        doubleArray.add((Object)nonFloatDouble);
        Assertions.assertEquals((Double)nonFloatDouble, (Double)doubleArray.get(0));
    }
}

