/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.RandomData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIOExceptionDuringWrite {
    private static final String SCHEMA_JSON = "{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}";
    private static final Schema SCHEMA = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}");

    @Test
    void noWritingAfterException() throws IOException {
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            writer.create(SCHEMA, (OutputStream)new FailingOutputStream(100000));
            int recordCnt = 0;
            for (Object datum : new RandomData(SCHEMA, 100000, 42L)) {
                writer.append(datum);
                if (++recordCnt % 17 != 0) continue;
                writer.flush();
            }
        }
        catch (IOException e) {
            return;
        }
        Assertions.fail((String)"IOException should have been thrown");
    }

    private static class FailingOutputStream
    extends OutputStream {
        private int byteCnt;

        public FailingOutputStream(int failAfter) {
            this.byteCnt = failAfter;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.byteCnt > 0) {
                --this.byteCnt;
            } else {
                if (this.byteCnt == 0) {
                    --this.byteCnt;
                    throw new IOException("Artificial failure from FailingOutputStream");
                }
                Assertions.fail((String)"No bytes should have been written after IOException");
            }
        }
    }
}

