/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.data;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.reflect.ReflectData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestTimeConversions {
    public static Schema DATE_SCHEMA;
    public static Schema TIME_MILLIS_SCHEMA;
    public static Schema TIME_MICROS_SCHEMA;
    public static Schema TIMESTAMP_MILLIS_SCHEMA;
    public static Schema TIMESTAMP_MICROS_SCHEMA;

    @BeforeAll
    public static void createSchemas() {
        DATE_SCHEMA = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        TIME_MILLIS_SCHEMA = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        TIME_MICROS_SCHEMA = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TIMESTAMP_MILLIS_SCHEMA = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        TIMESTAMP_MICROS_SCHEMA = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    }

    @Test
    void dateConversion() throws Exception {
        TimeConversions.DateConversion conversion = new TimeConversions.DateConversion();
        LocalDate Jan_6_1970 = LocalDate.of(1970, 1, 6);
        LocalDate Jan_1_1970 = LocalDate.of(1970, 1, 1);
        LocalDate Dec_27_1969 = LocalDate.of(1969, 12, 27);
        Assertions.assertEquals((int)5, (int)conversion.toInt(Jan_6_1970, DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (String)"6 Jan 1970 should be 5");
        Assertions.assertEquals((int)0, (int)conversion.toInt(Jan_1_1970, DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (String)"1 Jan 1970 should be 0");
        Assertions.assertEquals((int)-5, (int)conversion.toInt(Dec_27_1969, DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (String)"27 Dec 1969 should be -5");
        Assertions.assertEquals((Object)conversion.fromInt(Integer.valueOf(5), DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (Object)Jan_6_1970, (String)"6 Jan 1970 should be 5");
        Assertions.assertEquals((Object)conversion.fromInt(Integer.valueOf(0), DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (Object)Jan_1_1970, (String)"1 Jan 1970 should be 0");
        Assertions.assertEquals((Object)conversion.fromInt(Integer.valueOf(-5), DATE_SCHEMA, (LogicalType)LogicalTypes.date()), (Object)Dec_27_1969, (String)"27 Dec 1969 should be -5");
    }

    @Test
    void timeMillisConversion() {
        TimeConversions.TimeMillisConversion conversion = new TimeConversions.TimeMillisConversion();
        LocalTime oneAM = LocalTime.of(1, 0);
        LocalTime afternoon = LocalTime.of(15, 14, 15, 926000000);
        int afternoonMillis = 54855926;
        Assertions.assertEquals((int)0, (int)conversion.toInt(LocalTime.MIDNIGHT, TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()), (String)"Midnight should be 0");
        Assertions.assertEquals((int)3600000, (int)conversion.toInt(oneAM, TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()), (String)"01:00 should be 3,600,000");
        Assertions.assertEquals((int)afternoonMillis, (int)conversion.toInt(afternoon, TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()), (String)("15:14:15.926 should be " + afternoonMillis));
        Assertions.assertEquals((Object)LocalTime.MIDNIGHT, (Object)conversion.fromInt(Integer.valueOf(0), TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()), (String)"Midnight should be 0");
        Assertions.assertEquals((Object)oneAM, (Object)conversion.fromInt(Integer.valueOf(3600000), TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()), (String)"01:00 should be 3,600,000");
        Assertions.assertEquals((Object)afternoon, (Object)conversion.fromInt(Integer.valueOf(afternoonMillis), TIME_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timeMillis()), (String)("15:14:15.926 should be " + afternoonMillis));
    }

    @Test
    void timeMicrosConversion() throws Exception {
        TimeConversions.TimeMicrosConversion conversion = new TimeConversions.TimeMicrosConversion();
        LocalTime oneAM = LocalTime.of(1, 0);
        LocalTime afternoon = LocalTime.of(15, 14, 15, 926551000);
        long afternoonMicros = 54855926551L;
        Assertions.assertEquals((Object)LocalTime.MIDNIGHT, (Object)conversion.fromLong(Long.valueOf(0L), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()), (String)"Midnight should be 0");
        Assertions.assertEquals((Object)oneAM, (Object)conversion.fromLong(Long.valueOf(3600000000L), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()), (String)"01:00 should be 3,600,000,000");
        Assertions.assertEquals((Object)afternoon, (Object)conversion.fromLong(Long.valueOf(afternoonMicros), TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()), (String)("15:14:15.926551 should be " + afternoonMicros));
        Assertions.assertEquals((long)0L, (long)conversion.toLong(LocalTime.MIDNIGHT, TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()), (String)"Midnight should be 0");
        Assertions.assertEquals((long)3600000000L, (long)conversion.toLong(oneAM, TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()), (String)"01:00 should be 3,600,000,000");
        Assertions.assertEquals((long)afternoonMicros, (long)conversion.toLong(afternoon, TIME_MICROS_SCHEMA, (LogicalType)LogicalTypes.timeMicros()), (String)("15:14:15.926551 should be " + afternoonMicros));
    }

    @Test
    void timestampMillisConversion() throws Exception {
        TimeConversions.TimestampMillisConversion conversion = new TimeConversions.TimestampMillisConversion();
        long nowInstant = Instant.now().toEpochMilli();
        Instant now = conversion.fromLong(Long.valueOf(nowInstant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        long roundTrip = conversion.toLong(now, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis());
        Assertions.assertEquals((long)nowInstant, (long)roundTrip, (String)"Round-trip conversion should work");
        long May_28_2015_21_46_53_221_instant = 1432849613221L;
        Instant May_28_2015_21_46_53_221 = ZonedDateTime.of(2015, 5, 28, 21, 46, 53, 221000000, ZoneOffset.UTC).toInstant();
        Assertions.assertEquals((Object)May_28_2015_21_46_53_221, (Object)conversion.fromLong(Long.valueOf(May_28_2015_21_46_53_221_instant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Known date should be correct");
        Assertions.assertEquals((long)May_28_2015_21_46_53_221_instant, (long)conversion.toLong(May_28_2015_21_46_53_221, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Known date should be correct");
        Assertions.assertEquals((Object)Instant.EPOCH, (Object)conversion.fromLong(Long.valueOf(0L), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"1970-01-01 should be 0");
        Assertions.assertEquals((long)0L, (long)conversion.toLong(ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC).toInstant(), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"1970-01-01 should be 0");
        long Jul_01_1969_12_00_00_123_instant = -15854399877L;
        Instant Jul_01_1969_12_00_00_123 = ZonedDateTime.of(1969, 7, 1, 12, 0, 0, 123000000, ZoneOffset.UTC).toInstant();
        Assertions.assertEquals((Object)Jul_01_1969_12_00_00_123, (Object)conversion.fromLong(Long.valueOf(Jul_01_1969_12_00_00_123_instant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Pre 1970 date should be correct");
        Assertions.assertEquals((long)Jul_01_1969_12_00_00_123_instant, (long)conversion.toLong(Jul_01_1969_12_00_00_123, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Pre 1970 date should be correct");
    }

    @Test
    void timestampMicrosConversion() throws Exception {
        TimeConversions.TimestampMicrosConversion conversion = new TimeConversions.TimestampMicrosConversion();
        long May_28_2015_21_46_53_221_843_instant = 1432849613221843L;
        Instant May_28_2015_21_46_53_221_843 = ZonedDateTime.of(2015, 5, 28, 21, 46, 53, 221843000, ZoneOffset.UTC).toInstant();
        Assertions.assertEquals((Object)May_28_2015_21_46_53_221_843, (Object)conversion.fromLong(Long.valueOf(May_28_2015_21_46_53_221_843_instant), TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMicros()), (String)"Known date should be correct");
        Assertions.assertEquals((long)May_28_2015_21_46_53_221_843_instant, (long)conversion.toLong(May_28_2015_21_46_53_221_843, TIMESTAMP_MICROS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Known date should be correct");
        Assertions.assertEquals((Object)Instant.EPOCH, (Object)conversion.fromLong(Long.valueOf(0L), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"1970-01-01 should be 0");
        Assertions.assertEquals((long)0L, (long)conversion.toLong(ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC).toInstant(), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"1970-01-01 should be 0");
        long Jul_01_1969_12_00_00_000_123_instant = -15854399999877L;
        Instant Jul_01_1969_12_00_00_000_123 = ZonedDateTime.of(1969, 7, 1, 12, 0, 0, 123000, ZoneOffset.UTC).toInstant();
        Assertions.assertEquals((Object)Jul_01_1969_12_00_00_000_123, (Object)conversion.fromLong(Long.valueOf(Jul_01_1969_12_00_00_000_123_instant), TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Pre 1970 date should be correct");
        Assertions.assertEquals((long)Jul_01_1969_12_00_00_000_123_instant, (long)conversion.toLong(Jul_01_1969_12_00_00_000_123, TIMESTAMP_MILLIS_SCHEMA, (LogicalType)LogicalTypes.timestampMillis()), (String)"Pre 1970 date should be correct");
    }

    @Test
    void dynamicSchemaWithDateConversion() throws ClassNotFoundException {
        Schema schema = this.getReflectedSchemaByName("java.time.LocalDate", (Conversion<?>)new TimeConversions.DateConversion());
        Assertions.assertEquals((Object)DATE_SCHEMA, (Object)schema, (String)"Reflected schema should be logicalType date");
    }

    @Test
    void dynamicSchemaWithTimeConversion() throws ClassNotFoundException {
        Schema schema = this.getReflectedSchemaByName("java.time.LocalTime", (Conversion<?>)new TimeConversions.TimeMillisConversion());
        Assertions.assertEquals((Object)TIME_MILLIS_SCHEMA, (Object)schema, (String)"Reflected schema should be logicalType timeMillis");
    }

    @Test
    void dynamicSchemaWithTimeMicrosConversion() throws ClassNotFoundException {
        Schema schema = this.getReflectedSchemaByName("java.time.LocalTime", (Conversion<?>)new TimeConversions.TimeMicrosConversion());
        Assertions.assertEquals((Object)TIME_MICROS_SCHEMA, (Object)schema, (String)"Reflected schema should be logicalType timeMicros");
    }

    @Test
    void dynamicSchemaWithDateTimeConversion() throws ClassNotFoundException {
        Schema schema = this.getReflectedSchemaByName("java.time.Instant", (Conversion<?>)new TimeConversions.TimestampMillisConversion());
        Assertions.assertEquals((Object)TIMESTAMP_MILLIS_SCHEMA, (Object)schema, (String)"Reflected schema should be logicalType timestampMillis");
    }

    @Test
    void dynamicSchemaWithDateTimeMicrosConversion() throws ClassNotFoundException {
        Schema schema = this.getReflectedSchemaByName("java.time.Instant", (Conversion<?>)new TimeConversions.TimestampMicrosConversion());
        Assertions.assertEquals((Object)TIMESTAMP_MICROS_SCHEMA, (Object)schema, (String)"Reflected schema should be logicalType timestampMicros");
    }

    private Schema getReflectedSchemaByName(String className, Conversion<?> conversion) throws ClassNotFoundException {
        Class<?> cls = Class.forName(className);
        ReflectData model = new ReflectData();
        model.addLogicalTypeConversion(conversion);
        return model.getSchema(cls);
    }
}

