/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchemaValidateDefault {
    static final Schema SCHEMA = (Schema)SchemaBuilder.record((String)"org.apache.avro.TestSchemaValidateDefault.ComplexValue").fields().optionalLong("value").endRecord();

    @Test
    public void valueReadWithCorrectDefaultValue() throws IOException {
        ExampleRecord writtenValue = new ExampleRecord(new ComplexValue(42L), new ComplexValue(666L));
        byte[] bytes = TestSchemaValidateDefault.getSerializer(ExampleRecord.SCHEMA_WITH_ONE_FIELD).apply(writtenValue);
        ReflectDatumReader reader = new ReflectDatumReader(ExampleRecord.SCHEMA_WITH_ONE_FIELD, ExampleRecord.SCHEMA_WITH_TWO_FIELDS, ReflectData.get());
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(ExampleRecord.SCHEMA_WITH_ONE_FIELD, (InputStream)new ByteArrayInputStream(bytes));
        ExampleRecord deserializedValue = (ExampleRecord)reader.read(null, (Decoder)decoder);
        Assertions.assertNotNull((Object)deserializedValue.getValue2(), (String)"Null get value2");
        Assertions.assertEquals((long)15L, (Long)deserializedValue.getValue2().getValue());
    }

    public static Function<Object, byte[]> getSerializer(Schema writerSchema) {
        Objects.requireNonNull(writerSchema, "writerSchema must not be null");
        ReflectDatumWriter writer = new ReflectDatumWriter(writerSchema, new ReflectData());
        return object -> {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                JsonEncoder encoder = EncoderFactory.get().jsonEncoder(writerSchema, (OutputStream)stream);
                writer.write(object, (Encoder)encoder);
                encoder.flush();
                return stream.toByteArray();
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Avro failed to encode %s to schema %s", object, writerSchema), e);
            }
        };
    }

    public static <T> Function<byte[], T> getDeserializer(Class<T> readClass, Schema readerSchema, Schema writerSchema) {
        Objects.requireNonNull(readClass, "readClass must not be null");
        Objects.requireNonNull(readerSchema, "readerSchema must not be null");
        Objects.requireNonNull(writerSchema, "writerSchema must not be null");
        ReflectDatumReader reader = new ReflectDatumReader(writerSchema, readerSchema, new ReflectData());
        return bytes -> {
            try {
                JsonDecoder decoder = DecoderFactory.get().jsonDecoder(writerSchema, (InputStream)new ByteArrayInputStream((byte[])bytes));
                Object readValue = reader.read(null, (Decoder)decoder);
                return readValue;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Avro failed to decode %s to %s", new String((byte[])bytes), readClass), e);
            }
        };
    }

    public static class ExampleRecord {
        public static final Schema SCHEMA_WITH_ONE_FIELD = (Schema)SchemaBuilder.record((String)"org.apache.avro.TestSchemaValidateDefault.ExampleRecord").fields().name("value1").type(SCHEMA).noDefault().endRecord();
        public static final Schema SCHEMA_WITH_TWO_FIELDS;
        private ComplexValue value1;
        private ComplexValue value2;

        public ExampleRecord() {
        }

        public ExampleRecord(ComplexValue value1, ComplexValue value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        public ComplexValue getValue1() {
            return this.value1;
        }

        public ComplexValue getValue2() {
            return this.value2;
        }

        static {
            GenericData.Record record = new GenericData.Record(SCHEMA);
            record.put("value", (Object)15L);
            SCHEMA_WITH_TWO_FIELDS = (Schema)SchemaBuilder.record((String)"org.apache.avro.TestSchemaValidateDefault.ExampleRecord").fields().name("value1").type(SCHEMA).noDefault().name("value2").type(SCHEMA).withDefault((Object)record).endRecord();
        }
    }

    public static class ComplexValue {
        private Long value;

        public ComplexValue() {
        }

        public ComplexValue(Long value) {
            this.value = value;
        }

        public Long getValue() {
            return this.value;
        }

        public String toString() {
            return "{\"value\": { \"long\": " + this.value + "}}";
        }
    }
}

