/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.DummySchemaParser;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.SchemaParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSchemaParser {
    private static final Schema SCHEMA_REAL = Schema.createFixed((String)"Real", null, (String)"tests", (int)42);
    private static final String SCHEMA_JSON = SCHEMA_REAL.toString(false);
    private static final Charset[] UTF_CHARSETS = new Charset[]{StandardCharsets.UTF_8, StandardCharsets.UTF_16LE, StandardCharsets.UTF_16BE};

    TestSchemaParser() {
    }

    @Test
    void testParseFile() throws IOException {
        Path tempFile = Files.createTempFile("TestSchemaParser", null, new FileAttribute[0]);
        Files.write(tempFile, Collections.singletonList(SCHEMA_JSON), new OpenOption[0]);
        Schema schema = new SchemaParser().parse(tempFile.toFile()).mainSchema();
        Assertions.assertEquals((Object)SCHEMA_REAL, (Object)schema);
    }

    @Test
    void testParsePath() throws IOException {
        Path tempFile = Files.createTempFile("TestSchemaParser", null, new FileAttribute[0]);
        Files.write(tempFile, Collections.singletonList(SCHEMA_JSON), new OpenOption[0]);
        Schema schema = new SchemaParser().parse(tempFile).mainSchema();
        Assertions.assertEquals((Object)SCHEMA_REAL, (Object)schema);
    }

    @Test
    void testParseURI() throws IOException {
        Path tempFile = Files.createTempFile("TestSchemaParser", null, new FileAttribute[0]);
        Charset charset = UTF_CHARSETS[(int)Math.floor((double)UTF_CHARSETS.length * Math.random())];
        Files.write(tempFile, Collections.singletonList(SCHEMA_JSON), charset, new OpenOption[0]);
        Schema schema = new SchemaParser().parse(tempFile.toUri(), null).mainSchema();
        Assertions.assertEquals((Object)SCHEMA_REAL, (Object)schema);
    }

    @Test
    void testParseReader() throws IOException {
        Schema schema = new SchemaParser().parse((Reader)new StringReader(SCHEMA_JSON)).mainSchema();
        Assertions.assertEquals((Object)SCHEMA_REAL, (Object)schema);
    }

    @Test
    void testParseStream() throws IOException {
        Schema schema = new SchemaParser().parse((InputStream)new ByteArrayInputStream(SCHEMA_JSON.getBytes(StandardCharsets.UTF_16))).mainSchema();
        Assertions.assertEquals((Object)SCHEMA_REAL, (Object)schema);
    }

    @Test
    void testParseTextWithFallbackJsonParser() {
        Schema schema = new SchemaParser().parse((CharSequence)SCHEMA_JSON).mainSchema();
        Assertions.assertEquals((Object)SCHEMA_REAL, (Object)schema);
    }

    @Test
    void testParseByCustomParser() {
        Schema schema = new SchemaParser().parse((CharSequence)"one").mainSchema();
        Assertions.assertEquals((Object)DummySchemaParser.FIXED_SCHEMA, (Object)schema);
    }

    @Test
    void testSingleParseError() {
        SchemaParseException parseException = (SchemaParseException)Assertions.assertThrows(SchemaParseException.class, () -> new SchemaParser().parse((CharSequence)"foo").mainSchema());
        Assertions.assertEquals(JsonParseException.class, parseException.getCause().getClass());
        Assertions.assertEquals((int)0, (int)parseException.getSuppressed().length);
    }

    @Test
    void testMultipleParseErrors() {
        SchemaParseException parseException = (SchemaParseException)Assertions.assertThrows(SchemaParseException.class, () -> new SchemaParser().parse((CharSequence)"error").mainSchema());
        Assertions.assertTrue((boolean)parseException.getMessage().startsWith("Could not parse the schema"));
        Throwable[] suppressed = parseException.getSuppressed();
        Assertions.assertEquals((int)2, (int)suppressed.length);
        Assertions.assertEquals((Object)"Syntax error", (Object)suppressed[0].getMessage());
        Assertions.assertEquals(JsonParseException.class, suppressed[1].getCause().getClass());
    }

    @Test
    void testIOFailureWhileParsingText() {
        AvroRuntimeException exception = (AvroRuntimeException)Assertions.assertThrows(AvroRuntimeException.class, () -> new SchemaParser().parse((CharSequence)"io-error").mainSchema());
        Assertions.assertEquals(IOException.class, exception.getCause().getClass());
        Assertions.assertEquals((Object)"I/O error", (Object)exception.getCause().getMessage());
    }
}

