/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.TestSchemaCompatibility;
import org.apache.avro.TestSchemas;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSchemaCompatibilityTypeMismatch {
    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSchemas.NULL_SCHEMA, TestSchemas.INT_SCHEMA, "reader type: NULL not compatible with writer type: INT", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.NULL_SCHEMA, TestSchemas.LONG_SCHEMA, "reader type: NULL not compatible with writer type: LONG", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.BOOLEAN_SCHEMA, TestSchemas.INT_SCHEMA, "reader type: BOOLEAN not compatible with writer type: INT", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_SCHEMA, TestSchemas.NULL_SCHEMA, "reader type: INT not compatible with writer type: NULL", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_SCHEMA, TestSchemas.BOOLEAN_SCHEMA, "reader type: INT not compatible with writer type: BOOLEAN", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_SCHEMA, TestSchemas.LONG_SCHEMA, "reader type: INT not compatible with writer type: LONG", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_SCHEMA, TestSchemas.FLOAT_SCHEMA, "reader type: INT not compatible with writer type: FLOAT", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_SCHEMA, TestSchemas.DOUBLE_SCHEMA, "reader type: INT not compatible with writer type: DOUBLE", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.LONG_SCHEMA, TestSchemas.FLOAT_SCHEMA, "reader type: LONG not compatible with writer type: FLOAT", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.LONG_SCHEMA, TestSchemas.DOUBLE_SCHEMA, "reader type: LONG not compatible with writer type: DOUBLE", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.FLOAT_SCHEMA, TestSchemas.DOUBLE_SCHEMA, "reader type: FLOAT not compatible with writer type: DOUBLE", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.DOUBLE_SCHEMA, TestSchemas.STRING_SCHEMA, "reader type: DOUBLE not compatible with writer type: STRING", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.FIXED_4_BYTES, TestSchemas.STRING_SCHEMA, "reader type: FIXED not compatible with writer type: STRING", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.STRING_SCHEMA, TestSchemas.BOOLEAN_SCHEMA, "reader type: STRING not compatible with writer type: BOOLEAN", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.STRING_SCHEMA, TestSchemas.INT_SCHEMA, "reader type: STRING not compatible with writer type: INT", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.BYTES_SCHEMA, TestSchemas.NULL_SCHEMA, "reader type: BYTES not compatible with writer type: NULL", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.BYTES_SCHEMA, TestSchemas.INT_SCHEMA, "reader type: BYTES not compatible with writer type: INT", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.A_INT_RECORD1, TestSchemas.INT_SCHEMA, "reader type: RECORD not compatible with writer type: INT", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_ARRAY_SCHEMA, TestSchemas.LONG_ARRAY_SCHEMA, "reader type: INT not compatible with writer type: LONG", "/items"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_MAP_SCHEMA, TestSchemas.INT_ARRAY_SCHEMA, "reader type: MAP not compatible with writer type: ARRAY", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_ARRAY_SCHEMA, TestSchemas.INT_MAP_SCHEMA, "reader type: ARRAY not compatible with writer type: MAP", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_MAP_SCHEMA, TestSchemas.LONG_MAP_SCHEMA, "reader type: INT not compatible with writer type: LONG", "/values"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_SCHEMA, TestSchemas.ENUM2_AB_SCHEMA, "reader type: INT not compatible with writer type: ENUM", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.ENUM2_AB_SCHEMA, TestSchemas.INT_SCHEMA, "reader type: ENUM not compatible with writer type: INT", "/"}), Arguments.of((Object[])new Object[]{TestSchemas.FLOAT_SCHEMA, TestSchemas.INT_LONG_FLOAT_DOUBLE_UNION_SCHEMA, "reader type: FLOAT not compatible with writer type: DOUBLE", "/3"}), Arguments.of((Object[])new Object[]{TestSchemas.LONG_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA, "reader type: LONG not compatible with writer type: FLOAT", "/1"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_SCHEMA, TestSchemas.INT_FLOAT_UNION_SCHEMA, "reader type: INT not compatible with writer type: FLOAT", "/1"}), Arguments.of((Object[])new Object[]{TestSchemas.INT_LIST_RECORD, TestSchemas.LONG_LIST_RECORD, "reader type: INT not compatible with writer type: LONG", "/fields/0/type"}), Arguments.of((Object[])new Object[]{TestSchemas.NULL_SCHEMA, TestSchemas.INT_SCHEMA, "reader type: NULL not compatible with writer type: INT", "/"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testTypeMismatchSchemas(Schema reader, Schema writer, String details, String location) throws Exception {
        TestSchemaCompatibility.validateIncompatibleSchemas(reader, writer, SchemaCompatibility.SchemaIncompatibilityType.TYPE_MISMATCH, details, location);
    }
}

