/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.databind.node.NullNode;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.NameValidator;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaBuilderException;
import org.apache.avro.SchemaParseException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestSchemaBuilder {
    @TempDir
    public File DIR;

    @Test
    void record() {
        Schema schema = (Schema)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"myrecord").namespace("org.example")).aliases(new String[]{"oldrecord"})).fields().name("f0").aliases(new String[]{"f0alias"})).type().stringType().noDefault().name("f1").doc("This is f1")).type().longType().noDefault().name("f2").type().nullable().booleanType().booleanDefault(true).name("f3").type().unionOf().nullType().and().booleanType()).endUnion()).nullDefault().endRecord();
        Assertions.assertEquals((Object)"myrecord", (Object)schema.getName());
        Assertions.assertEquals((Object)"org.example", (Object)schema.getNamespace());
        Assertions.assertEquals((Object)"org.example.oldrecord", schema.getAliases().iterator().next());
        Assertions.assertFalse((boolean)schema.isError());
        List fields = schema.getFields();
        Assertions.assertEquals((int)4, (int)fields.size());
        Assertions.assertEquals((Object)new Schema.Field("f0", Schema.create((Schema.Type)Schema.Type.STRING)), fields.get(0));
        Assertions.assertTrue((boolean)((Schema.Field)fields.get(0)).aliases().contains("f0alias"));
        Assertions.assertEquals((Object)new Schema.Field("f1", Schema.create((Schema.Type)Schema.Type.LONG), "This is f1"), fields.get(1));
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.add(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
        types.add(Schema.create((Schema.Type)Schema.Type.NULL));
        Schema optional = Schema.createUnion(types);
        Assertions.assertEquals((Object)new Schema.Field("f2", optional, null, (Object)true), fields.get(2));
        ArrayList<Schema> types2 = new ArrayList<Schema>();
        types2.add(Schema.create((Schema.Type)Schema.Type.NULL));
        types2.add(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
        Schema optional2 = Schema.createUnion(types2);
        Assertions.assertNotEquals((Object)new Schema.Field("f3", optional2, null, null), fields.get(3));
        Assertions.assertEquals((Object)new Schema.Field("f3", optional2, null, Schema.Field.NULL_DEFAULT_VALUE), fields.get(3));
    }

    @Test
    void doc() {
        Schema s = (Schema)((SchemaBuilder.FixedBuilder)SchemaBuilder.fixed((String)"myfixed").doc("mydoc")).size(1);
        Assertions.assertEquals((Object)"mydoc", (Object)s.getDoc());
    }

    @Test
    void props() {
        Schema s = (Schema)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)SchemaBuilder.builder().intBuilder().prop("p1", "v1")).prop("p2", "v2")).prop("p2", "v2real")).endInt();
        int size = s.getObjectProps().size();
        Assertions.assertEquals((int)2, (int)size);
        Assertions.assertEquals((Object)"v1", (Object)s.getProp("p1"));
        Assertions.assertEquals((Object)"v2real", (Object)s.getProp("p2"));
    }

    @Test
    void objectProps() {
        Schema s = (Schema)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)((SchemaBuilder.IntBuilder)SchemaBuilder.builder().intBuilder().prop("booleanProp", (Object)true)).prop("intProp", (Object)Integer.MAX_VALUE)).prop("longProp", (Object)Long.MAX_VALUE)).prop("floatProp", (Object)Float.valueOf(1.0f))).prop("doubleProp", (Object)Double.MAX_VALUE)).prop("byteProp", (Object)new byte[]{65, 66, 67})).prop("stringProp", "abc")).endInt();
        Assertions.assertEquals((int)7, (int)s.getObjectProps().size());
        Assertions.assertTrue((boolean)(s.getObjectProp("booleanProp") instanceof Boolean));
        Assertions.assertEquals((Object)true, (Object)s.getObjectProp("booleanProp"));
        Assertions.assertTrue((boolean)(s.getObjectProp("intProp") instanceof Integer));
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)s.getObjectProp("intProp"));
        Assertions.assertTrue((boolean)(s.getObjectProp("intProp") instanceof Integer));
        Assertions.assertTrue((boolean)(s.getObjectProp("longProp") instanceof Long));
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)s.getObjectProp("longProp"));
        Assertions.assertTrue((boolean)(s.getObjectProp("floatProp") instanceof Float));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)s.getObjectProp("floatProp"));
        Assertions.assertTrue((boolean)(s.getObjectProp("doubleProp") instanceof Double));
        Assertions.assertEquals((Object)Double.MAX_VALUE, (Object)s.getObjectProp("doubleProp"));
        Assertions.assertTrue((boolean)(s.getObjectProp("byteProp") instanceof byte[]));
        Assertions.assertArrayEquals((byte[])new byte[]{65, 66, 67}, (byte[])((byte[])s.getObjectProp("byteProp")));
        Assertions.assertTrue((boolean)(s.getObjectProp("stringProp") instanceof String));
        Assertions.assertEquals((Object)"abc", (Object)s.getObjectProp("stringProp"));
    }

    @Test
    void fieldObjectProps() {
        Schema s = (Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)SchemaBuilder.builder().record("MyRecord").fields().name("myField").prop("booleanProp", (Object)true)).prop("intProp", (Object)Integer.MAX_VALUE)).prop("longProp", (Object)Long.MAX_VALUE)).prop("floatProp", (Object)Float.valueOf(1.0f))).prop("doubleProp", (Object)Double.MAX_VALUE)).prop("byteProp", (Object)new byte[]{65, 66, 67})).prop("stringProp", "abc")).type().intType().noDefault().endRecord();
        Schema.Field f = s.getField("myField");
        Assertions.assertEquals((int)7, (int)f.getObjectProps().size());
        Assertions.assertTrue((boolean)(f.getObjectProp("booleanProp") instanceof Boolean));
        Assertions.assertEquals((Object)true, (Object)f.getObjectProp("booleanProp"));
        Assertions.assertTrue((boolean)(f.getObjectProp("intProp") instanceof Integer));
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)f.getObjectProp("intProp"));
        Assertions.assertTrue((boolean)(f.getObjectProp("intProp") instanceof Integer));
        Assertions.assertTrue((boolean)(f.getObjectProp("longProp") instanceof Long));
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)f.getObjectProp("longProp"));
        Assertions.assertTrue((boolean)(f.getObjectProp("floatProp") instanceof Float));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)f.getObjectProp("floatProp"));
        Assertions.assertTrue((boolean)(f.getObjectProp("doubleProp") instanceof Double));
        Assertions.assertEquals((Object)Double.MAX_VALUE, (Object)f.getObjectProp("doubleProp"));
        Assertions.assertTrue((boolean)(f.getObjectProp("byteProp") instanceof byte[]));
        Assertions.assertArrayEquals((byte[])new byte[]{65, 66, 67}, (byte[])((byte[])f.getObjectProp("byteProp")));
        Assertions.assertTrue((boolean)(f.getObjectProp("stringProp") instanceof String));
        Assertions.assertEquals((Object)"abc", (Object)f.getObjectProp("stringProp"));
        Assertions.assertEquals((Object)"abc", (Object)f.getObjectProp("stringProp", (Object)"default"));
        Assertions.assertEquals((Object)"default", (Object)f.getObjectProp("unknwon", (Object)"default"));
    }

    @Test
    void arrayObjectProp() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(true);
        values.add(Integer.MAX_VALUE);
        values.add(Long.MAX_VALUE);
        values.add(Float.valueOf(1.0f));
        values.add(Double.MAX_VALUE);
        values.add(new byte[]{65, 66, 67});
        values.add("abc");
        Schema s = (Schema)((SchemaBuilder.IntBuilder)SchemaBuilder.builder().intBuilder().prop("arrayProp", values)).endInt();
        Assertions.assertEquals((int)1, (int)s.getObjectProps().size());
        Assertions.assertTrue((boolean)(s.getObjectProp("arrayProp") instanceof Collection));
        Collection valueCollection = (Collection)s.getObjectProp("arrayProp");
        Iterator iter = valueCollection.iterator();
        Assertions.assertEquals((int)7, (int)valueCollection.size());
        Assertions.assertEquals((Object)true, iter.next());
        Assertions.assertEquals((Object)Integer.MAX_VALUE, iter.next());
        Assertions.assertEquals((Object)Long.MAX_VALUE, iter.next());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), iter.next());
        Assertions.assertEquals((Object)Double.MAX_VALUE, iter.next());
        Assertions.assertArrayEquals((byte[])new byte[]{65, 66, 67}, (byte[])((byte[])iter.next()));
        Assertions.assertEquals((Object)"abc", iter.next());
    }

    @Test
    void fieldArrayObjectProp() {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(true);
        values.add(Integer.MAX_VALUE);
        values.add(Long.MAX_VALUE);
        values.add(Float.valueOf(1.0f));
        values.add(Double.MAX_VALUE);
        values.add(new byte[]{65, 66, 67});
        values.add("abc");
        Schema s = (Schema)((SchemaBuilder.FieldBuilder)SchemaBuilder.builder().record("MyRecord").fields().name("myField").prop("arrayProp", values)).type().intType().noDefault().endRecord();
        Schema.Field f = s.getField("myField");
        Assertions.assertEquals((int)1, (int)f.getObjectProps().size());
        Assertions.assertTrue((boolean)(f.getObjectProp("arrayProp") instanceof Collection));
        Collection valueCollection = (Collection)f.getObjectProp("arrayProp");
        Iterator iter = valueCollection.iterator();
        Assertions.assertEquals((int)7, (int)valueCollection.size());
        Assertions.assertEquals((Object)true, iter.next());
        Assertions.assertEquals((Object)Integer.MAX_VALUE, iter.next());
        Assertions.assertEquals((Object)Long.MAX_VALUE, iter.next());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), iter.next());
        Assertions.assertEquals((Object)Double.MAX_VALUE, iter.next());
        Assertions.assertArrayEquals((byte[])new byte[]{65, 66, 67}, (byte[])((byte[])iter.next()));
        Assertions.assertEquals((Object)"abc", iter.next());
    }

    @Test
    void mapObjectProp() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("booleanKey", true);
        values.put("intKey", Integer.MAX_VALUE);
        values.put("longKey", Long.MAX_VALUE);
        values.put("floatKey", Float.valueOf(1.0f));
        values.put("doubleKey", Double.MAX_VALUE);
        values.put("byteKey", new byte[]{65, 66, 67});
        values.put("stringKey", "abc");
        Schema s = (Schema)((SchemaBuilder.IntBuilder)SchemaBuilder.builder().intBuilder().prop("mapProp", values)).endInt();
        Assertions.assertTrue((boolean)(s.getObjectProp("mapProp") instanceof Map));
        Map valueMap = (Map)s.getObjectProp("mapProp");
        Assertions.assertEquals((int)values.size(), (int)valueMap.size());
        Assertions.assertTrue((boolean)(valueMap.get("booleanKey") instanceof Boolean));
        Assertions.assertEquals((Object)true, valueMap.get("booleanKey"));
        Assertions.assertTrue((boolean)(valueMap.get("intKey") instanceof Integer));
        Assertions.assertEquals((Object)Integer.MAX_VALUE, valueMap.get("intKey"));
        Assertions.assertTrue((boolean)(valueMap.get("longKey") instanceof Long));
        Assertions.assertEquals((Object)Long.MAX_VALUE, valueMap.get("longKey"));
        Assertions.assertTrue((boolean)(valueMap.get("floatKey") instanceof Float));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), valueMap.get("floatKey"));
        Assertions.assertTrue((boolean)(valueMap.get("doubleKey") instanceof Double));
        Assertions.assertEquals((Object)Double.MAX_VALUE, valueMap.get("doubleKey"));
        Assertions.assertTrue((boolean)(valueMap.get("byteKey") instanceof byte[]));
        Assertions.assertArrayEquals((byte[])"ABC".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])valueMap.get("byteKey")));
        Assertions.assertTrue((boolean)(valueMap.get("stringKey") instanceof String));
        Assertions.assertEquals((Object)"abc", valueMap.get("stringKey"));
    }

    @Test
    void fieldMapObjectProp() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("booleanKey", true);
        values.put("intKey", Integer.MAX_VALUE);
        values.put("longKey", Long.MAX_VALUE);
        values.put("floatKey", Float.valueOf(1.0f));
        values.put("doubleKey", Double.MAX_VALUE);
        values.put("byteKey", new byte[]{65, 66, 67});
        values.put("stringKey", "abc");
        Schema s = (Schema)((SchemaBuilder.FieldBuilder)SchemaBuilder.builder().record("MyRecord").fields().name("myField").prop("mapProp", values)).type().intType().noDefault().endRecord();
        Schema.Field f = s.getField("myField");
        Assertions.assertTrue((boolean)(f.getObjectProp("mapProp") instanceof Map));
        Map valueMap = (Map)f.getObjectProp("mapProp");
        Assertions.assertEquals((int)values.size(), (int)valueMap.size());
        Assertions.assertTrue((boolean)(valueMap.get("booleanKey") instanceof Boolean));
        Assertions.assertEquals((Object)true, valueMap.get("booleanKey"));
        Assertions.assertTrue((boolean)(valueMap.get("intKey") instanceof Integer));
        Assertions.assertEquals((Object)Integer.MAX_VALUE, valueMap.get("intKey"));
        Assertions.assertTrue((boolean)(valueMap.get("longKey") instanceof Long));
        Assertions.assertEquals((Object)Long.MAX_VALUE, valueMap.get("longKey"));
        Assertions.assertTrue((boolean)(valueMap.get("floatKey") instanceof Float));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), valueMap.get("floatKey"));
        Assertions.assertTrue((boolean)(valueMap.get("doubleKey") instanceof Double));
        Assertions.assertEquals((Object)Double.MAX_VALUE, valueMap.get("doubleKey"));
        Assertions.assertTrue((boolean)(valueMap.get("byteKey") instanceof byte[]));
        Assertions.assertEquals((Object)"ABC", (Object)new String((byte[])valueMap.get("byteKey")));
        Assertions.assertTrue((boolean)(valueMap.get("stringKey") instanceof String));
        Assertions.assertEquals((Object)"abc", valueMap.get("stringKey"));
    }

    @Test
    void nullObjectProp() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> ((SchemaBuilder.IntBuilder)SchemaBuilder.builder().intBuilder().prop("nullProp", null)).endInt());
    }

    @Test
    void fieldNullObjectProp() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> ((SchemaBuilder.FieldBuilder)SchemaBuilder.builder().record("MyRecord").fields().name("myField").prop("nullProp", null)).type().intType().noDefault().endRecord());
    }

    @Test
    void namespaces() {
        Schema s1 = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"myrecord").namespace("org.example")).fields().name("myint").type().intType().noDefault().endRecord();
        Schema s2 = (Schema)SchemaBuilder.record((String)"org.example.myrecord").fields().name("myint").type().intType().noDefault().endRecord();
        Schema s3 = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"org.example.myrecord").namespace("org.example2")).fields().name("myint").type().intType().noDefault().endRecord();
        Schema s4 = (Schema)SchemaBuilder.builder((String)"org.example").record("myrecord").fields().name("myint").type().intType().noDefault().endRecord();
        Assertions.assertEquals((Object)"myrecord", (Object)s1.getName());
        Assertions.assertEquals((Object)"myrecord", (Object)s2.getName());
        Assertions.assertEquals((Object)"myrecord", (Object)s3.getName());
        Assertions.assertEquals((Object)"myrecord", (Object)s4.getName());
        Assertions.assertEquals((Object)"org.example", (Object)s1.getNamespace());
        Assertions.assertEquals((Object)"org.example", (Object)s2.getNamespace());
        Assertions.assertEquals((Object)"org.example", (Object)s3.getNamespace());
        Assertions.assertEquals((Object)"org.example", (Object)s4.getNamespace());
        Assertions.assertEquals((Object)"org.example.myrecord", (Object)s1.getFullName());
        Assertions.assertEquals((Object)"org.example.myrecord", (Object)s2.getFullName());
        Assertions.assertEquals((Object)"org.example.myrecord", (Object)s3.getFullName());
        Assertions.assertEquals((Object)"org.example.myrecord", (Object)s4.getFullName());
    }

    @Test
    void missingRecordName() {
        Assertions.assertThrows(NullPointerException.class, () -> SchemaBuilder.record(null).fields().name("f0").type().stringType().noDefault().endRecord());
    }

    @Test
    void testBoolean() {
        Schema.Type type = Schema.Type.BOOLEAN;
        Schema simple = (Schema)SchemaBuilder.builder().booleanType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.BooleanBuilder)SchemaBuilder.builder().booleanBuilder().prop("p", "v")).endBoolean();
        Assertions.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    void testInt() {
        Schema.Type type = Schema.Type.INT;
        Schema simple = (Schema)SchemaBuilder.builder().intType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.IntBuilder)SchemaBuilder.builder().intBuilder().prop("p", "v")).endInt();
        Assertions.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    void testLong() {
        Schema.Type type = Schema.Type.LONG;
        Schema simple = (Schema)SchemaBuilder.builder().longType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.LongBuilder)SchemaBuilder.builder().longBuilder().prop("p", "v")).endLong();
        Assertions.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    void testFloat() {
        Schema.Type type = Schema.Type.FLOAT;
        Schema simple = (Schema)SchemaBuilder.builder().floatType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.FloatBuilder)SchemaBuilder.builder().floatBuilder().prop("p", "v")).endFloat();
        Assertions.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    void duble() {
        Schema.Type type = Schema.Type.DOUBLE;
        Schema simple = (Schema)SchemaBuilder.builder().doubleType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.DoubleBuilder)SchemaBuilder.builder().doubleBuilder().prop("p", "v")).endDouble();
        Assertions.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    void string() {
        Schema.Type type = Schema.Type.STRING;
        Schema simple = (Schema)SchemaBuilder.builder().stringType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.StringBldr)SchemaBuilder.builder().stringBuilder().prop("p", "v")).endString();
        Assertions.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    void bytes() {
        Schema.Type type = Schema.Type.BYTES;
        Schema simple = (Schema)SchemaBuilder.builder().bytesType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.BytesBuilder)SchemaBuilder.builder().bytesBuilder().prop("p", "v")).endBytes();
        Assertions.assertEquals((Object)expected, (Object)built1);
    }

    @Test
    void testNull() {
        Schema.Type type = Schema.Type.NULL;
        Schema simple = (Schema)SchemaBuilder.builder().nullType();
        Schema expected = this.primitive(type, simple);
        Schema built1 = (Schema)((SchemaBuilder.NullBuilder)SchemaBuilder.builder().nullBuilder().prop("p", "v")).endNull();
        Assertions.assertEquals((Object)expected, (Object)built1);
    }

    private Schema primitive(Schema.Type type, Schema bare) {
        Schema bareByName = (Schema)SchemaBuilder.builder().type(type.getName());
        Assertions.assertEquals((Object)Schema.create((Schema.Type)type), (Object)bareByName);
        Assertions.assertEquals((Object)bareByName, (Object)bare);
        Schema p = Schema.create((Schema.Type)type);
        p.addProp("p", "v");
        return p;
    }

    @Test
    void recursiveRecord() {
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"LongList").fields().name("value").type().longType().noDefault().name("next").type().optional().type("LongList")).endRecord();
        Assertions.assertEquals((Object)"LongList", (Object)schema.getName());
        List fields = schema.getFields();
        Assertions.assertEquals((int)2, (int)fields.size());
        Assertions.assertEquals((Object)new Schema.Field("value", Schema.create((Schema.Type)Schema.Type.LONG), null), fields.get(0));
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)((Schema.Field)fields.get(1)).schema().getType());
        Assertions.assertEquals((Object)Schema.Type.NULL, (Object)((Schema)((Schema.Field)fields.get(1)).schema().getTypes().get(0)).getType());
        Schema recordSchema = (Schema)((Schema.Field)fields.get(1)).schema().getTypes().get(1);
        Assertions.assertEquals((Object)Schema.Type.RECORD, (Object)recordSchema.getType());
        Assertions.assertEquals((Object)"LongList", (Object)recordSchema.getName());
        Assertions.assertEquals((Object)NullNode.getInstance(), (Object)((Schema.Field)fields.get(1)).defaultValue());
    }

    @Test
    void testEnum() {
        List<String> symbols = Arrays.asList("a", "b");
        Schema expected = Schema.createEnum((String)"myenum", null, null, symbols);
        expected.addProp("p", "v");
        Schema schema = (Schema)((SchemaBuilder.EnumBuilder)SchemaBuilder.enumeration((String)"myenum").prop("p", "v")).symbols(new String[]{"a", "b"});
        Assertions.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    void enumWithDefault() {
        List<String> symbols = Arrays.asList("a", "b");
        String enumDefault = "a";
        Schema expected = Schema.createEnum((String)"myenum", null, null, symbols, (String)enumDefault);
        expected.addProp("p", "v");
        Schema schema = (Schema)((SchemaBuilder.EnumBuilder)SchemaBuilder.enumeration((String)"myenum").prop("p", "v")).defaultSymbol(enumDefault).symbols(new String[]{"a", "b"});
        Assertions.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    void fixed() {
        Schema expected = Schema.createFixed((String)"myfixed", null, null, (int)16);
        expected.addAlias("myOldFixed");
        Schema schema = (Schema)((SchemaBuilder.FixedBuilder)SchemaBuilder.fixed((String)"myfixed").aliases(new String[]{"myOldFixed"})).size(16);
        Assertions.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    void array() {
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema expected = Schema.createArray((Schema)longSchema);
        Schema schema1 = (Schema)SchemaBuilder.array().items().longType();
        Assertions.assertEquals((Object)expected, (Object)schema1);
        Schema schema2 = (Schema)SchemaBuilder.array().items(longSchema);
        Assertions.assertEquals((Object)expected, (Object)schema2);
        Schema schema3 = (Schema)((SchemaBuilder.ArrayBuilder)SchemaBuilder.array().prop("p", "v")).items().type("long");
        expected.addProp("p", "v");
        Assertions.assertEquals((Object)expected, (Object)schema3);
    }

    @Test
    void map() {
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Schema expected = Schema.createMap((Schema)intSchema);
        Schema schema1 = (Schema)SchemaBuilder.map().values().intType();
        Assertions.assertEquals((Object)expected, (Object)schema1);
        Schema schema2 = (Schema)SchemaBuilder.map().values(intSchema);
        Assertions.assertEquals((Object)expected, (Object)schema2);
        Schema schema3 = (Schema)((SchemaBuilder.MapBuilder)SchemaBuilder.map().prop("p", "v")).values().type("int");
        expected.addProp("p", "v");
        Assertions.assertEquals((Object)expected, (Object)schema3);
    }

    @Test
    void unionAndNullable() {
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.add(Schema.create((Schema.Type)Schema.Type.LONG));
        types.add(Schema.create((Schema.Type)Schema.Type.NULL));
        Schema expected = Schema.createUnion(types);
        Schema schema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().longType()).and().nullType()).endUnion();
        Assertions.assertEquals((Object)expected, (Object)schema);
        schema = (Schema)SchemaBuilder.nullable().longType();
        Assertions.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    void fields() {
        Schema rec = (Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.FieldBuilder)SchemaBuilder.record((String)"Rec").fields().name("documented").doc("documented")).type().nullType().noDefault().name("ascending").orderAscending().type().booleanType().noDefault().name("descending").orderDescending().type().floatType().noDefault().name("ignored").orderIgnore().type().doubleType().noDefault().name("aliased").aliases(new String[]{"anAlias"})).type().stringType().noDefault().endRecord();
        Assertions.assertEquals((Object)"documented", (Object)rec.getField("documented").doc());
        Assertions.assertEquals((Object)Schema.Field.Order.ASCENDING, (Object)rec.getField("ascending").order());
        Assertions.assertEquals((Object)Schema.Field.Order.DESCENDING, (Object)rec.getField("descending").order());
        Assertions.assertEquals((Object)Schema.Field.Order.IGNORE, (Object)rec.getField("ignored").order());
        Assertions.assertTrue((boolean)rec.getField("aliased").aliases().contains("anAlias"));
    }

    @Test
    void fieldShortcuts() {
        Schema full = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"Blah").fields().name("rbool").type().booleanType().noDefault().name("obool").type().optional().booleanType()).name("nbool").type().nullable().booleanType().booleanDefault(true).name("rint").type().intType().noDefault().name("oint").type().optional().intType()).name("nint").type().nullable().intType().intDefault(1).name("rlong").type().longType().noDefault().name("olong").type().optional().longType()).name("nlong").type().nullable().longType().longDefault(2L).name("rfloat").type().floatType().noDefault().name("ofloat").type().optional().floatType()).name("nfloat").type().nullable().floatType().floatDefault(-1.1f).name("rdouble").type().doubleType().noDefault().name("odouble").type().optional().doubleType()).name("ndouble").type().nullable().doubleType().doubleDefault(99.9).name("rstring").type().stringType().noDefault().name("ostring").type().optional().stringType()).name("nstring").type().nullable().stringType().stringDefault("def").name("rbytes").type().bytesType().noDefault().name("obytes").type().optional().bytesType()).name("nbytes").type().nullable().bytesType().bytesDefault(new byte[]{1, 2, 3}).endRecord();
        Schema shortcut = (Schema)SchemaBuilder.record((String)"Blah").fields().requiredBoolean("rbool").optionalBoolean("obool").nullableBoolean("nbool", true).requiredInt("rint").optionalInt("oint").nullableInt("nint", 1).requiredLong("rlong").optionalLong("olong").nullableLong("nlong", 2L).requiredFloat("rfloat").optionalFloat("ofloat").nullableFloat("nfloat", -1.1f).requiredDouble("rdouble").optionalDouble("odouble").nullableDouble("ndouble", 99.9).requiredString("rstring").optionalString("ostring").nullableString("nstring", "def").requiredBytes("rbytes").optionalBytes("obytes").nullableBytes("nbytes", new byte[]{1, 2, 3}).endRecord();
        Assertions.assertEquals((Object)full, (Object)shortcut);
    }

    @Test
    void names() {
        Schema r = (Schema)((SchemaBuilder.FixedDefault)SchemaBuilder.record((String)"Rec").fields().name("f0").type().fixed("org.foo.MyFixed").size(1)).noDefault().name("f1").type("org.foo.MyFixed").noDefault().name("f2").type("org.foo.MyFixed", "").noDefault().name("f3").type("org.foo.MyFixed", null).noDefault().name("f4").type("org.foo.MyFixed", "ignorethis").noDefault().name("f5").type("MyFixed", "org.foo").noDefault().endRecord();
        Schema expected = Schema.createFixed((String)"org.foo.MyFixed", null, null, (int)1);
        this.checkField(r, expected, "f0");
        this.checkField(r, expected, "f1");
        this.checkField(r, expected, "f2");
        this.checkField(r, expected, "f3");
        this.checkField(r, expected, "f4");
        this.checkField(r, expected, "f5");
        Schema f = (Schema)SchemaBuilder.builder((String)"").fixed("Foo").size(1);
        Assertions.assertEquals((Object)Schema.createFixed((String)"Foo", null, null, (int)1), (Object)f);
        r = (Schema)((SchemaBuilder.FixedDefault)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Rec").namespace("org.foo")).fields().name("f0").type().fixed("MyFixed").size(1)).noDefault().name("f1").type("org.foo.MyFixed").noDefault().name("f2").type("org.foo.MyFixed", "").noDefault().name("f3").type("org.foo.MyFixed", null).noDefault().name("f4").type("org.foo.MyFixed", "ignorethis").noDefault().name("f5").type("MyFixed", "org.foo").noDefault().name("f6").type("MyFixed", null).noDefault().name("f7").type("MyFixed").noDefault().endRecord();
        this.checkField(r, expected, "f0");
        this.checkField(r, expected, "f1");
        this.checkField(r, expected, "f2");
        this.checkField(r, expected, "f3");
        this.checkField(r, expected, "f4");
        this.checkField(r, expected, "f5");
        this.checkField(r, expected, "f6");
        this.checkField(r, expected, "f7");
        r = (Schema)((SchemaBuilder.FixedDefault)((SchemaBuilder.FixedBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Rec").namespace("org.rec")).fields().name("f0").type().fixed("MyFixed").namespace("org.foo")).size(1)).noDefault().name("f1").type("org.foo.MyFixed").noDefault().name("f2").type("org.foo.MyFixed", "").noDefault().name("f3").type("org.foo.MyFixed", null).noDefault().name("f4").type("org.foo.MyFixed", "ignorethis").noDefault().name("f5").type("MyFixed", "org.foo").noDefault().endRecord();
        this.checkField(r, expected, "f0");
        this.checkField(r, expected, "f1");
        this.checkField(r, expected, "f2");
        this.checkField(r, expected, "f3");
        this.checkField(r, expected, "f4");
        this.checkField(r, expected, "f5");
        expected = Schema.createFixed((String)"MyFixed", null, null, (int)1);
        r = (Schema)((SchemaBuilder.FixedDefault)((SchemaBuilder.FixedBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Rec").namespace("org.rec")).fields().name("f0").type().fixed("MyFixed").namespace("")).size(1)).noDefault().name("f1").type("MyFixed", "").noDefault().endRecord();
        this.checkField(r, expected, "f0");
        this.checkField(r, expected, "f1");
        SchemaBuilder.fixed((String)"org.test.long").size(1);
        ((SchemaBuilder.FixedBuilder)SchemaBuilder.fixed((String)"long").namespace("org.test")).size(1);
        SchemaBuilder.builder((String)"org.test").fixed("long").size(1);
    }

    private void checkField(Schema r, Schema expected, String name) {
        Assertions.assertEquals((Object)expected, (Object)r.getField(name).schema());
    }

    @Test
    void namesFailRedefined() {
        Assertions.assertThrows(SchemaParseException.class, () -> ((SchemaBuilder.EnumDefault)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"Rec").fields().name("f0").type().enumeration("MyEnum").symbols(new String[]{"A", "B"})).enumDefault("A").name("f1").type().enumeration("MyEnum").symbols(new String[]{"X", "Y"})).noDefault().endRecord());
    }

    @Test
    void namesFailAbsent() {
        Assertions.assertThrows(SchemaParseException.class, () -> SchemaBuilder.builder().type("notdefined"));
    }

    @Test
    void nameReserved() {
        Assertions.assertThrows(AvroTypeException.class, () -> ((SchemaBuilder.FixedBuilder)SchemaBuilder.fixed((String)"long").namespace("")).size(1));
    }

    @Test
    void fieldTypesAndDefaultValues() {
        byte[] bytedef = new byte[]{3};
        ByteBuffer bufdef = ByteBuffer.wrap(bytedef);
        String strdef = "\u0003";
        HashMap<String, String> mapdef = new HashMap<String, String>();
        mapdef.put("a", "A");
        List<String> arrdef = Collections.singletonList("arr");
        Schema rec = (Schema)SchemaBuilder.record((String)"inner").fields().name("f").type().intType().noDefault().endRecord();
        Schema rec2 = (Schema)SchemaBuilder.record((String)"inner2").fields().name("f2").type().intType().noDefault().endRecord();
        GenericData.Record recdef = new GenericRecordBuilder(rec).set("f", (Object)1).build();
        GenericData.Record recdef2 = new GenericRecordBuilder(rec2).set("f2", (Object)2).build();
        Schema r = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.ArrayDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.MapDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.EnumDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FixedDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.BytesDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.StringDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.DoubleDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FloatDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.LongDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.IntDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.BooleanDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.RecordDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.EnumDefault)((SchemaBuilder.FixedDefault)((SchemaBuilder.FixedDefault)((SchemaBuilder.FixedDefault)SchemaBuilder.record((String)"r").fields().name("boolF").type().booleanType().booleanDefault(false).name("intF").type().intType().intDefault(1).name("longF").type().longType().longDefault(2L).name("floatF").type().floatType().floatDefault(3.0f).name("doubleF").type().doubleType().doubleDefault(4.0).name("stringF").type().stringType().stringDefault("def").name("bytesF1").type().bytesType().bytesDefault(bytedef).name("bytesF2").type().bytesType().bytesDefault(bufdef).name("bytesF3").type().bytesType().bytesDefault(strdef).name("nullF").type().nullType().nullDefault().name("fixedF1").type().fixed("F1").size(1)).fixedDefault(bytedef).name("fixedF2").type().fixed("F2").size(1)).fixedDefault(bufdef).name("fixedF3").type().fixed("F3").size(1)).fixedDefault(strdef).name("enumF").type().enumeration("E1").symbols(new String[]{"S"})).enumDefault("S").name("mapF").type().map().values().stringType()).mapDefault(mapdef).name("arrayF").type().array().items().stringType()).arrayDefault(arrdef).name("recordF").type().record("inner").fields().name("f").type().intType().noDefault().endRecord()).recordDefault((GenericRecord)recdef).name("byName").type("E1").withDefault((Object)"S").name("boolU").type().unionOf().booleanType().and().intType()).endUnion()).booleanDefault(false).name("intU").type().unionOf().intType().and().longType()).endUnion()).intDefault(1).name("longU").type().unionOf().longType().and().intType()).endUnion()).longDefault(2L).name("floatU").type().unionOf().floatType().and().intType()).endUnion()).floatDefault(3.0f).name("doubleU").type().unionOf().doubleType().and().intType()).endUnion()).doubleDefault(4.0).name("stringU").type().unionOf().stringType().and().intType()).endUnion()).stringDefault("def").name("bytesU").type().unionOf().bytesType().and().intType()).endUnion()).bytesDefault(bytedef).name("nullU").type().unionOf().nullType().and().intType()).endUnion()).nullDefault().name("fixedU").type().unionOf().fixed("F4").size(1)).and().intType()).endUnion()).fixedDefault(bytedef).name("enumU").type().unionOf().enumeration("E2").symbols(new String[]{"SS"})).and().intType()).endUnion()).enumDefault("SS").name("mapU").type().unionOf().map().values().stringType()).and().intType()).endUnion()).mapDefault(mapdef).name("arrayU").type().unionOf().array().items().stringType()).and().intType()).endUnion()).arrayDefault(arrdef).name("recordU").type().unionOf().record("inner2").fields().name("f2").type().intType().noDefault().endRecord()).and().intType()).endUnion()).recordDefault((GenericRecord)recdef2).endRecord();
        GenericData.Record newRec = new GenericRecordBuilder(r).build();
        Assertions.assertEquals((Object)false, (Object)newRec.get("boolF"));
        Assertions.assertEquals((Object)false, (Object)newRec.get("boolU"));
        Assertions.assertEquals((Object)1, (Object)newRec.get("intF"));
        Assertions.assertEquals((Object)1, (Object)newRec.get("intU"));
        Assertions.assertEquals((Object)2L, (Object)newRec.get("longF"));
        Assertions.assertEquals((Object)2L, (Object)newRec.get("longU"));
        Assertions.assertEquals((Object)Float.valueOf(3.0f), (Object)newRec.get("floatF"));
        Assertions.assertEquals((Object)Float.valueOf(3.0f), (Object)newRec.get("floatU"));
        Assertions.assertEquals((Object)4.0, (Object)newRec.get("doubleF"));
        Assertions.assertEquals((Object)4.0, (Object)newRec.get("doubleU"));
        Assertions.assertEquals((Object)"def", (Object)newRec.get("stringF").toString());
        Assertions.assertEquals((Object)"def", (Object)newRec.get("stringU").toString());
        Assertions.assertEquals((Object)bufdef, (Object)newRec.get("bytesF1"));
        Assertions.assertEquals((Object)bufdef, (Object)newRec.get("bytesF2"));
        Assertions.assertEquals((Object)bufdef, (Object)newRec.get("bytesF3"));
        Assertions.assertEquals((Object)bufdef, (Object)newRec.get("bytesU"));
        Assertions.assertNull((Object)newRec.get("nullF"));
        Assertions.assertNull((Object)newRec.get("nullU"));
        Assertions.assertArrayEquals((byte[])bytedef, (byte[])((GenericData.Fixed)newRec.get("fixedF1")).bytes());
        Assertions.assertArrayEquals((byte[])bytedef, (byte[])((GenericData.Fixed)newRec.get("fixedF2")).bytes());
        Assertions.assertArrayEquals((byte[])bytedef, (byte[])((GenericData.Fixed)newRec.get("fixedF3")).bytes());
        Assertions.assertArrayEquals((byte[])bytedef, (byte[])((GenericData.Fixed)newRec.get("fixedU")).bytes());
        Assertions.assertEquals((Object)"S", (Object)newRec.get("enumF").toString());
        Assertions.assertEquals((Object)"SS", (Object)newRec.get("enumU").toString());
        Map map = (Map)newRec.get("mapF");
        Assertions.assertEquals((int)mapdef.size(), (int)map.size());
        for (Map.Entry e : map.entrySet()) {
            Assertions.assertEquals(mapdef.get(((CharSequence)e.getKey()).toString()), (Object)((CharSequence)e.getValue()).toString());
        }
        Assertions.assertEquals((Object)newRec.get("mapF"), (Object)newRec.get("mapU"));
        GenericData.Array arr = (GenericData.Array)newRec.get("arrayF");
        Assertions.assertEquals((int)arrdef.size(), (int)arr.size());
        for (CharSequence c : arr) {
            Assertions.assertTrue((boolean)arrdef.contains(c.toString()));
        }
        Assertions.assertEquals((Object)newRec.get("arrayF"), (Object)newRec.get("arrayU"));
        Assertions.assertEquals((Object)recdef, (Object)newRec.get("recordF"));
        Assertions.assertEquals((Object)recdef2, (Object)newRec.get("recordU"));
        Assertions.assertEquals((Object)"S", (Object)newRec.get("byName").toString());
    }

    @Test
    void badDefault() {
        Assertions.assertThrows(SchemaBuilderException.class, () -> SchemaBuilder.record((String)"r").fields().name("f").type(Schema.create((Schema.Type)Schema.Type.INT)).withDefault(new Object()).endRecord());
    }

    @Test
    void unionFieldBuild() {
        ((SchemaBuilder.BooleanDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.record((String)"r").fields().name("allUnion").type().unionOf().booleanType().and().intType()).and().longType()).and().floatType()).and().doubleType()).and().stringType()).and().bytesType()).and().nullType()).and().fixed("Fix").size(1)).and().enumeration("Enu").symbols(new String[]{"Q"})).and().array().items().intType()).and().map().values().longType()).and().record("Rec").fields().name("one").type("Fix").noDefault().endRecord()).endUnion()).booleanDefault(false).endRecord();
    }

    @Test
    void defaults() throws IOException {
        Schema writeSchema = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"r").fields().name("requiredInt").type().intType().noDefault().name("optionalInt").type().optional().intType()).name("nullableIntWithDefault").type().nullable().intType().intDefault(3).endRecord();
        GenericData.Record rec1 = new GenericRecordBuilder(writeSchema).set("requiredInt", (Object)1).build();
        Assertions.assertEquals((Object)1, (Object)rec1.get("requiredInt"));
        Assertions.assertNull((Object)rec1.get("optionalInt"));
        Assertions.assertEquals((Object)3, (Object)rec1.get("nullableIntWithDefault"));
        GenericData.Record rec2 = new GenericRecordBuilder(writeSchema).set("requiredInt", (Object)1).set("optionalInt", (Object)2).set("nullableIntWithDefault", (Object)13).build();
        Assertions.assertEquals((Object)1, (Object)rec2.get("requiredInt"));
        Assertions.assertEquals((Object)2, (Object)rec2.get("optionalInt"));
        Assertions.assertEquals((Object)13, (Object)rec2.get("nullableIntWithDefault"));
        File file = new File(this.DIR.getPath(), "testDefaults.avro");
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            writer.create(writeSchema, file);
            writer.append((Object)rec1);
            writer.append((Object)rec2);
        }
        Schema readSchema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"r").fields().name("requiredInt").type().intType().noDefault().name("optionalInt").type().optional().intType()).name("nullableIntWithDefault").type().nullable().intType().intDefault(3).name("newOptionalInt").type().optional().intType()).name("newNullableIntWithDefault").type().nullable().intType().intDefault(5).endRecord();
        try (DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader(writeSchema, readSchema));){
            GenericData.Record rec1read = (GenericData.Record)reader.iterator().next();
            Assertions.assertEquals((Object)1, (Object)rec1read.get("requiredInt"));
            Assertions.assertNull((Object)rec1read.get("optionalInt"));
            Assertions.assertEquals((Object)3, (Object)rec1read.get("nullableIntWithDefault"));
            Assertions.assertNull((Object)rec1read.get("newOptionalInt"));
            Assertions.assertEquals((Object)5, (Object)rec1read.get("newNullableIntWithDefault"));
            GenericData.Record rec2read = (GenericData.Record)reader.iterator().next();
            Assertions.assertEquals((Object)1, (Object)rec2read.get("requiredInt"));
            Assertions.assertEquals((Object)2, (Object)rec2read.get("optionalInt"));
            Assertions.assertEquals((Object)13, (Object)rec2read.get("nullableIntWithDefault"));
            Assertions.assertNull((Object)rec2read.get("newOptionalInt"));
            Assertions.assertEquals((Object)5, (Object)rec2read.get("newNullableIntWithDefault"));
        }
    }

    @Test
    void defaultTypes() {
        Integer intDef = 1;
        Long longDef = 2L;
        Float floatDef = Float.valueOf(3.0f);
        Double doubleDef = 4.0;
        Schema schema = (Schema)SchemaBuilder.record((String)"r").fields().name("int").type().intType().intDefault(intDef.intValue()).name("long").type().longType().longDefault(longDef.longValue()).name("float").type().floatType().floatDefault(floatDef.floatValue()).name("double").type().doubleType().doubleDefault(doubleDef.doubleValue()).endRecord();
        Assertions.assertEquals((Object)intDef, (Object)schema.getField("int").defaultVal(), (String)"int field default type or value mismatch");
        Assertions.assertEquals((Object)longDef, (Object)schema.getField("long").defaultVal(), (String)"long field default type or value mismatch");
        Assertions.assertEquals((Object)floatDef, (Object)schema.getField("float").defaultVal(), (String)"float field default type or value mismatch");
        Assertions.assertEquals((Object)doubleDef, (Object)schema.getField("double").defaultVal(), (String)"double field default type or value mismatch");
    }

    @Test
    void validateDefaultsEnabled() {
        Assertions.assertThrows(AvroRuntimeException.class, () -> {
            try {
                SchemaBuilder.record((String)"ValidationRecord").fields().name("IntegerField").type("int").withDefault((Object)"Invalid").endRecord();
            }
            catch (AvroRuntimeException e) {
                Assertions.assertEquals((Object)"Invalid default for field IntegerField: \"Invalid\" not a \"int\"", (Object)e.getMessage(), (String)"Default behavior is to raise an exception due to record having an invalid default");
                throw e;
            }
        });
    }

    @Test
    void validateDefaultsDisabled() {
        String fieldName = "IntegerField";
        String defaultValue = "foo";
        Schema schema = (Schema)SchemaBuilder.record((String)"ValidationRecord").fields().name("IntegerField").notValidatingDefaults().type("int").withDefault((Object)"foo").endRecord();
        Assertions.assertNull((Object)schema.getField("IntegerField").defaultVal(), (String)"Differing types, so this returns null");
        Assertions.assertEquals((Object)"foo", (Object)schema.getField("IntegerField").defaultValue().asText(), (String)"Schema is able to be successfully created as is without validation");
    }

    @Test
    void namespaceDefaulting() {
        Schema d = (Schema)SchemaBuilder.builder().intType();
        Schema c = (Schema)SchemaBuilder.record((String)"c").fields().name("d").type(d).noDefault().endRecord();
        Schema b = (Schema)SchemaBuilder.record((String)"b").fields().name("c").type(c).noDefault().endRecord();
        Schema a1 = (Schema)SchemaBuilder.record((String)"default.a").fields().name("b").type(b).noDefault().endRecord();
        Schema a2 = new Schema.Parser().parse(a1.toString());
        Assertions.assertEquals((Object)a2, (Object)a1);
    }

    @Test
    void namesAcceptAll() throws InterruptedException {
        Runnable r = () -> {
            Schema.setNameValidator((NameValidator)NameValidator.NO_VALIDATION);
            Schema schema = (Schema)SchemaBuilder.record((String)"7name").fields().name("123").type(Schema.create((Schema.Type)Schema.Type.INT)).noDefault().endRecord();
            Assertions.assertNotNull((Object)schema);
            Assertions.assertEquals((Object)"7name", (Object)schema.getName());
            Schema.Field field = schema.getField("123");
            Assertions.assertEquals((Object)"123", (Object)field.name());
        };
        Throwable[] exception = new Throwable[]{null};
        Thread t = new Thread(r);
        t.setUncaughtExceptionHandler((th, e) -> {
            exception[0] = e;
        });
        t.start();
        t.join();
        Assertions.assertNull((Object)exception[0], () -> exception[0].getMessage());
    }
}

