/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Resolver;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.FastReaderBuilder;
import org.apache.avro.io.JsonDecoder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestResolver {
    TestResolver() {
    }

    @Test
    void resolveTime() {
        Schema writeSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Schema readSchema = new TimeConversions.TimeMicrosConversion().getRecommendedSchema();
        Resolver.Action action = Resolver.resolve((Schema)writeSchema, (Schema)readSchema);
        Assertions.assertNotNull((Object)action);
        MatcherAssert.assertThat((String)"Wrong class for action", (Object)action, (Matcher)Matchers.instanceOf(Resolver.Promote.class));
        Assertions.assertEquals((Object)action.type, (Object)Resolver.Action.Type.PROMOTE);
        Assertions.assertNotNull((Object)action.logicalType);
    }

    @Test
    void resolveUnion() {
        Schema schema = new TimeConversions.TimeMicrosConversion().getRecommendedSchema();
        Schema writeSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.INT)});
        Schema readSchema = Schema.createUnion((Schema[])new Schema[]{schema});
        Resolver.Action action = Resolver.resolve((Schema)writeSchema, (Schema)readSchema);
        Assertions.assertNotNull((Object)action);
        Assertions.assertEquals((Object)action.type, (Object)Resolver.Action.Type.WRITER_UNION);
        MatcherAssert.assertThat((String)"Wrong class for action", (Object)action, (Matcher)Matchers.instanceOf(Resolver.WriterUnion.class));
        Assertions.assertEquals((int)1, (int)((Resolver.WriterUnion)action).actions.length);
        Resolver.Action innerAction = ((Resolver.WriterUnion)action).actions[0];
        MatcherAssert.assertThat((String)"Wrong class for action", (Object)innerAction, (Matcher)Matchers.instanceOf(Resolver.ReaderUnion.class));
        Resolver.ReaderUnion innerUnionAction = (Resolver.ReaderUnion)innerAction;
        Resolver.Action promoteAction = innerUnionAction.actualAction;
        Assertions.assertEquals((Object)promoteAction.type, (Object)Resolver.Action.Type.PROMOTE);
        Assertions.assertNotNull((Object)promoteAction.logicalType);
    }

    @Test
    void resolveEnum() throws IOException {
        Schema writeSchema = Schema.createEnum((String)"myEnum", (String)"", (String)"n1", Arrays.asList("e1", "e3", "e4"));
        Schema readSchema = Schema.createEnum((String)"myEnum", (String)"", (String)"n1", Arrays.asList("e1", "e2", "e3"), (String)"e2");
        Resolver.Action action = Resolver.resolve((Schema)writeSchema, (Schema)readSchema);
        Assertions.assertNotNull((Object)action);
        Assertions.assertEquals((Object)action.type, (Object)Resolver.Action.Type.ENUM);
        MatcherAssert.assertThat((String)"Wrong class for action", (Object)action, (Matcher)Matchers.instanceOf(Resolver.EnumAdjust.class));
        Resolver.EnumAdjust adjust = (Resolver.EnumAdjust)action;
        Assertions.assertArrayEquals((int[])new int[]{0, 2, 1}, (int[])adjust.adjustments);
        Assertions.assertEquals((Object)"e1", (Object)adjust.values[0].toString());
        Assertions.assertEquals((Object)"e3", (Object)adjust.values[1].toString());
        Assertions.assertEquals((Object)"e2", (Object)adjust.values[2].toString());
        FastReaderBuilder reader = FastReaderBuilder.get();
        Schema writeRecord = Schema.createRecord((String)"rec1", (String)"", (String)"", (boolean)false, Arrays.asList(new Schema.Field("f1", writeSchema, "")));
        Schema readRecord = Schema.createRecord((String)"rec1", (String)"", (String)"", (boolean)false, Arrays.asList(new Schema.Field("f1", readSchema, "")));
        DatumReader datumReader = reader.createDatumReader(writeRecord, readRecord);
        JsonDecoder e2 = DecoderFactory.get().jsonDecoder(readRecord, "{ \"f1\" : \"e2\" }");
        Object read = datumReader.read(null, (Decoder)e2);
        Assertions.assertNotNull((Object)read);
        MatcherAssert.assertThat((String)"", (Object)read, (Matcher)Matchers.instanceOf(IndexedRecord.class));
        IndexedRecord result = (IndexedRecord)read;
        Assertions.assertEquals((Object)"e3", (Object)result.get(0).toString());
    }

    @Test
    void promoteIsValid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Resolver.Promote.isValid((Schema)Schema.create((Schema.Type)Schema.Type.INT), (Schema)Schema.create((Schema.Type)Schema.Type.INT)));
        Assertions.assertTrue((boolean)Resolver.Promote.isValid((Schema)Schema.create((Schema.Type)Schema.Type.INT), (Schema)Schema.create((Schema.Type)Schema.Type.LONG)));
        Assertions.assertFalse((boolean)Resolver.Promote.isValid((Schema)Schema.create((Schema.Type)Schema.Type.LONG), (Schema)Schema.create((Schema.Type)Schema.Type.INT)));
        Assertions.assertTrue((boolean)Resolver.Promote.isValid((Schema)Schema.create((Schema.Type)Schema.Type.INT), (Schema)Schema.create((Schema.Type)Schema.Type.FLOAT)));
        Assertions.assertFalse((boolean)Resolver.Promote.isValid((Schema)Schema.create((Schema.Type)Schema.Type.FLOAT), (Schema)Schema.create((Schema.Type)Schema.Type.INT)));
        Assertions.assertTrue((boolean)Resolver.Promote.isValid((Schema)Schema.create((Schema.Type)Schema.Type.FLOAT), (Schema)Schema.create((Schema.Type)Schema.Type.DOUBLE)));
        Assertions.assertFalse((boolean)Resolver.Promote.isValid((Schema)Schema.create((Schema.Type)Schema.Type.DOUBLE), (Schema)Schema.create((Schema.Type)Schema.Type.FLOAT)));
    }
}

