/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class TestNestedRecords {
    @Test
    void singleSubRecord() throws IOException {
        Schema child = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Child").namespace("org.apache.avro.nested")).fields().requiredString("childField").endRecord();
        Schema parent = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Parent").namespace("org.apache.avro.nested")).fields().requiredString("parentField1").name("child1").type(child).noDefault().requiredString("parentField2").endRecord();
        String inputAsExpected = "{\n \"parentField1\": \"parentValue1\",\n \"child1\":{\n    \"childField\":\"childValue1\"\n },\n \"parentField2\":\"parentValue2\"\n}";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("{\n \"parentField1\": \"parentValue1\",\n \"child1\":{\n    \"childField\":\"childValue1\"\n },\n \"parentField2\":\"parentValue2\"\n}".getBytes(StandardCharsets.UTF_8));
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(parent, (InputStream)inputStream);
        GenericDatumReader reader = new GenericDatumReader(parent);
        GenericData.Record decoded = (GenericData.Record)reader.read(null, (Decoder)decoder);
        MatcherAssert.assertThat((Object)decoded.get("parentField1").toString(), (Matcher)CoreMatchers.equalTo((Object)"parentValue1"));
        MatcherAssert.assertThat((Object)decoded.get("parentField2").toString(), (Matcher)CoreMatchers.equalTo((Object)"parentValue2"));
        MatcherAssert.assertThat((Object)((GenericData.Record)decoded.get("child1")).get("childField").toString(), (Matcher)CoreMatchers.equalTo((Object)"childValue1"));
    }

    @Test
    void singleSubRecordExtraField() throws IOException {
        Schema child = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Child").namespace("org.apache.avro.nested")).fields().requiredString("childField").endRecord();
        Schema parent = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"Parent").namespace("org.apache.avro.nested")).fields().requiredString("parentField1").name("child1").type(child).noDefault().requiredString("parentField2").endRecord();
        String inputAsExpected = "{\n \"parentField1\": \"parentValue1\",\n \"child1\":{\n    \"childField\":\"childValue1\",\n    \"extraField\":\"extraValue\"\n },\n \"parentField2\":\"parentValue2\"\n}";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("{\n \"parentField1\": \"parentValue1\",\n \"child1\":{\n    \"childField\":\"childValue1\",\n    \"extraField\":\"extraValue\"\n },\n \"parentField2\":\"parentValue2\"\n}".getBytes(StandardCharsets.UTF_8));
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(parent, (InputStream)inputStream);
        GenericDatumReader reader = new GenericDatumReader(parent);
        GenericData.Record decoded = (GenericData.Record)reader.read(null, (Decoder)decoder);
        MatcherAssert.assertThat((Object)decoded.get("parentField1").toString(), (Matcher)CoreMatchers.equalTo((Object)"parentValue1"));
        MatcherAssert.assertThat((Object)decoded.get("parentField2").toString(), (Matcher)CoreMatchers.equalTo((Object)"parentValue2"));
        MatcherAssert.assertThat((Object)((GenericData.Record)decoded.get("child1")).get("childField").toString(), (Matcher)CoreMatchers.equalTo((Object)"childValue1"));
    }
}

