/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLogicalType {
    @Test
    void decimalFromSchema() {
        Schema schema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        schema.addProp("logicalType", "decimal");
        schema.addProp("precision", (Object)9);
        schema.addProp("scale", (Object)2);
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema);
        Assertions.assertTrue((boolean)(logicalType instanceof LogicalTypes.Decimal), (String)"Should be a Decimal");
        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
        Assertions.assertEquals((int)9, (int)decimal.getPrecision(), (String)"Should have correct precision");
        Assertions.assertEquals((int)2, (int)decimal.getScale(), (String)"Should have correct scale");
    }

    @Test
    void invalidLogicalTypeIgnored() {
        Schema schema = Schema.createFixed((String)"aFixed", null, null, (int)2);
        schema.addProp("logicalType", "decimal");
        schema.addProp("precision", (Object)9);
        schema.addProp("scale", (Object)2);
        Assertions.assertNull((Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema), (String)"Should ignore invalid logical type");
    }

    @Test
    void decimalWithNonByteArrayTypes() {
        Schema[] nonBytes;
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)5, (int)2);
        for (Schema schema : nonBytes = new Schema[]{Schema.createRecord((String)"Record", null, null, (boolean)false), Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.BYTES)), Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.BYTES)), Schema.createEnum((String)"Enum", null, null, Arrays.asList("a", "b")), Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.BYTES), Schema.createFixed((String)"fixed", null, null, (int)4))), Schema.create((Schema.Type)Schema.Type.BOOLEAN), Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.FLOAT), Schema.create((Schema.Type)Schema.Type.DOUBLE), Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)}) {
            TestLogicalType.assertThrows("Should reject type: " + schema.getType(), IllegalArgumentException.class, "Logical type decimal must be backed by fixed or bytes", () -> TestLogicalType.lambda$decimalWithNonByteArrayTypes$0((LogicalType)decimal, schema));
        }
    }

    @Test
    void unknownFromJsonNode() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        schema.addProp("logicalType", "unknown");
        schema.addProp("someProperty", (Object)34);
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema);
        Assertions.assertNull((Object)logicalType, (String)"Should not return a LogicalType instance");
    }

    @Test
    void decimalBytesHasNoPrecisionLimit() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)Integer.MAX_VALUE).addToSchema(schema);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)((LogicalTypes.Decimal)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema)).getPrecision(), (String)"Precision should be an Integer.MAX_VALUE");
    }

    @Test
    void decimalFixedPrecisionLimit() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "fixed(4) cannot store 10 digits (max 9)", () -> {
            LogicalTypes.decimal((int)10).addToSchema(schema);
            return null;
        });
        Assertions.assertNull((Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema), (String)"Invalid logical type should not be set on schema");
        Schema schema129 = Schema.createFixed((String)"aDecimal", null, null, (int)129);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "fixed(129) cannot store 311 digits (max 310)", () -> {
            LogicalTypes.decimal((int)311).addToSchema(schema129);
            return null;
        });
        Assertions.assertNull((Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema129), (String)"Invalid logical type should not be set on schema");
    }

    @Test
    void decimalFailsWithZeroPrecision() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "Invalid decimal precision: 0 (must be positive)", () -> {
            LogicalTypes.decimal((int)0).addToSchema(schema);
            return null;
        });
        Assertions.assertNull((Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema), (String)"Invalid logical type should not be set on schema");
    }

    @Test
    void decimalFailsWithNegativePrecision() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "Invalid decimal precision: -9 (must be positive)", () -> {
            LogicalTypes.decimal((int)-9).addToSchema(schema);
            return null;
        });
        Assertions.assertNull((Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema), (String)"Invalid logical type should not be set on schema");
    }

    @Test
    void decimalScaleBoundedByPrecision() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "Invalid decimal scale: 10 (greater than precision: 9)", () -> {
            LogicalTypes.decimal((int)9, (int)10).addToSchema(schema);
            return null;
        });
        Assertions.assertNull((Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema), (String)"Invalid logical type should not be set on schema");
    }

    @Test
    void decimalFailsWithNegativeScale() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        TestLogicalType.assertThrows("Should reject precision", IllegalArgumentException.class, "Invalid decimal scale: -2 (must be positive)", () -> {
            LogicalTypes.decimal((int)9, (int)-2).addToSchema(schema);
            return null;
        });
        Assertions.assertNull((Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema), (String)"Invalid logical type should not be set on schema");
    }

    @Test
    void schemaRejectsSecondLogicalType() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        LogicalTypes.decimal((int)9).addToSchema(schema);
        TestLogicalType.assertThrows("Should reject second logical type", AvroRuntimeException.class, "Can't overwrite property: scale", () -> {
            LogicalTypes.decimal((int)9, (int)2).addToSchema(schema);
            return null;
        });
        Assertions.assertEquals((Object)LogicalTypes.decimal((int)9), (Object)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema), (String)"First logical type should still be set on schema");
    }

    @Test
    void decimalDefaultScale() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        LogicalTypes.decimal((int)9).addToSchema(schema);
        Assertions.assertEquals((int)0, (int)((LogicalTypes.Decimal)LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema)).getScale(), (String)"Scale should be a 0");
    }

    @Test
    void fixedDecimalToFromJson() {
        Schema schema = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        LogicalTypes.decimal((int)9, (int)2).addToSchema(schema);
        Schema parsed = new Schema.Parser().parse(schema.toString(true));
        Assertions.assertEquals((Object)schema, (Object)parsed, (String)"Constructed and parsed schemas should match");
    }

    @Test
    void bytesDecimalToFromJson() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        LogicalTypes.decimal((int)9, (int)2).addToSchema(schema);
        Schema parsed = new Schema.Parser().parse(schema.toString(true));
        Assertions.assertEquals((Object)schema, (Object)parsed, (String)"Constructed and parsed schemas should match");
    }

    @Test
    void uuidExtendsString() {
        Schema uuidSchema = LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        Assertions.assertEquals((Object)LogicalTypes.uuid(), (Object)uuidSchema.getLogicalType());
        TestLogicalType.assertThrows("UUID requires a string", IllegalArgumentException.class, "Uuid can only be used with an underlying string or fixed type", () -> LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)));
    }

    @Test
    void durationExtendsFixed12() {
        Schema durationSchema = LogicalTypes.duration().addToSchema(Schema.createFixed((String)"f", null, null, (int)12));
        Assertions.assertEquals((Object)LogicalTypes.duration(), (Object)durationSchema.getLogicalType());
        TestLogicalType.assertThrows("Duration requires a fixed(12)", IllegalArgumentException.class, "Duration can only be used with an underlying fixed type of size 12.", () -> LogicalTypes.duration().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)));
        TestLogicalType.assertThrows("Duration requires a fixed(12)", IllegalArgumentException.class, "Duration can only be used with an underlying fixed type of size 12.", () -> LogicalTypes.duration().addToSchema(Schema.createFixed((String)"wrong", null, null, (int)42)));
    }

    @Test
    void logicalTypeEquals() {
        LogicalTypes.Decimal decimal90 = LogicalTypes.decimal((int)9);
        LogicalTypes.Decimal decimal80 = LogicalTypes.decimal((int)8);
        LogicalTypes.Decimal decimal92 = LogicalTypes.decimal((int)9, (int)2);
        TestLogicalType.assertEqualsTrue("Same decimal", LogicalTypes.decimal((int)9, (int)0), decimal90);
        TestLogicalType.assertEqualsTrue("Same decimal", LogicalTypes.decimal((int)8, (int)0), decimal80);
        TestLogicalType.assertEqualsTrue("Same decimal", LogicalTypes.decimal((int)9, (int)2), decimal92);
        TestLogicalType.assertEqualsFalse("Different logical type", LogicalTypes.uuid(), decimal90);
        TestLogicalType.assertEqualsFalse("Different precision", decimal90, decimal80);
        TestLogicalType.assertEqualsFalse("Different scale", decimal90, decimal92);
    }

    @Test
    void logicalTypeInSchemaEquals() {
        Schema schema1 = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        Schema schema2 = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        Schema schema3 = Schema.createFixed((String)"aDecimal", null, null, (int)4);
        Assertions.assertNotSame((Object)schema1, (Object)schema2);
        Assertions.assertNotSame((Object)schema1, (Object)schema3);
        TestLogicalType.assertEqualsTrue("No logical types", schema1, schema2);
        TestLogicalType.assertEqualsTrue("No logical types", schema1, schema3);
        LogicalTypes.decimal((int)9).addToSchema(schema1);
        TestLogicalType.assertEqualsFalse("Two has no logical type", schema1, schema2);
        LogicalTypes.decimal((int)9).addToSchema(schema2);
        TestLogicalType.assertEqualsTrue("Same logical types", schema1, schema2);
        LogicalTypes.decimal((int)9, (int)2).addToSchema(schema3);
        TestLogicalType.assertEqualsFalse("Different logical type", schema1, schema3);
    }

    @Test
    void registerLogicalTypeThrowsIfTypeNameNotProvided() {
        TestLogicalType.assertThrows("Should error if type name was not provided", UnsupportedOperationException.class, "LogicalTypeFactory TypeName has not been provided", () -> {
            LogicalTypes.register(schema -> LogicalTypes.date());
            return null;
        });
    }

    @Test
    void registerLogicalTypeWithName() {
        LogicalTypes.LogicalTypeFactory factory = new LogicalTypes.LogicalTypeFactory(){

            public LogicalType fromSchema(Schema schema) {
                return LogicalTypes.date();
            }

            public String getTypeName() {
                return "typename";
            }
        };
        LogicalTypes.register((String)"registered", (LogicalTypes.LogicalTypeFactory)factory);
        MatcherAssert.assertThat((Object)LogicalTypes.getCustomRegisteredTypes(), (Matcher)IsMapContaining.hasEntry((Object)"registered", (Object)factory));
    }

    @Test
    void registerLogicalTypeWithFactoryName() {
        LogicalTypes.LogicalTypeFactory factory = new LogicalTypes.LogicalTypeFactory(){

            public LogicalType fromSchema(Schema schema) {
                return LogicalTypes.date();
            }

            public String getTypeName() {
                return "factory";
            }
        };
        LogicalTypes.register((LogicalTypes.LogicalTypeFactory)factory);
        MatcherAssert.assertThat((Object)LogicalTypes.getCustomRegisteredTypes(), (Matcher)IsMapContaining.hasEntry((Object)"factory", (Object)factory));
    }

    @Test
    void registerLogicalTypeWithFactoryNameNotProvided() {
        LogicalTypes.LogicalTypeFactory factory = schema -> LogicalTypes.date();
        LogicalTypes.register((String)"logicalTypeName", (LogicalTypes.LogicalTypeFactory)factory);
        MatcherAssert.assertThat((Object)LogicalTypes.getCustomRegisteredTypes(), (Matcher)IsMapContaining.hasEntry((Object)"logicalTypeName", (Object)factory));
    }

    @Test
    public void testRegisterLogicalTypeFactoryByServiceLoader() {
        MatcherAssert.assertThat((Object)LogicalTypes.getCustomRegisteredTypes(), (Matcher)IsMapContaining.hasEntry((Matcher)Matchers.equalTo((Object)"custom"), (Matcher)Matchers.instanceOf(LogicalTypes.LogicalTypeFactory.class)));
    }

    public static void assertEqualsTrue(String message, Object o1, Object o2) {
        Assertions.assertEquals((Object)o1, (Object)o2, (String)("Should be equal (forward): " + message));
        Assertions.assertEquals((Object)o2, (Object)o1, (String)("Should be equal (reverse): " + message));
    }

    public static void assertEqualsFalse(String message, Object o1, Object o2) {
        Assertions.assertNotEquals((Object)o1, (Object)o2, (String)("Should be equal (forward): " + message));
        Assertions.assertNotEquals((Object)o2, (Object)o1, (String)("Should be equal (reverse): " + message));
    }

    public static void assertThrows(String message, Class<? extends Exception> expected, String containedInMessage, Callable<?> callable) {
        try {
            callable.call();
            Assertions.fail((String)("No exception was thrown (" + message + "), expected: " + expected.getName()));
        }
        catch (Exception actual) {
            Assertions.assertEquals(expected, actual.getClass(), (String)message);
            Assertions.assertTrue((boolean)actual.getMessage().contains(containedInMessage), (String)("Expected exception message (" + containedInMessage + ") missing: " + actual.getMessage()));
        }
    }

    private static /* synthetic */ Object lambda$decimalWithNonByteArrayTypes$0(LogicalType decimal, Schema schema) throws Exception {
        decimal.addToSchema(schema);
        return null;
    }
}

