/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDataFileCustomSync {
    private byte[] createDataFile(byte[] sync) throws IOException {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        w.create(schema, (OutputStream)baos, sync);
        w.append((Object)new Utf8("apple"));
        w.append((Object)new Utf8("banana"));
        w.sync();
        w.append((Object)new Utf8("celery"));
        w.append((Object)new Utf8("date"));
        w.sync();
        w.append((Object)new Utf8("endive"));
        w.append((Object)new Utf8("fig"));
        w.close();
        return baos.toByteArray();
    }

    private static byte[] generateSync() {
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            long time = System.currentTimeMillis();
            digester.update((UUID.randomUUID() + "@" + time).getBytes(StandardCharsets.UTF_8));
            return digester.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    void invalidSync() throws IOException {
        Assertions.assertThrows(IOException.class, () -> {
            byte[] sync = new byte[8];
            this.createDataFile(sync);
        });
    }

    @Test
    void randomSync() throws IOException {
        byte[] sync = TestDataFileCustomSync.generateSync();
        byte[] randSyncFile = this.createDataFile(null);
        byte[] customSyncFile = this.createDataFile(sync);
        Assertions.assertFalse((boolean)Arrays.equals(randSyncFile, customSyncFile));
    }

    @Test
    void customSync() throws IOException {
        byte[] sync = TestDataFileCustomSync.generateSync();
        byte[] customSyncFile = this.createDataFile(sync);
        byte[] sameCustomSyncFile = this.createDataFile(sync);
        Assertions.assertArrayEquals((byte[])customSyncFile, (byte[])sameCustomSyncFile);
    }
}

