/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDataFileCorruption {
    private static final File DIR = new File(System.getProperty("java.io.tmpdir"));

    private File makeFile(String name) {
        return new File(DIR, "test-" + name + ".avro");
    }

    @Test
    void corruptedFile() throws IOException {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        w.create(schema, (OutputStream)baos);
        w.append((Object)new Utf8("apple"));
        w.append((Object)new Utf8("banana"));
        w.sync();
        w.append((Object)new Utf8("celery"));
        w.append((Object)new Utf8("date"));
        long pos = w.sync();
        w.append((Object)new Utf8("endive"));
        w.append((Object)new Utf8("fig"));
        w.close();
        byte[] original = baos.toByteArray();
        int corruptPosition = (int)pos - 16;
        int corruptedBytes = 3;
        byte[] corrupted = new byte[original.length + corruptedBytes];
        System.arraycopy(original, 0, corrupted, 0, corruptPosition);
        System.arraycopy(original, corruptPosition, corrupted, corruptPosition + corruptedBytes, original.length - corruptPosition);
        File file = this.makeFile("corrupt");
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        out.write(corrupted);
        out.close();
        try (DataFileReader r = new DataFileReader(file, (DatumReader)new GenericDatumReader(schema));){
            Assertions.assertEquals((Object)"apple", (Object)r.next().toString());
            Assertions.assertEquals((Object)"banana", (Object)r.next().toString());
            long prevSync = r.previousSync();
            r.next();
            Assertions.fail((String)"Corrupt block should throw exception");
            r.sync(prevSync);
            Assertions.assertEquals((Object)"endive", (Object)r.next().toString());
            Assertions.assertEquals((Object)"fig", (Object)r.next().toString());
            Assertions.assertFalse((boolean)r.hasNext());
        }
        catch (AvroRuntimeException e) {
            Assertions.assertEquals((Object)"Invalid sync!", (Object)e.getCause().getMessage());
        }
    }
}

