/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.EnumSet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.ParseContext;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.util.SchemaResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ParseContextTest {
    Schema fooRecord;
    Schema fooRecordCopy;
    Schema barEnum;
    Schema bazFixed;
    Schema mehRecord;
    ParseContext fooBarBaz;

    @BeforeEach
    public void setUp() throws Exception {
        this.fooRecord = (Schema)SchemaBuilder.record((String)"ns.Foo").fields().endRecord();
        this.fooRecordCopy = (Schema)SchemaBuilder.record((String)"ns.Foo").fields().endRecord();
        this.barEnum = (Schema)SchemaBuilder.enumeration((String)"ns.Bar").symbols(new String[0]);
        this.bazFixed = (Schema)SchemaBuilder.fixed((String)"ns.Baz").size(8);
        this.mehRecord = (Schema)SchemaBuilder.record((String)"ns.Meh").fields().endRecord();
        this.fooBarBaz = new ParseContext();
        this.fooBarBaz.put(this.fooRecord);
        this.fooBarBaz.put(this.barEnum);
        this.fooBarBaz.put(this.bazFixed);
    }

    @Test
    public void checkNewNameContextContainsPrimitives() {
        EnumSet<Schema.Type[]> complexTypes = EnumSet.of(Schema.Type.RECORD, new Schema.Type[]{Schema.Type.ENUM, Schema.Type.FIXED, Schema.Type.UNION, Schema.Type.ARRAY, Schema.Type.MAP});
        EnumSet<Schema.Type[]> primitives = EnumSet.complementOf(complexTypes);
        ParseContext context = new ParseContext();
        for (Schema.Type type : complexTypes) {
            Assertions.assertFalse((boolean)context.contains(type.getName()));
        }
        for (Schema.Type type : primitives) {
            Assertions.assertTrue((boolean)context.contains(type.getName()));
        }
    }

    @Test
    public void primitivesAreNotCached() {
        EnumSet<Schema.Type[]> primitives = EnumSet.complementOf(EnumSet.of(Schema.Type.RECORD, new Schema.Type[]{Schema.Type.ENUM, Schema.Type.FIXED, Schema.Type.UNION, Schema.Type.ARRAY, Schema.Type.MAP}));
        ParseContext context = new ParseContext();
        for (Schema.Type type : primitives) {
            Schema first = context.find(type.getName(), null);
            Schema second = context.find(type.getName(), null);
            Assertions.assertEquals((Object)first, (Object)second);
            Assertions.assertNotSame((Object)first, (Object)second);
            first.addProp("logicalType", "brick");
            Assertions.assertNotEquals((Object)first, (Object)second);
        }
    }

    @Test
    public void validateSchemaRetrievalFailure() {
        Schema unknown = Schema.createFixed((String)"unknown", null, null, (int)0);
        Schema unresolved = this.fooBarBaz.find("unknown", null);
        Assertions.assertTrue((boolean)SchemaResolver.isUnresolvedSchema((Schema)unresolved));
        Assertions.assertEquals((Object)unknown.getFullName(), (Object)SchemaResolver.getUnresolvedSchemaName((Schema)unresolved));
    }

    @Test
    public void validateSchemaRetrievalByFullName() {
        Assertions.assertSame((Object)this.fooRecord, (Object)this.fooBarBaz.find(this.fooRecord.getFullName(), null));
    }

    @Test
    public void validateSchemaRetrievalBySimpleName() {
        Assertions.assertSame((Object)this.fooRecord, (Object)this.fooBarBaz.find(this.fooRecord.getName(), this.fooRecord.getNamespace()));
    }

    @Test
    public void verifyPutIsIdempotent() {
        ParseContext context = new ParseContext();
        Assertions.assertNotEquals((Object)this.fooRecord, (Object)context.find(this.fooRecord.getFullName(), null));
        context.put(this.fooRecord);
        Assertions.assertEquals((Object)this.fooRecord, (Object)context.find(this.fooRecord.getFullName(), null));
        context.put(this.fooRecord);
        Assertions.assertEquals((Object)this.fooRecord, (Object)context.find(this.fooRecord.getFullName(), null));
    }

    @Test
    public void verifyPutOnlyAcceptsNamedSchemas() {
        ParseContext context = new ParseContext();
        Assertions.assertThrows(AvroRuntimeException.class, () -> context.put(Schema.create((Schema.Type)Schema.Type.STRING)));
    }

    @Test
    public void verifyAddDoesNotAllowChangingSchemas() {
        Schema fooEnum = (Schema)SchemaBuilder.enumeration((String)"ns.Foo").symbols(new String[0]);
        ParseContext context = new ParseContext();
        context.put(this.fooRecord);
        Assertions.assertThrows(AvroRuntimeException.class, () -> context.put(fooEnum));
    }
}

