/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.RandomData;

public class GenerateBlockingData {
    private static final int SYNC_INTERVAL = 1000;
    private static ByteArrayOutputStream buffer = new ByteArrayOutputStream(2000);
    private static EncoderFactory factory = EncoderFactory.get();
    private static Encoder bufOut = EncoderFactory.get().blockingBinaryEncoder((OutputStream)buffer, null);
    private static int blockCount;

    private static void writeBlock(Encoder vout, FileOutputStream out) throws IOException {
        vout.writeLong((long)blockCount);
        bufOut.flush();
        buffer.writeTo(out);
        buffer.reset();
        blockCount = 0;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Usage: GenerateBlockingData <schemafile> <outputfile> <count>");
            System.exit(-1);
        }
        Schema sch = new Schema.Parser().parse(new File(args[0]));
        File outputFile = new File(args[1]);
        int numObjects = Integer.parseInt(args[2]);
        FileOutputStream out = new FileOutputStream(outputFile, false);
        GenericDatumWriter dout = new GenericDatumWriter();
        dout.setSchema(sch);
        BinaryEncoder vout = factory.directBinaryEncoder((OutputStream)out, null);
        vout.writeLong((long)numObjects);
        for (Object datum : new RandomData(sch, numObjects)) {
            dout.write(datum, bufOut);
            ++blockCount;
            if (buffer.size() < 1000) continue;
            GenerateBlockingData.writeBlock((Encoder)vout, out);
        }
        if (blockCount > 0) {
            GenerateBlockingData.writeBlock((Encoder)vout, out);
        }
        out.flush();
        out.close();
    }
}

