/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.net.URI;
import org.apache.avro.FormattedSchemaParser;
import org.apache.avro.ParseContext;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummySchemaParser
implements FormattedSchemaParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DummySchemaParser.class);
    public static final String SCHEMA_TEXT_ONE = "one";
    public static final Schema FIXED_SCHEMA = Schema.createFixed((String)"DummyOne", null, (String)"tests", (int)42);
    public static final String SCHEMA_TEXT_ERROR = "error";
    public static final String SCHEMA_TEXT_IO_ERROR = "io-error";
    public static final String ERROR_MESSAGE = "Syntax error";
    public static final String IO_ERROR_MESSAGE = "I/O error";

    public Schema parse(ParseContext parseContext, URI baseUri, CharSequence formattedSchema) throws IOException, SchemaParseException {
        LOGGER.debug("Using DummySchemaParser for {}", (Object)formattedSchema);
        if (SCHEMA_TEXT_ONE.contentEquals(formattedSchema)) {
            parseContext.put(FIXED_SCHEMA);
            return FIXED_SCHEMA;
        }
        if (SCHEMA_TEXT_ERROR.contentEquals(formattedSchema)) {
            throw new SchemaParseException(ERROR_MESSAGE);
        }
        if (SCHEMA_TEXT_IO_ERROR.contentEquals(formattedSchema)) {
            throw new IOException(IO_ERROR_MESSAGE);
        }
        return null;
    }
}

