/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util.springframework;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.util.springframework.ComparableComparator;
import org.apache.avro.util.springframework.ConcurrentReferenceHashMap;
import org.apache.avro.util.springframework.NullSafeComparator;
import org.apache.avro.util.springframework.StopWatch;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class TestConcurrentReferenceHashMap {
    private static final Comparator<? super String> NULL_SAFE_STRING_SORT = new NullSafeComparator<String>(new ComparableComparator(), true);
    private TestWeakConcurrentCache<Integer, String> map = new TestWeakConcurrentCache();

    TestConcurrentReferenceHashMap() {
    }

    @Test
    void shouldCreateWithDefaults() {
        ConcurrentReferenceHashMap map = new ConcurrentReferenceHashMap();
        MatcherAssert.assertThat((Object)map.getSegmentsSize(), (Matcher)Matchers.equalTo((Object)16));
        MatcherAssert.assertThat((Object)map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)Float.valueOf(map.getLoadFactor()), (Matcher)Matchers.equalTo((Object)Float.valueOf(0.75f)));
    }

    @Test
    void shouldCreateWithInitialCapacity() {
        ConcurrentReferenceHashMap map = new ConcurrentReferenceHashMap(32);
        MatcherAssert.assertThat((Object)map.getSegmentsSize(), (Matcher)Matchers.equalTo((Object)16));
        MatcherAssert.assertThat((Object)map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)Float.valueOf(map.getLoadFactor()), (Matcher)Matchers.equalTo((Object)Float.valueOf(0.75f)));
    }

    @Test
    void shouldCreateWithInitialCapacityAndLoadFactor() {
        ConcurrentReferenceHashMap map = new ConcurrentReferenceHashMap(32, 0.5f);
        MatcherAssert.assertThat((Object)map.getSegmentsSize(), (Matcher)Matchers.equalTo((Object)16));
        MatcherAssert.assertThat((Object)map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)Float.valueOf(map.getLoadFactor()), (Matcher)Matchers.equalTo((Object)Float.valueOf(0.5f)));
    }

    @Test
    void shouldCreateWithInitialCapacityAndConcurrentLevel() {
        ConcurrentReferenceHashMap map = new ConcurrentReferenceHashMap(16, 2);
        MatcherAssert.assertThat((Object)map.getSegmentsSize(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)8));
        MatcherAssert.assertThat((Object)Float.valueOf(map.getLoadFactor()), (Matcher)Matchers.equalTo((Object)Float.valueOf(0.75f)));
    }

    @Test
    void shouldCreateFullyCustom() {
        ConcurrentReferenceHashMap map = new ConcurrentReferenceHashMap(5, 0.5f, 3);
        MatcherAssert.assertThat((Object)map.getSegmentsSize(), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)Float.valueOf(map.getLoadFactor()), (Matcher)Matchers.equalTo((Object)Float.valueOf(0.5f)));
    }

    @Test
    void shouldNeedNonNegativeInitialCapacity() {
        new ConcurrentReferenceHashMap(0, 1);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new TestWeakConcurrentCache(-1, 1));
        Assertions.assertTrue((boolean)e.getMessage().contains("Initial capacity must not be negative"));
    }

    @Test
    void shouldNeedPositiveLoadFactor() {
        new ConcurrentReferenceHashMap(0, 0.1f, 1);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new TestWeakConcurrentCache(0, 0.0f, 1));
        Assertions.assertTrue((boolean)e.getMessage().contains("Load factor must be positive"));
    }

    @Test
    void shouldNeedPositiveConcurrencyLevel() {
        new ConcurrentReferenceHashMap(1, 1);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new TestWeakConcurrentCache(1, 0));
        Assertions.assertTrue((boolean)e.getMessage().contains("Concurrency level must be positive"));
    }

    @Test
    void shouldPutAndGet() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.put(123, "123");
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"123"));
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.put(123, "123b");
        Assertions.assertEquals((int)1, (int)this.map.size());
        this.map.put(123, null);
        Assertions.assertEquals((int)1, (int)this.map.size());
    }

    @Test
    void shouldReplaceOnDoublePut() {
        this.map.put(123, "321");
        this.map.put(123, "123");
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"123"));
    }

    @Test
    void shouldPutNullKey() {
        Assertions.assertNull((Object)this.map.get(null));
        MatcherAssert.assertThat((Object)((String)this.map.getOrDefault(null, "456")), (Matcher)Matchers.equalTo((Object)"456"));
        this.map.put(null, "123");
        MatcherAssert.assertThat((Object)((String)this.map.get(null)), (Matcher)Matchers.equalTo((Object)"123"));
        MatcherAssert.assertThat((Object)((String)this.map.getOrDefault(null, "456")), (Matcher)Matchers.equalTo((Object)"123"));
    }

    @Test
    void shouldPutNullValue() {
        Assertions.assertNull((Object)this.map.get(123));
        MatcherAssert.assertThat((Object)((String)this.map.getOrDefault(123, "456")), (Matcher)Matchers.equalTo((Object)"456"));
        this.map.put(123, "321");
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"321"));
        MatcherAssert.assertThat((Object)((String)this.map.getOrDefault(123, "456")), (Matcher)Matchers.equalTo((Object)"321"));
        this.map.put(123, null);
        Assertions.assertNull((Object)this.map.get(123));
        Assertions.assertNull((Object)this.map.getOrDefault(123, "456"));
    }

    @Test
    void shouldGetWithNoItems() {
        Assertions.assertNull((Object)this.map.get(123));
    }

    @Test
    void shouldApplySupplementalHash() {
        Integer key = 123;
        this.map.put(key, "123");
        Assertions.assertNotEquals((int)this.map.getSupplementalHash(), (int)key.hashCode());
        Assertions.assertNotEquals((int)(this.map.getSupplementalHash() >> 30 & 0xFF), (int)0);
    }

    @Test
    void shouldGetFollowingNexts() {
        this.map = new TestWeakConcurrentCache(1, 10.0f, 1);
        this.map.put(1, "1");
        this.map.put(2, "2");
        this.map.put(3, "3");
        MatcherAssert.assertThat((Object)this.map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)this.map.get(1)), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)((String)this.map.get(2)), (Matcher)Matchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)((String)this.map.get(3)), (Matcher)Matchers.equalTo((Object)"3"));
        Assertions.assertNull((Object)this.map.get(4));
    }

    @Test
    void shouldResize() {
        this.map = new TestWeakConcurrentCache(1, 0.75f, 1);
        this.map.put(1, "1");
        MatcherAssert.assertThat((Object)this.map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((String)this.map.get(1)), (Matcher)Matchers.equalTo((Object)"1"));
        this.map.put(2, "2");
        MatcherAssert.assertThat((Object)this.map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((String)this.map.get(1)), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)((String)this.map.get(2)), (Matcher)Matchers.equalTo((Object)"2"));
        this.map.put(3, "3");
        MatcherAssert.assertThat((Object)this.map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)((String)this.map.get(1)), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)((String)this.map.get(2)), (Matcher)Matchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)((String)this.map.get(3)), (Matcher)Matchers.equalTo((Object)"3"));
        this.map.put(4, "4");
        MatcherAssert.assertThat((Object)this.map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)8));
        MatcherAssert.assertThat((Object)((String)this.map.get(4)), (Matcher)Matchers.equalTo((Object)"4"));
        for (int i = 1; i <= 5; ++i) {
            this.map.put(i, String.valueOf(i));
        }
        MatcherAssert.assertThat((Object)this.map.getSegment(0).getSize(), (Matcher)Matchers.equalTo((Object)8));
        MatcherAssert.assertThat((Object)((String)this.map.get(5)), (Matcher)Matchers.equalTo((Object)"5"));
    }

    @Test
    void shouldPurgeOnGet() {
        this.map = new TestWeakConcurrentCache(1, 0.75f, 1);
        for (int i = 1; i <= 5; ++i) {
            this.map.put(i, String.valueOf(i));
        }
        this.map.getMockReference(1, ConcurrentReferenceHashMap.Restructure.NEVER).queueForPurge();
        this.map.getMockReference(3, ConcurrentReferenceHashMap.Restructure.NEVER).queueForPurge();
        Assertions.assertNull((Object)this.map.getReference(1, ConcurrentReferenceHashMap.Restructure.WHEN_NECESSARY));
        MatcherAssert.assertThat((Object)((String)this.map.get(2)), (Matcher)Matchers.equalTo((Object)"2"));
        Assertions.assertNull((Object)this.map.getReference(3, ConcurrentReferenceHashMap.Restructure.WHEN_NECESSARY));
        MatcherAssert.assertThat((Object)((String)this.map.get(4)), (Matcher)Matchers.equalTo((Object)"4"));
        MatcherAssert.assertThat((Object)((String)this.map.get(5)), (Matcher)Matchers.equalTo((Object)"5"));
    }

    @Test
    void shouldPurgeOnPut() {
        this.map = new TestWeakConcurrentCache(1, 0.75f, 1);
        for (int i = 1; i <= 5; ++i) {
            this.map.put(i, String.valueOf(i));
        }
        this.map.getMockReference(1, ConcurrentReferenceHashMap.Restructure.NEVER).queueForPurge();
        this.map.getMockReference(3, ConcurrentReferenceHashMap.Restructure.NEVER).queueForPurge();
        this.map.put(1, "1");
        MatcherAssert.assertThat((Object)((String)this.map.get(1)), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)((String)this.map.get(2)), (Matcher)Matchers.equalTo((Object)"2"));
        Assertions.assertNull((Object)this.map.getReference(3, ConcurrentReferenceHashMap.Restructure.WHEN_NECESSARY));
        MatcherAssert.assertThat((Object)((String)this.map.get(4)), (Matcher)Matchers.equalTo((Object)"4"));
        MatcherAssert.assertThat((Object)((String)this.map.get(5)), (Matcher)Matchers.equalTo((Object)"5"));
    }

    @Test
    void shouldPutIfAbsent() {
        Assertions.assertNull((Object)this.map.putIfAbsent(123, "123"));
        MatcherAssert.assertThat((Object)((String)this.map.putIfAbsent(123, "123b")), (Matcher)Matchers.equalTo((Object)"123"));
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"123"));
    }

    @Test
    void shouldPutIfAbsentWithNullValue() {
        Assertions.assertNull((Object)this.map.putIfAbsent(123, null));
        Assertions.assertNull((Object)this.map.putIfAbsent(123, "123"));
        Assertions.assertNull((Object)this.map.get(123));
    }

    @Test
    void shouldPutIfAbsentWithNullKey() {
        Assertions.assertNull((Object)this.map.putIfAbsent(null, "123"));
        MatcherAssert.assertThat((Object)((String)this.map.putIfAbsent(null, "123b")), (Matcher)Matchers.equalTo((Object)"123"));
        MatcherAssert.assertThat((Object)((String)this.map.get(null)), (Matcher)Matchers.equalTo((Object)"123"));
    }

    @Test
    void shouldRemoveKeyAndValue() {
        this.map.put(123, "123");
        Assertions.assertFalse((boolean)this.map.remove(123, "456"));
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"123"));
        Assertions.assertTrue((boolean)this.map.remove(123, "123"));
        Assertions.assertFalse((boolean)this.map.containsKey(123));
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    void shouldRemoveKeyAndValueWithExistingNull() {
        this.map.put(123, null);
        Assertions.assertFalse((boolean)this.map.remove(123, "456"));
        Assertions.assertNull((Object)this.map.get(123));
        Assertions.assertTrue((boolean)this.map.remove(123, null));
        Assertions.assertFalse((boolean)this.map.containsKey(123));
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    void shouldReplaceOldValueWithNewValue() {
        this.map.put(123, "123");
        Assertions.assertFalse((boolean)this.map.replace(123, "456", "789"));
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"123"));
        Assertions.assertTrue((boolean)this.map.replace(123, "123", "789"));
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"789"));
    }

    @Test
    void shouldReplaceOldNullValueWithNewValue() {
        this.map.put(123, null);
        Assertions.assertFalse((boolean)this.map.replace(123, "456", "789"));
        Assertions.assertNull((Object)this.map.get(123));
        Assertions.assertTrue((boolean)this.map.replace(123, null, "789"));
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"789"));
    }

    @Test
    void shouldReplaceValue() {
        this.map.put(123, "123");
        MatcherAssert.assertThat((Object)((String)this.map.replace(123, "456")), (Matcher)Matchers.equalTo((Object)"123"));
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"456"));
    }

    @Test
    void shouldReplaceNullValue() {
        this.map.put(123, null);
        Assertions.assertNull((Object)this.map.replace(123, "456"));
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"456"));
    }

    @Test
    void shouldGetSize() {
        Assertions.assertEquals((int)0, (int)this.map.size());
        this.map.put(123, "123");
        this.map.put(123, null);
        this.map.put(456, "456");
        Assertions.assertEquals((int)2, (int)this.map.size());
    }

    @Test
    void shouldSupportIsEmpty() {
        Assertions.assertTrue((boolean)this.map.isEmpty());
        this.map.put(123, "123");
        this.map.put(123, null);
        this.map.put(456, "456");
        Assertions.assertFalse((boolean)this.map.isEmpty());
    }

    @Test
    void shouldContainKey() {
        Assertions.assertFalse((boolean)this.map.containsKey(123));
        Assertions.assertFalse((boolean)this.map.containsKey(456));
        this.map.put(123, "123");
        this.map.put(456, null);
        Assertions.assertTrue((boolean)this.map.containsKey(123));
        Assertions.assertTrue((boolean)this.map.containsKey(456));
    }

    @Test
    void shouldContainValue() {
        Assertions.assertFalse((boolean)this.map.containsValue("123"));
        Assertions.assertFalse((boolean)this.map.containsValue(null));
        this.map.put(123, "123");
        this.map.put(456, null);
        Assertions.assertTrue((boolean)this.map.containsValue("123"));
        Assertions.assertTrue((boolean)this.map.containsValue(null));
    }

    @Test
    void shouldRemoveWhenKeyIsInMap() {
        this.map.put(123, null);
        this.map.put(456, "456");
        this.map.put(null, "789");
        Assertions.assertNull((Object)this.map.remove(123));
        MatcherAssert.assertThat((Object)((String)this.map.remove(456)), (Matcher)Matchers.equalTo((Object)"456"));
        MatcherAssert.assertThat((Object)((String)this.map.remove(null)), (Matcher)Matchers.equalTo((Object)"789"));
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    void shouldRemoveWhenKeyIsNotInMap() {
        Assertions.assertNull((Object)this.map.remove(123));
        Assertions.assertNull((Object)this.map.remove(null));
        Assertions.assertTrue((boolean)this.map.isEmpty());
    }

    @Test
    void shouldPutAll() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        m.put(123, "123");
        m.put(456, null);
        m.put(null, "789");
        this.map.putAll(m);
        Assertions.assertEquals((int)3, (int)this.map.size());
        MatcherAssert.assertThat((Object)((String)this.map.get(123)), (Matcher)Matchers.equalTo((Object)"123"));
        Assertions.assertNull((Object)this.map.get(456));
        MatcherAssert.assertThat((Object)((String)this.map.get(null)), (Matcher)Matchers.equalTo((Object)"789"));
    }

    @Test
    void shouldClear() {
        this.map.put(123, "123");
        this.map.put(456, null);
        this.map.put(null, "789");
        this.map.clear();
        Assertions.assertEquals((int)0, (int)this.map.size());
        Assertions.assertFalse((boolean)this.map.containsKey(123));
        Assertions.assertFalse((boolean)this.map.containsKey(456));
        Assertions.assertFalse((boolean)this.map.containsKey(null));
    }

    @Test
    void shouldGetKeySet() {
        this.map.put(123, "123");
        this.map.put(456, null);
        this.map.put(null, "789");
        HashSet<Integer> expected = new HashSet<Integer>();
        expected.add(123);
        expected.add(456);
        expected.add(null);
        MatcherAssert.assertThat((Object)this.map.keySet(), (Matcher)Matchers.equalTo(expected));
    }

    @Test
    void shouldGetValues() {
        this.map.put(123, "123");
        this.map.put(456, null);
        this.map.put(null, "789");
        ArrayList<? super String> actual = new ArrayList<String>(this.map.values());
        ArrayList<? super String> expected = new ArrayList<String>();
        expected.add("123");
        expected.add(null);
        expected.add("789");
        actual.sort(NULL_SAFE_STRING_SORT);
        expected.sort(NULL_SAFE_STRING_SORT);
        MatcherAssert.assertThat(actual, (Matcher)Matchers.equalTo(expected));
    }

    @Test
    void shouldGetEntrySet() {
        this.map.put(123, "123");
        this.map.put(456, null);
        this.map.put(null, "789");
        HashMap<Integer, String> expected = new HashMap<Integer, String>();
        expected.put(123, "123");
        expected.put(456, null);
        expected.put(null, "789");
        MatcherAssert.assertThat((Object)this.map.entrySet(), (Matcher)Matchers.equalTo(expected.entrySet()));
    }

    @Test
    void shouldGetEntrySetFollowingNext() {
        this.map = new TestWeakConcurrentCache(1, 10.0f, 1);
        this.map.put(1, "1");
        this.map.put(2, "2");
        this.map.put(3, "3");
        HashMap<Integer, String> expected = new HashMap<Integer, String>();
        expected.put(1, "1");
        expected.put(2, "2");
        expected.put(3, "3");
        MatcherAssert.assertThat((Object)this.map.entrySet(), (Matcher)Matchers.equalTo(expected.entrySet()));
    }

    @Test
    void shouldRemoveViaEntrySet() {
        this.map.put(1, "1");
        this.map.put(2, "2");
        this.map.put(3, "3");
        Iterator iterator = this.map.entrySet().iterator();
        iterator.next();
        iterator.next();
        iterator.remove();
        Assertions.assertThrows(IllegalStateException.class, iterator::remove);
        iterator.next();
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertEquals((int)2, (int)this.map.size());
        Assertions.assertFalse((boolean)this.map.containsKey(2));
    }

    @Test
    void shouldSetViaEntrySet() {
        this.map.put(1, "1");
        this.map.put(2, "2");
        this.map.put(3, "3");
        Iterator iterator = this.map.entrySet().iterator();
        iterator.next();
        ((Map.Entry)iterator.next()).setValue("2b");
        iterator.next();
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertEquals((int)3, (int)this.map.size());
        MatcherAssert.assertThat((Object)((String)this.map.get(2)), (Matcher)Matchers.equalTo((Object)"2b"));
    }

    @Test
    void containsViaEntrySet() {
        this.map.put(1, "1");
        this.map.put(2, "2");
        this.map.put(3, "3");
        Set entrySet = this.map.entrySet();
        Set<Map.Entry<Integer, String>> copy = new HashMap<Integer, String>((Map<Integer, String>)((Object)this.map)).entrySet();
        copy.forEach(entry -> Assertions.assertTrue((boolean)entrySet.contains(entry)));
        this.map.put(1, "A");
        this.map.put(2, "B");
        this.map.put(3, "C");
        copy.forEach(entry -> Assertions.assertFalse((boolean)entrySet.contains(entry)));
        this.map.put(1, "1");
        this.map.put(2, "2");
        this.map.put(3, "3");
        copy.forEach(entry -> Assertions.assertTrue((boolean)entrySet.contains(entry)));
        entrySet.clear();
        copy.forEach(entry -> Assertions.assertFalse((boolean)entrySet.contains(entry)));
    }

    @Test
    @Disabled(value="Intended for use during development only")
    void shouldBeFasterThanSynchronizedMap() throws InterruptedException {
        Map synchronizedMap = Collections.synchronizedMap(new WeakHashMap());
        StopWatch mapTime = this.timeMultiThreaded("SynchronizedMap", synchronizedMap, v -> new WeakReference<String>(String.valueOf(v)));
        System.out.println(mapTime.prettyPrint());
        this.map.setDisableTestHooks(true);
        StopWatch cacheTime = this.timeMultiThreaded("WeakConcurrentCache", (Map)((Object)this.map), String::valueOf);
        System.out.println(cacheTime.prettyPrint());
        Assertions.assertTrue((cacheTime.getTotalTimeSeconds() < mapTime.getTotalTimeSeconds() / 4.0 ? 1 : 0) != 0);
    }

    @Test
    void shouldSupportNullReference() {
        this.map.createReferenceManager().createReference(null, 1234, null);
    }

    private <V> StopWatch timeMultiThreaded(String id, final Map<Integer, V> map, ValueFactory<V> factory) throws InterruptedException {
        StopWatch stopWatch = new StopWatch(id);
        for (int i = 0; i < 500; ++i) {
            map.put(i, factory.newValue(i));
        }
        Thread[] threads = new Thread[30];
        stopWatch.start("Running threads");
        for (int threadIndex = 0; threadIndex < threads.length; ++threadIndex) {
            threads[threadIndex] = new Thread("Cache access thread " + threadIndex){

                @Override
                public void run() {
                    for (int j = 0; j < 1000; ++j) {
                        for (int i = 0; i < 1000; ++i) {
                            map.get(i);
                        }
                    }
                }
            };
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            thread.join(2000L);
        }
        stopWatch.stop();
        return stopWatch;
    }

    private static class TestWeakConcurrentCache<K, V>
    extends ConcurrentReferenceHashMap<K, V> {
        private int supplementalHash;
        private final LinkedList<MockReference<K, V>> queue = new LinkedList();
        private boolean disableTestHooks;

        public TestWeakConcurrentCache() {
        }

        public void setDisableTestHooks(boolean disableTestHooks) {
            this.disableTestHooks = disableTestHooks;
        }

        public TestWeakConcurrentCache(int initialCapacity, float loadFactor, int concurrencyLevel) {
            super(initialCapacity, loadFactor, concurrencyLevel);
        }

        public TestWeakConcurrentCache(int initialCapacity, int concurrencyLevel) {
            super(initialCapacity, concurrencyLevel);
        }

        protected int getHash(@Nullable Object o) {
            if (this.disableTestHooks) {
                return super.getHash(o);
            }
            this.supplementalHash = super.getHash(o);
            return o != null ? o.hashCode() : 0;
        }

        public int getSupplementalHash() {
            return this.supplementalHash;
        }

        protected ConcurrentReferenceHashMap.ReferenceManager createReferenceManager() {
            return new ConcurrentReferenceHashMap.ReferenceManager(){

                public ConcurrentReferenceHashMap.Reference<K, V> createReference(ConcurrentReferenceHashMap.Entry<K, V> entry, int hash, @Nullable ConcurrentReferenceHashMap.Reference<K, V> next) {
                    if (disableTestHooks) {
                        return super.createReference(entry, hash, next);
                    }
                    return new MockReference(entry, hash, next, queue);
                }

                public ConcurrentReferenceHashMap.Reference<K, V> pollForPurge() {
                    if (disableTestHooks) {
                        return super.pollForPurge();
                    }
                    return queue.isEmpty() ? null : (ConcurrentReferenceHashMap.Reference)queue.removeFirst();
                }
            };
        }

        public MockReference<K, V> getMockReference(K key, ConcurrentReferenceHashMap.Restructure restructure) {
            return (MockReference)super.getReference(key, restructure);
        }
    }

    private static class MockReference<K, V>
    implements ConcurrentReferenceHashMap.Reference<K, V> {
        private final int hash;
        private ConcurrentReferenceHashMap.Entry<K, V> entry;
        private final ConcurrentReferenceHashMap.Reference<K, V> next;
        private final LinkedList<MockReference<K, V>> queue;

        public MockReference(ConcurrentReferenceHashMap.Entry<K, V> entry, int hash, ConcurrentReferenceHashMap.Reference<K, V> next, LinkedList<MockReference<K, V>> queue) {
            this.hash = hash;
            this.entry = entry;
            this.next = next;
            this.queue = queue;
        }

        public ConcurrentReferenceHashMap.Entry<K, V> get() {
            return this.entry;
        }

        public int getHash() {
            return this.hash;
        }

        public ConcurrentReferenceHashMap.Reference<K, V> getNext() {
            return this.next;
        }

        public void release() {
            this.queue.add(this);
            this.entry = null;
        }

        public void queueForPurge() {
            this.queue.add(this);
        }
    }

    private static interface ValueFactory<V> {
        public V newValue(int var1);
    }
}

