/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.chrono.IsoChronology;
import java.time.chrono.JapaneseChronology;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.util.TimePeriod;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TimePeriodTest {
    private static final long TOO_LARGE = 6442450941L;

    TimePeriodTest() {
    }

    @Test
    void validateConstruction() {
        TimePeriod timePeriod = TimePeriod.of((long)12L, (long)34L, (long)56L);
        Assertions.assertSame((Object)timePeriod, (Object)TimePeriod.from((TemporalAmount)timePeriod));
        this.assertComponents(12L, 34L, 56L, timePeriod);
        this.assertComponents(14L, 3L, 0L, TimePeriod.from((TemporalAmount)IsoChronology.INSTANCE.period(1, 2, 3)));
        this.assertComponents(36000L, 0L, 0L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.MILLENNIA, 3L)));
        this.assertComponents(3600L, 0L, 0L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.CENTURIES, 3L)));
        this.assertComponents(360L, 0L, 0L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.DECADES, 3L)));
        this.assertComponents(36L, 0L, 0L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.YEARS, 3L)));
        this.assertComponents(3L, 0L, 0L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.MONTHS, 3L)));
        this.assertComponents(0L, 21L, 0L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.WEEKS, 3L)));
        this.assertComponents(0L, 3L, 0L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.DAYS, 3L)));
        this.assertComponents(0L, 2L, 0L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.HALF_DAYS, 4L)));
        this.assertComponents(0L, 2L, 43200000L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.HALF_DAYS, 5L)));
        this.assertComponents(0L, 0L, 10800000L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.HOURS, 3L)));
        this.assertComponents(0L, 0L, 180000L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.MINUTES, 3L)));
        this.assertComponents(0L, 0L, 3000L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.SECONDS, 3L)));
        this.assertComponents(0L, 0L, 3L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.MILLIS, 3L)));
        this.assertComponents(0L, 0L, 3L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.MICROS, 3000L)));
        this.assertComponents(0L, 0L, 3L, TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.NANOS, 3000000L)));
        Assertions.assertThrows(DateTimeException.class, () -> TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.MICROS, 3L)));
        Assertions.assertThrows(DateTimeException.class, () -> TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.NANOS, 3L)));
        Assertions.assertThrows(NullPointerException.class, () -> TimePeriod.from(null));
        Assertions.assertThrows(DateTimeException.class, () -> TimePeriod.from((TemporalAmount)JapaneseChronology.INSTANCE.period(1, 2, 3)));
        Assertions.assertThrows(UnsupportedTemporalTypeException.class, () -> TimePeriod.from((TemporalAmount)TimeAmount.of(ChronoUnit.ERAS, 1L)));
        Assertions.assertThrows(UnsupportedTemporalTypeException.class, () -> TimePeriod.from((TemporalAmount)TimeAmount.of(DummyUnit.INSTANCE, 3L)));
        Assertions.assertThrows(ArithmeticException.class, () -> TimePeriod.of((long)6442450941L, (long)0L, (long)0L));
        Assertions.assertThrows(ArithmeticException.class, () -> TimePeriod.of((long)0L, (long)6442450941L, (long)0L));
        Assertions.assertThrows(ArithmeticException.class, () -> TimePeriod.of((long)0L, (long)0L, (long)6442450941L));
        Assertions.assertThrows(UnsupportedTemporalTypeException.class, () -> TimePeriod.of((long)1L, (long)1L, (long)1L).get((TemporalUnit)ChronoUnit.ERAS));
    }

    @Test
    void checkConversionsFromJavaTime() {
        Assertions.assertEquals((Object)TimePeriod.of((long)12L, (long)0L, (long)0L), (Object)TimePeriod.from((TemporalAmount)Period.ofYears(1)));
        Assertions.assertEquals((Object)TimePeriod.of((long)2L, (long)0L, (long)0L), (Object)TimePeriod.from((TemporalAmount)Period.ofMonths(2)));
        Assertions.assertEquals((Object)TimePeriod.of((long)0L, (long)21L, (long)0L), (Object)TimePeriod.from((TemporalAmount)Period.ofWeeks(3)));
        Assertions.assertEquals((Object)TimePeriod.of((long)0L, (long)4L, (long)0L), (Object)TimePeriod.from((TemporalAmount)Period.ofDays(4)));
        Assertions.assertEquals((Object)TimePeriod.of((long)0L, (long)0L, (long)1L), (Object)TimePeriod.from((TemporalAmount)Duration.ofNanos(1000000L)));
        Assertions.assertEquals((Object)TimePeriod.of((long)0L, (long)0L, (long)2L), (Object)TimePeriod.from((TemporalAmount)Duration.ofMillis(2L)));
        Assertions.assertEquals((Object)TimePeriod.of((long)0L, (long)0L, (long)3000L), (Object)TimePeriod.from((TemporalAmount)Duration.ofSeconds(3L)));
        Assertions.assertEquals((Object)TimePeriod.of((long)0L, (long)0L, (long)240000L), (Object)TimePeriod.from((TemporalAmount)Duration.ofMinutes(4L)));
        Assertions.assertEquals((Object)TimePeriod.of((long)0L, (long)0L, (long)18000000L), (Object)TimePeriod.from((TemporalAmount)Duration.ofHours(5L)));
        Assertions.assertEquals((Object)TimePeriod.of((long)0L, (long)0L, (long)518400000L), (Object)TimePeriod.from((TemporalAmount)Duration.ofDays(6L)));
    }

    @Test
    void checkConversionsToJavaTime() {
        TimePeriod months = TimePeriod.of((long)1L, (long)0L, (long)0L);
        TimePeriod days = TimePeriod.of((long)0L, (long)2L, (long)0L);
        TimePeriod time = TimePeriod.of((long)0L, (long)0L, (long)3L);
        TimePeriod all = TimePeriod.of((long)1L, (long)2L, (long)3L);
        Assertions.assertTrue((boolean)months.isDateBased());
        Assertions.assertTrue((boolean)days.isDateBased());
        Assertions.assertFalse((boolean)all.isDateBased());
        Assertions.assertFalse((boolean)time.isDateBased());
        Assertions.assertEquals((Object)Period.of(0, 1, 0), (Object)months.toPeriod());
        Assertions.assertEquals((Object)Period.of(0, 0, 2), (Object)days.toPeriod());
        Assertions.assertThrows(DateTimeException.class, () -> ((TimePeriod)all).toPeriod());
        Assertions.assertThrows(DateTimeException.class, () -> ((TimePeriod)time).toPeriod());
        Assertions.assertThrows(DateTimeException.class, () -> TimePeriod.of((long)0L, (long)0xFFFFFFFEL, (long)0L).toPeriod());
        Assertions.assertFalse((boolean)months.isTimeBased());
        Assertions.assertFalse((boolean)days.isTimeBased());
        Assertions.assertFalse((boolean)all.isTimeBased());
        Assertions.assertTrue((boolean)time.isTimeBased());
        Assertions.assertThrows(DateTimeException.class, () -> ((TimePeriod)months).toDuration());
        Assertions.assertEquals((Object)Duration.ofSeconds(172800L), (Object)days.toDuration());
        Assertions.assertThrows(DateTimeException.class, () -> ((TimePeriod)all).toDuration());
        Assertions.assertEquals((Object)Duration.ofMillis(3L), (Object)time.toDuration());
    }

    @Test
    void checkAddingToTemporalItems() {
        TimePeriod monthAndTwoDays = TimePeriod.of((long)1L, (long)2L, (long)0L);
        TimePeriod threeMillis = TimePeriod.of((long)0L, (long)0L, (long)3L);
        TimePeriod complexTimePeriod = TimePeriod.of((long)1L, (long)2L, (long)3L);
        LocalDateTime localDateTime = LocalDateTime.of(2001, 2, 3, 4, 5, 6, 7000000);
        LocalDate localDate = LocalDate.of(2001, 2, 3);
        LocalTime localTime = LocalTime.of(4, 5, 6, 7000000);
        Assertions.assertEquals((Object)localDateTime.plusMonths(1L).plusDays(2L), (Object)localDateTime.plus((TemporalAmount)monthAndTwoDays));
        Assertions.assertEquals((Object)localDateTime.plus(3L, ChronoUnit.MILLIS), (Object)localDateTime.plus((TemporalAmount)threeMillis));
        Assertions.assertEquals((Object)localDateTime.plusMonths(1L).plusDays(2L).plus(3L, ChronoUnit.MILLIS), (Object)localDateTime.plus((TemporalAmount)complexTimePeriod));
        Assertions.assertEquals((Object)localDate.plusMonths(1L).plusDays(2L), (Object)localDate.plus((TemporalAmount)monthAndTwoDays));
        Assertions.assertEquals((Object)localTime.plus(3L, ChronoUnit.MILLIS), (Object)localTime.plus((TemporalAmount)threeMillis));
        Assertions.assertEquals((Object)localDateTime.minusMonths(1L).minusDays(2L), (Object)localDateTime.minus((TemporalAmount)monthAndTwoDays));
        Assertions.assertEquals((Object)localDateTime.minus(3L, ChronoUnit.MILLIS), (Object)localDateTime.minus((TemporalAmount)threeMillis));
        Assertions.assertEquals((Object)localDateTime.minusMonths(1L).minusDays(2L).minus(3L, ChronoUnit.MILLIS), (Object)localDateTime.minus((TemporalAmount)complexTimePeriod));
        Assertions.assertEquals((Object)localDate.minusMonths(1L).minusDays(2L), (Object)localDate.minus((TemporalAmount)monthAndTwoDays));
        Assertions.assertEquals((Object)localTime.minus(3L, ChronoUnit.MILLIS), (Object)localTime.minus((TemporalAmount)threeMillis));
    }

    @Test
    void checkEqualityTests() {
        TimePeriod timePeriod1a = TimePeriod.of((long)1L, (long)2L, (long)3L);
        TimePeriod timePeriod1b = TimePeriod.of((long)1L, (long)2L, (long)3L);
        TimePeriod timePeriod2 = TimePeriod.of((long)9L, (long)9L, (long)9L);
        TimePeriod timePeriod3 = TimePeriod.of((long)1L, (long)9L, (long)9L);
        TimePeriod timePeriod4 = TimePeriod.of((long)1L, (long)2L, (long)9L);
        Assertions.assertEquals((Object)timePeriod1a, (Object)timePeriod1a);
        Assertions.assertEquals((Object)timePeriod1a, (Object)timePeriod1b);
        Assertions.assertEquals((int)timePeriod1a.hashCode(), (int)timePeriod1b.hashCode());
        Assertions.assertNotEquals((Object)timePeriod1a, null);
        Assertions.assertNotEquals((Object)timePeriod1a, (Object)"not equal");
        Assertions.assertNotEquals((Object)timePeriod1a, (Object)timePeriod2);
        Assertions.assertNotEquals((int)timePeriod1a.hashCode(), (int)timePeriod2.hashCode());
        Assertions.assertNotEquals((Object)timePeriod1a, (Object)timePeriod3);
        Assertions.assertNotEquals((int)timePeriod1a.hashCode(), (int)timePeriod3.hashCode());
        Assertions.assertNotEquals((Object)timePeriod1a, (Object)timePeriod4);
        Assertions.assertNotEquals((int)timePeriod1a.hashCode(), (int)timePeriod4.hashCode());
    }

    @Test
    void checkStringRepresentation() {
        Assertions.assertEquals((Object)"P0", (Object)TimePeriod.of((long)0L, (long)0L, (long)0L).toString());
        Assertions.assertEquals((Object)"P1Y", (Object)TimePeriod.of((long)12L, (long)0L, (long)0L).toString());
        Assertions.assertEquals((Object)"P2M", (Object)TimePeriod.of((long)2L, (long)0L, (long)0L).toString());
        Assertions.assertEquals((Object)"P3", (Object)TimePeriod.of((long)0L, (long)3L, (long)0L).toString());
        Assertions.assertEquals((Object)"P1Y2M3", (Object)TimePeriod.of((long)14L, (long)3L, (long)0L).toString());
        Assertions.assertEquals((Object)"PT04", (Object)TimePeriod.of((long)0L, (long)0L, (long)14400000L).toString());
        Assertions.assertEquals((Object)"PT00:05", (Object)TimePeriod.of((long)0L, (long)0L, (long)300000L).toString());
        Assertions.assertEquals((Object)"PT00:00:06", (Object)TimePeriod.of((long)0L, (long)0L, (long)6000L).toString());
        Assertions.assertEquals((Object)"PT00:00:00.007", (Object)TimePeriod.of((long)0L, (long)0L, (long)7L).toString());
        Assertions.assertEquals((Object)"P1Y2M3T04:05:06.007", (Object)TimePeriod.of((long)14L, (long)3L, (long)14706007L).toString());
        Assertions.assertEquals((Object)"P123T1193:02:47.295", (Object)TimePeriod.of((long)0L, (long)123L, (long)0xFFFFFFFFL).toString());
    }

    private void assertComponents(long months, long days, long millis, TimePeriod timePeriod) {
        ArrayList<ChronoUnit> expectedUnits = new ArrayList<ChronoUnit>(Arrays.asList(ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.MILLIS));
        if (months == 0L) {
            expectedUnits.remove(ChronoUnit.MONTHS);
        }
        if (days == 0L) {
            expectedUnits.remove(ChronoUnit.DAYS);
        }
        if (millis == 0L) {
            expectedUnits.remove(ChronoUnit.MILLIS);
        }
        Assertions.assertEquals(expectedUnits, (Object)timePeriod.getUnits());
        Assertions.assertEquals((long)months, (long)timePeriod.getMonths());
        Assertions.assertEquals((long)months, (long)timePeriod.get((TemporalUnit)ChronoUnit.MONTHS));
        Assertions.assertEquals((long)days, (long)timePeriod.getDays());
        Assertions.assertEquals((long)days, (long)timePeriod.get((TemporalUnit)ChronoUnit.DAYS));
        Assertions.assertEquals((long)millis, (long)timePeriod.getMillis());
        Assertions.assertEquals((long)millis, (long)timePeriod.get((TemporalUnit)ChronoUnit.MILLIS));
    }

    private static class TimeAmount
    implements TemporalAmount {
        private final Map<TemporalUnit, Long> amountsPerUnit = new LinkedHashMap<TemporalUnit, Long>();

        private TimeAmount() {
        }

        static TimeAmount of(TemporalUnit unit, long amount) {
            return new TimeAmount().with(unit, amount);
        }

        TimeAmount with(TemporalUnit unit, long amount) {
            this.amountsPerUnit.put(unit, amount);
            return this;
        }

        @Override
        public long get(TemporalUnit unit) {
            return this.amountsPerUnit.get(unit);
        }

        @Override
        public List<TemporalUnit> getUnits() {
            return new ArrayList<TemporalUnit>(this.amountsPerUnit.keySet());
        }

        @Override
        public Temporal addTo(Temporal temporal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Temporal subtractFrom(Temporal temporal) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DummyUnit
    implements TemporalUnit {
        private static final DummyUnit INSTANCE = new DummyUnit();

        private DummyUnit() {
        }

        @Override
        public Duration getDuration() {
            return null;
        }

        @Override
        public boolean isDurationEstimated() {
            return false;
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public <R extends Temporal> R addTo(R temporal, long amount) {
            return null;
        }

        @Override
        public long between(Temporal temporal1Inclusive, Temporal temporal2Exclusive) {
            return 0L;
        }
    }
}

