/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.RandomData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRandomData {
    private long seed;
    private int count;
    private File file;
    private GenericData genericData;
    private SpecificData specificData;
    private Schema specificSchema;
    private ReflectData reflectData;
    private Schema reflectedSchema;
    public static final String TEST_SCHEMA_JSON = "{\"type\":\"record\",\"name\":\"Record\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}";
    public static final Schema TEST_SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Record\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}");

    @Before
    public void setUp() throws Exception {
        this.file = Files.createTempFile("randomData", ".avro", new FileAttribute[0]).toFile();
        this.seed = System.currentTimeMillis();
        this.count = new Random().nextInt(50) + 75;
        this.genericData = GenericData.get();
        this.specificData = SpecificData.get();
        this.specificSchema = this.specificData.getSchema(SpecificTestRecord.class);
        this.reflectData = ReflectData.get();
        this.reflectedSchema = this.reflectData.getSchema(ReflectTestRecord.class);
    }

    @Test
    public void testRandomDataFromGenericToGeneric() throws IOException {
        this.checkWrite(this.genericData, TEST_SCHEMA);
        this.checkRead(this.genericData, TEST_SCHEMA);
    }

    @Test
    public void testRandomDataFromGenericToSpecific() throws IOException {
        this.checkWrite(this.genericData, TEST_SCHEMA);
        this.checkRead((GenericData)this.specificData, this.specificSchema);
    }

    @Test
    public void testRandomDataFromGenericToReflected() throws IOException {
        this.checkWrite(this.genericData, TEST_SCHEMA);
        this.checkRead((GenericData)this.reflectData, this.reflectedSchema);
    }

    @Test
    public void testRandomDataFromSpecificToGeneric() throws IOException {
        this.checkWrite((GenericData)this.specificData, this.specificSchema);
        this.checkRead(this.genericData, TEST_SCHEMA);
    }

    @Test
    public void testRandomDataFromSpecificToSpecific() throws IOException {
        this.checkWrite((GenericData)this.specificData, this.specificSchema);
        this.checkRead((GenericData)this.specificData, this.specificSchema);
    }

    @Test
    public void testRandomDataFromSpecificToReflected() throws IOException {
        this.checkWrite((GenericData)this.specificData, this.specificSchema);
        this.checkRead((GenericData)this.reflectData, this.reflectedSchema);
    }

    @Test
    public void testRandomDataFromReflectedToGeneric() throws IOException {
        this.checkWrite((GenericData)this.reflectData, this.reflectedSchema);
        this.checkRead(this.genericData, TEST_SCHEMA);
    }

    @Test
    public void testRandomDataFromReflectedToSpecific() throws IOException {
        this.checkWrite((GenericData)this.reflectData, this.reflectedSchema);
        this.checkRead((GenericData)this.specificData, this.specificSchema);
    }

    @Test
    public void testRandomDataFromReflectedToReflected() throws IOException {
        this.checkWrite((GenericData)this.reflectData, this.reflectedSchema);
        this.checkRead((GenericData)this.reflectData, this.reflectedSchema);
    }

    private void checkWrite(GenericData genericData, Schema schema) throws IOException {
        try (DataFileWriter writer = new DataFileWriter(genericData.createDatumWriter(schema));){
            writer.create(schema, this.file);
            for (Object datum : new RandomData(genericData, schema, this.count, this.seed)) {
                writer.append(datum);
            }
        }
    }

    private void checkRead(GenericData genericData, Schema schema) throws IOException {
        try (DataFileReader reader = new DataFileReader(this.file, genericData.createDatumReader(schema));){
            for (Object expected : new RandomData(genericData, schema, this.count, this.seed)) {
                Assert.assertEquals(expected, (Object)reader.next());
            }
        }
    }

    public static class SpecificTestRecord
    extends SpecificRecordBase {
        public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Record\",\"fields\":[{\"name\":\"x\",\"type\":\"int\"},{\"name\":\"y\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]}".replace("\"name\":\"Record\"", "\"name\":\"" + SpecificTestRecord.class.getCanonicalName() + "\""));
        private int x;
        private String y;

        public Schema getSchema() {
            return SCHEMA$;
        }

        public void put(int i, Object v) {
            switch (i) {
                case 0: {
                    this.x = (Integer)v;
                    break;
                }
                case 1: {
                    this.y = (String)v;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }

        public Object get(int i) {
            switch (i) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
            }
            throw new RuntimeException();
        }
    }

    public static class ReflectTestRecord {
        private int x;
        private String y;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public String getY() {
            return this.y;
        }

        public void setY(String y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReflectTestRecord that = (ReflectTestRecord)o;
            return this.x == that.x && Objects.equals(this.y, that.y);
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }

        public String toString() {
            return String.format("{\"x\": %d, \"y\": \"%s\"}", this.x, this.y);
        }
    }
}

