/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.TestUnionRecord;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class TestSpecificRecordWithUnion {
    @Test
    void unionLogicalDecimalConversion() throws IOException {
        TestUnionRecord record = TestUnionRecord.newBuilder().setAmount(BigDecimal.ZERO).build();
        Schema schema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().type(record.getSchema())).endUnion();
        byte[] recordBytes = TestSpecificRecordWithUnion.serializeRecord("{ \"org.apache.avro.specific.TestUnionRecord\": { \"amount\": { \"bytes\": \"\\u0000\" } } }", schema);
        SpecificDatumReader specificDatumReader = new SpecificDatumReader(schema);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordBytes);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)byteArrayInputStream, null);
        SpecificRecord deserialized = (SpecificRecord)specificDatumReader.read(null, (Decoder)decoder);
        Assert.assertEquals((Object)((Object)record), (Object)deserialized);
    }

    public static byte[] serializeRecord(String value, Schema schema) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(schema);
        Object object = reader.read(null, (Decoder)DecoderFactory.get().jsonDecoder(schema, value));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        writer.write(object, (Encoder)encoder);
        encoder.flush();
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }
}

