/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReflectDatumReader {
    private static <T> byte[] serializeWithReflectDatumWriter(T toSerialize, Class<T> toSerializeClass) throws IOException {
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(toSerializeClass);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        datumWriter.write(toSerialize, (Encoder)encoder);
        encoder.flush();
        return byteArrayOutputStream.toByteArray();
    }

    @Test
    void read_PojoWithList() throws IOException {
        PojoWithList pojoWithList = new PojoWithList();
        pojoWithList.setId(42);
        pojoWithList.setRelatedIds(Arrays.asList(1, 2, 3));
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(pojoWithList, PojoWithList.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(PojoWithList.class);
        PojoWithList deserialized = new PojoWithList();
        reflectDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)pojoWithList, (Object)deserialized);
    }

    @Test
    void read_PojoWithArray() throws IOException {
        PojoWithArray pojoWithArray = new PojoWithArray();
        pojoWithArray.setId(42);
        pojoWithArray.setRelatedIds(new int[]{1, 2, 3});
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(pojoWithArray, PojoWithArray.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(PojoWithArray.class);
        PojoWithArray deserialized = new PojoWithArray();
        reflectDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)pojoWithArray, (Object)deserialized);
    }

    @Test
    public void testRead_PojoWithSet() throws IOException {
        PojoWithSet pojoWithSet = new PojoWithSet();
        pojoWithSet.setId(42);
        HashSet<Integer> relatedIds = new HashSet<Integer>();
        relatedIds.add(1);
        relatedIds.add(2);
        relatedIds.add(3);
        pojoWithSet.setRelatedIds(relatedIds);
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(pojoWithSet, PojoWithSet.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(PojoWithSet.class);
        PojoWithSet deserialized = new PojoWithSet();
        reflectDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)pojoWithSet, (Object)deserialized);
    }

    @Test
    public void testRead_PojoWithMap() throws IOException {
        PojoWithMap pojoWithMap = new PojoWithMap();
        pojoWithMap.setId(42);
        HashMap<Integer, Integer> relatedIds = new HashMap<Integer, Integer>();
        relatedIds.put(1, 11);
        relatedIds.put(2, 22);
        relatedIds.put(3, 33);
        pojoWithMap.setRelatedIds(relatedIds);
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(pojoWithMap, PojoWithMap.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(PojoWithMap.class);
        PojoWithMap deserialized = new PojoWithMap();
        reflectDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)pojoWithMap, (Object)deserialized);
    }

    @Test
    public void testRead_PojoWithOptional() throws IOException {
        PojoWithOptional pojoWithOptional = new PojoWithOptional();
        pojoWithOptional.setId(42);
        pojoWithOptional.setRelatedId(Optional.of(13));
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(pojoWithOptional, PojoWithOptional.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(PojoWithOptional.class);
        PojoWithOptional deserialized = new PojoWithOptional();
        reflectDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)pojoWithOptional, (Object)deserialized);
    }

    @Test
    public void testRead_PojoWithEmptyOptional() throws IOException {
        PojoWithOptional pojoWithOptional = new PojoWithOptional();
        pojoWithOptional.setId(42);
        pojoWithOptional.setRelatedId(Optional.empty());
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(pojoWithOptional, PojoWithOptional.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(PojoWithOptional.class);
        PojoWithOptional deserialized = new PojoWithOptional();
        reflectDatumReader.read((Object)deserialized, (Decoder)decoder);
        Assertions.assertEquals((Object)pojoWithOptional, (Object)deserialized);
    }

    @Test
    public void testRead_PojoWithNullableAnnotation() throws IOException {
        PojoWithBasicTypeNullableAnnotationV1 v1Pojo = new PojoWithBasicTypeNullableAnnotationV1();
        int idValue = 1;
        v1Pojo.setId(idValue);
        byte[] serializedBytes = TestReflectDatumReader.serializeWithReflectDatumWriter(v1Pojo, PojoWithBasicTypeNullableAnnotationV1.class);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(serializedBytes, null);
        ReflectData reflectData = ReflectData.get();
        Schema schemaV1 = reflectData.getSchema(PojoWithBasicTypeNullableAnnotationV1.class);
        Schema schemaV2 = reflectData.getSchema(PojoWithBasicTypeNullableAnnotationV2.class);
        ReflectDatumReader reflectDatumReader = new ReflectDatumReader(schemaV1, schemaV2);
        PojoWithBasicTypeNullableAnnotationV2 v2Pojo = new PojoWithBasicTypeNullableAnnotationV2();
        reflectDatumReader.read((Object)v2Pojo, (Decoder)decoder);
        Assertions.assertEquals((int)v1Pojo.id, (int)v2Pojo.id);
        Assertions.assertEquals((int)v2Pojo.id, (int)idValue);
        Assertions.assertEquals((int)v2Pojo.intId, (int)0);
        Assertions.assertEquals((float)v2Pojo.floatId, (float)0.0f);
        Assertions.assertEquals((short)v2Pojo.shortId, (short)0);
        Assertions.assertEquals((byte)v2Pojo.byteId, (byte)0);
        Assertions.assertEquals((Object)v2Pojo.booleanId, (Object)false);
        Assertions.assertEquals((char)v2Pojo.charId, (char)'\u0000');
        Assertions.assertEquals((long)v2Pojo.longId, (long)0L);
        Assertions.assertEquals((double)v2Pojo.doubleId, (double)0.0);
    }

    public static class PojoWithList {
        private int id;
        private List<Integer> relatedIds;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public List<Integer> getRelatedIds() {
            return this.relatedIds;
        }

        public void setRelatedIds(List<Integer> relatedIds) {
            this.relatedIds = relatedIds;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.relatedIds == null ? 0 : this.relatedIds.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoWithList other = (PojoWithList)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.relatedIds == null) {
                return other.relatedIds == null;
            }
            return this.relatedIds.equals(other.relatedIds);
        }
    }

    public static class PojoWithArray {
        private int id;
        private int[] relatedIds;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int[] getRelatedIds() {
            return this.relatedIds;
        }

        public void setRelatedIds(int[] relatedIds) {
            this.relatedIds = relatedIds;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + Arrays.hashCode(this.relatedIds);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoWithArray other = (PojoWithArray)obj;
            if (this.id != other.id) {
                return false;
            }
            return Arrays.equals(this.relatedIds, other.relatedIds);
        }
    }

    public static class PojoWithSet {
        private int id;
        private Set<Integer> relatedIds;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public Set<Integer> getRelatedIds() {
            return this.relatedIds;
        }

        public void setRelatedIds(Set<Integer> relatedIds) {
            this.relatedIds = relatedIds;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.relatedIds == null ? 0 : this.relatedIds.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoWithSet other = (PojoWithSet)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.relatedIds == null) {
                return other.relatedIds == null;
            }
            return this.relatedIds.equals(other.relatedIds);
        }
    }

    public static class PojoWithMap {
        private int id;
        private Map<Integer, Integer> relatedIds;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public Map<Integer, Integer> getRelatedIds() {
            return this.relatedIds;
        }

        public void setRelatedIds(Map<Integer, Integer> relatedIds) {
            this.relatedIds = relatedIds;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.relatedIds == null ? 0 : this.relatedIds.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoWithMap other = (PojoWithMap)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.relatedIds == null) {
                return other.relatedIds == null;
            }
            return this.relatedIds.equals(other.relatedIds);
        }
    }

    public static class PojoWithOptional {
        private int id;
        private Optional<Integer> relatedId;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public Optional<Integer> getRelatedId() {
            return this.relatedId;
        }

        public void setRelatedId(Optional<Integer> relatedId) {
            this.relatedId = relatedId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + (this.relatedId == null ? 0 : this.relatedId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoWithOptional other = (PojoWithOptional)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.relatedId == null) {
                return other.relatedId == null;
            }
            return this.relatedId.equals(other.relatedId);
        }
    }

    public static class PojoWithBasicTypeNullableAnnotationV1 {
        private int id;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PojoWithBasicTypeNullableAnnotationV1 other = (PojoWithBasicTypeNullableAnnotationV1)obj;
            return this.id == other.id;
        }
    }

    public static class PojoWithBasicTypeNullableAnnotationV2 {
        private int id;
        @Nullable
        private int intId;
        @Nullable
        private float floatId;
        @Nullable
        private short shortId;
        @Nullable
        private byte byteId;
        @Nullable
        private boolean booleanId;
        @Nullable
        private char charId;
        @Nullable
        private long longId;
        @Nullable
        private double doubleId;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getIntId() {
            return this.intId;
        }

        public void setIntId(int intId) {
            this.intId = intId;
        }

        public float getFloatId() {
            return this.floatId;
        }

        public void setFloatId(float floatId) {
            this.floatId = floatId;
        }

        public short getShortId() {
            return this.shortId;
        }

        public void setShortId(short shortId) {
            this.shortId = shortId;
        }

        public byte getByteId() {
            return this.byteId;
        }

        public void setByteId(byte byteId) {
            this.byteId = byteId;
        }

        public boolean isBooleanId() {
            return this.booleanId;
        }

        public void setBooleanId(boolean booleanId) {
            this.booleanId = booleanId;
        }

        public char getCharId() {
            return this.charId;
        }

        public void setCharId(char charId) {
            this.charId = charId;
        }

        public long getLongId() {
            return this.longId;
        }

        public void setLongId(long longId) {
            this.longId = longId;
        }

        public double getDoubleId() {
            return this.doubleId;
        }

        public void setDoubleId(double doubleId) {
            this.doubleId = doubleId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + this.intId;
            result = 31 * result + (this.floatId != 0.0f ? Float.floatToIntBits(this.floatId) : 0);
            result = 31 * result + this.shortId;
            result = 31 * result + this.byteId;
            result = 31 * result + (this.booleanId ? 1 : 0);
            result = 31 * result + this.charId;
            result = 31 * result + (int)(this.longId ^ this.longId >>> 32);
            long temp = Double.doubleToLongBits(this.doubleId);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoWithBasicTypeNullableAnnotationV2 that = (PojoWithBasicTypeNullableAnnotationV2)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.intId != that.intId) {
                return false;
            }
            if (Float.compare(that.floatId, this.floatId) != 0) {
                return false;
            }
            if (this.shortId != that.shortId) {
                return false;
            }
            if (this.byteId != that.byteId) {
                return false;
            }
            if (this.booleanId != that.booleanId) {
                return false;
            }
            if (this.charId != that.charId) {
                return false;
            }
            if (this.longId != that.longId) {
                return false;
            }
            return Double.compare(that.doubleId, this.doubleId) == 0;
        }
    }
}

