/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.message.BadHeaderException;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.MissingSchemaException;
import org.apache.avro.message.SchemaStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBinaryMessageEncoding {
    private static final Schema SCHEMA_V1 = (Schema)SchemaBuilder.record((String)"TestRecord").fields().requiredInt("id").optionalString("msg").endRecord();
    private static final GenericRecordBuilder V1_BUILDER = new GenericRecordBuilder(SCHEMA_V1);
    private static final List<GenericData.Record> V1_RECORDS = Arrays.asList(V1_BUILDER.set("id", (Object)1).set("msg", (Object)"m-1").build(), V1_BUILDER.set("id", (Object)2).set("msg", (Object)"m-2").build(), V1_BUILDER.set("id", (Object)4).set("msg", (Object)"m-4").build(), V1_BUILDER.set("id", (Object)6).set("msg", (Object)"m-6").build());
    private static final Schema SCHEMA_V2 = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldBuilder)SchemaBuilder.record((String)"TestRecord").fields().requiredLong("id").name("message").aliases(new String[]{"msg"})).type().optional().stringType()).optionalDouble("data").endRecord();
    private static final GenericRecordBuilder V2_BUILDER = new GenericRecordBuilder(SCHEMA_V2);
    private static final List<GenericData.Record> V2_RECORDS = Arrays.asList(V2_BUILDER.set("id", (Object)3L).set("message", (Object)"m-3").set("data", (Object)12.3).build(), V2_BUILDER.set("id", (Object)5L).set("message", (Object)"m-5").set("data", (Object)23.4).build(), V2_BUILDER.set("id", (Object)7L).set("message", (Object)"m-7").set("data", (Object)34.5).build(), V2_BUILDER.set("id", (Object)8L).set("message", (Object)"m-8").set("data", (Object)35.6).build());

    @Test
    void byteBufferRoundTrip() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        GenericData.Record copy = (GenericData.Record)decoder.decode(encoder.encode((Object)V2_RECORDS.get(0)));
        Assertions.assertNotSame((Object)copy, (Object)V2_RECORDS.get(0), (String)"Copy should not be the same object");
        Assertions.assertEquals((Object)V2_RECORDS.get(0), (Object)copy, (String)"Record should be identical after round-trip");
    }

    @Test
    void schemaEvolution() throws Exception {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        ArrayList<GenericData.Record> records = new ArrayList<GenericData.Record>();
        records.addAll(V1_RECORDS);
        records.addAll(V2_RECORDS);
        BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        BinaryMessageEncoder v2Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
        for (GenericData.Record record : records) {
            if (record.getSchema().equals((Object)SCHEMA_V1)) {
                buffers.add(v1Encoder.encode((Object)record));
                continue;
            }
            buffers.add(v2Encoder.encode((Object)record));
        }
        HashSet<GenericData.Record> allAsV2 = new HashSet<GenericData.Record>(V2_RECORDS);
        allAsV2.add(V2_BUILDER.set("id", (Object)1L).set("message", (Object)"m-1").clear("data").build());
        allAsV2.add(V2_BUILDER.set("id", (Object)2L).set("message", (Object)"m-2").clear("data").build());
        allAsV2.add(V2_BUILDER.set("id", (Object)4L).set("message", (Object)"m-4").clear("data").build());
        allAsV2.add(V2_BUILDER.set("id", (Object)6L).set("message", (Object)"m-6").clear("data").build());
        BinaryMessageDecoder v2Decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        v2Decoder.addSchema(SCHEMA_V1);
        HashSet<GenericData.Record> decodedUsingV2 = new HashSet<GenericData.Record>();
        for (ByteBuffer buffer : buffers) {
            decodedUsingV2.add((GenericData.Record)v2Decoder.decode(buffer));
        }
        Assertions.assertEquals(allAsV2, decodedUsingV2);
    }

    @Test
    void compatibleReadFailsWithoutSchema() throws Exception {
        Assertions.assertThrows(MissingSchemaException.class, () -> {
            BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
            BinaryMessageDecoder v2Decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
            ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(3));
            v2Decoder.decode(v1Buffer);
        });
    }

    @Test
    void compatibleReadWithSchema() throws Exception {
        BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        BinaryMessageDecoder v2Decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
        v2Decoder.addSchema(SCHEMA_V1);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(3));
        GenericData.Record record = (GenericData.Record)v2Decoder.decode(v1Buffer);
        Assertions.assertEquals((Object)V2_BUILDER.set("id", (Object)6L).set("message", (Object)"m-6").clear("data").build(), (Object)record);
    }

    @Test
    void compatibleReadWithSchemaFromLookup() throws Exception {
        BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        SchemaStore.Cache schemaCache = new SchemaStore.Cache();
        schemaCache.addSchema(SCHEMA_V1);
        BinaryMessageDecoder v2Decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2, (SchemaStore)schemaCache);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(2));
        GenericData.Record record = (GenericData.Record)v2Decoder.decode(v1Buffer);
        Assertions.assertEquals((Object)V2_BUILDER.set("id", (Object)4L).set("message", (Object)"m-4").clear("data").build(), (Object)record);
    }

    @Test
    void identicalReadWithSchemaFromLookup() throws Exception {
        BinaryMessageEncoder v1Encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        SchemaStore.Cache schemaCache = new SchemaStore.Cache();
        schemaCache.addSchema(SCHEMA_V1);
        BinaryMessageDecoder genericDecoder = new BinaryMessageDecoder(GenericData.get(), null, (SchemaStore)schemaCache);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(2));
        GenericData.Record record = (GenericData.Record)genericDecoder.decode(v1Buffer);
        Assertions.assertEquals((Object)V1_RECORDS.get(2), (Object)record);
    }

    @Test
    void bufferReuse() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1, false);
        ByteBuffer b0 = encoder.encode((Object)V1_RECORDS.get(0));
        ByteBuffer b1 = encoder.encode((Object)V1_RECORDS.get(1));
        Assertions.assertEquals((Object)b0.array(), (Object)b1.array());
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V1);
        Assertions.assertEquals((Object)V1_RECORDS.get(1), (Object)decoder.decode(b0), (String)"Buffer was reused, decode(b0) should be record 1");
    }

    @Test
    void bufferCopy() throws Exception {
        BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V1);
        ByteBuffer b0 = encoder.encode((Object)V1_RECORDS.get(0));
        ByteBuffer b1 = encoder.encode((Object)V1_RECORDS.get(1));
        Assertions.assertNotEquals((Object)b0.array(), (Object)b1.array());
        BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V1);
        Assertions.assertEquals((Object)V1_RECORDS.get(0), (Object)decoder.decode(b0), (String)"Buffer was copied, decode(b0) should be record 0");
    }

    @Test
    void byteBufferMissingPayload() throws Exception {
        Assertions.assertThrows(AvroRuntimeException.class, () -> {
            BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
            BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
            ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
            buffer.limit(12);
            decoder.decode(buffer);
        });
    }

    @Test
    void byteBufferMissingFullHeader() throws Exception {
        Assertions.assertThrows(BadHeaderException.class, () -> {
            BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
            BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
            ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
            buffer.limit(8);
            decoder.decode(buffer);
        });
    }

    @Test
    void byteBufferBadMarkerByte() throws Exception {
        Assertions.assertThrows(BadHeaderException.class, () -> {
            BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
            BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
            ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
            buffer.array()[0] = 0;
            decoder.decode(buffer);
        });
    }

    @Test
    void byteBufferBadVersionByte() throws Exception {
        Assertions.assertThrows(BadHeaderException.class, () -> {
            BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
            BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
            ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
            buffer.array()[1] = 0;
            decoder.decode(buffer);
        });
    }

    @Test
    void byteBufferUnknownSchema() throws Exception {
        Assertions.assertThrows(MissingSchemaException.class, () -> {
            BinaryMessageEncoder encoder = new BinaryMessageEncoder(GenericData.get(), SCHEMA_V2);
            BinaryMessageDecoder decoder = new BinaryMessageDecoder(GenericData.get(), SCHEMA_V2);
            ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
            buffer.array()[4] = 0;
            decoder.decode(buffer);
        });
    }
}

