/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonDecoder {
    @Test
    void testInt() throws Exception {
        this.checkNumeric("int", 1);
    }

    @Test
    void testLong() throws Exception {
        this.checkNumeric("long", 1L);
    }

    @Test
    void testFloat() throws Exception {
        this.checkNumeric("float", Float.valueOf(1.0f));
    }

    @Test
    void testDouble() throws Exception {
        this.checkNumeric("double", 1.0);
    }

    private void checkNumeric(String type, Object value) throws Exception {
        String[] records;
        String def = "{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"type\":\"" + type + "\",\"name\":\"n\"}]}";
        Schema schema = new Schema.Parser().parse(def);
        GenericDatumReader reader = new GenericDatumReader(schema);
        for (String record : records = new String[]{"{\"n\":1}", "{\"n\":1.0}"}) {
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, record);
            GenericRecord r = (GenericRecord)reader.read(null, (Decoder)decoder);
            Assertions.assertEquals((Object)value, (Object)r.get("n"));
        }
    }

    @Test
    void testFloatPrecision() throws Exception {
        String def = "{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"type\":\"float\",\"name\":\"n\"}]}";
        Schema schema = new Schema.Parser().parse(def);
        GenericDatumReader reader = new GenericDatumReader(schema);
        float value = 33.33f;
        GenericData.Record record = new GenericData.Record(schema);
        record.put(0, (Object)Float.valueOf(value));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, (OutputStream)out);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        writer.write((Object)record, (Encoder)encoder);
        encoder.flush();
        Assertions.assertEquals((Object)"{\"n\":33.33000183105469}", (Object)out.toString());
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, out.toString());
        GenericRecord r = (GenericRecord)reader.read(null, (Decoder)decoder);
        Assertions.assertEquals((double)((double)value + 0.0), (double)((double)((Float)r.get("n")).floatValue() + 0.0));
    }

    @Test
    void reorderFields() throws Exception {
        String w = "{\"type\":\"record\",\"name\":\"R\",\"fields\":[{\"type\":\"long\",\"name\":\"l\"},{\"type\":{\"type\":\"array\",\"items\":\"int\"},\"name\":\"a\"}]}";
        Schema ws = new Schema.Parser().parse(w);
        DecoderFactory df = DecoderFactory.get();
        String data = "{\"a\":[1,2],\"l\":100}{\"l\": 200, \"a\":[1,2]}";
        JsonDecoder in = df.jsonDecoder(ws, data);
        Assertions.assertEquals((long)100L, (long)in.readLong());
        in.skipArray();
        Assertions.assertEquals((long)200L, (long)in.readLong());
        in.skipArray();
    }

    @Test
    void testIntWithError() throws IOException {
        Schema schema = (Schema)SchemaBuilder.builder((String)"test").record("example").fields().requiredInt("id").endRecord();
        String record = "{ \"id\": -1.2 }";
        GenericDatumReader reader = new GenericDatumReader(schema, schema);
        JsonDecoder decoder = DecoderFactory.get().jsonDecoder(schema, record);
        Assertions.assertThrows(AvroTypeException.class, () -> reader.read(null, (Decoder)decoder));
    }
}

