/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SystemLimitException;
import org.apache.avro.TestSystemLimitException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.DirectBinaryDecoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;
import org.apache.avro.util.RandomData;
import org.apache.avro.util.Utf8;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestBinaryDecoder {
    DecoderFactory factory = new DecoderFactory().configureDecoderBufferSize(521);
    static EncoderFactory e_factory = EncoderFactory.get();
    private static byte[] data = null;
    private static Schema schema = null;
    private static final int count = 200;
    private static final ArrayList<Object> records = new ArrayList(200);

    private Decoder newDecoderWithNoData(boolean useDirect) {
        return this.newDecoder(new byte[0], useDirect);
    }

    private BinaryDecoder newDecoder(byte[] bytes, int start, int len, boolean useDirect) {
        return this.newDecoder(bytes, start, len, null, useDirect);
    }

    private BinaryDecoder newDecoder(byte[] bytes, int start, int len, BinaryDecoder reuse, boolean useDirect) {
        if (useDirect) {
            ByteArrayInputStream input = new ByteArrayInputStream(bytes, start, len);
            return this.factory.directBinaryDecoder((InputStream)input, reuse);
        }
        return this.factory.binaryDecoder(bytes, start, len, reuse);
    }

    private BinaryDecoder newDecoder(InputStream in, boolean useDirect) {
        return this.newDecoder(in, null, useDirect);
    }

    private BinaryDecoder newDecoder(InputStream in, BinaryDecoder reuse, boolean useDirect) {
        if (useDirect) {
            return this.factory.directBinaryDecoder(in, reuse);
        }
        return this.factory.binaryDecoder(in, reuse);
    }

    private BinaryDecoder newDecoder(byte[] bytes, BinaryDecoder reuse, boolean useDirect) {
        if (useDirect) {
            return this.factory.directBinaryDecoder((InputStream)new ByteArrayInputStream(bytes), reuse);
        }
        return this.factory.binaryDecoder(bytes, reuse);
    }

    private BinaryDecoder newDecoder(byte[] bytes, boolean useDirect) {
        return this.newDecoder(bytes, null, useDirect);
    }

    private BinaryDecoder newDecoder(boolean useDirect, long ... values) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
            for (long v : values) {
                encoder.writeLong(v);
            }
            encoder.flush();
            BinaryDecoder binaryDecoder = this.newDecoder(baos.toByteArray(), useDirect);
            return binaryDecoder;
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofBoolean(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readBoolean());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofInt(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readInt());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofLong(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readLong());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofFloat(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readFloat());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofDouble(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readDouble());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofBytes(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readBytes(null));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofString(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readString(new Utf8("a")));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofFixed(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readFixed(new byte[1]));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eofEnum(boolean useDirect) {
        Assertions.assertThrows(EOFException.class, () -> this.newDecoderWithNoData(useDirect).readEnum());
    }

    @Test
    void reuse() throws IOException {
        ByteBufferOutputStream bbo1 = new ByteBufferOutputStream();
        ByteBufferOutputStream bbo2 = new ByteBufferOutputStream();
        byte[] b1 = new byte[]{1, 2};
        BinaryEncoder e1 = e_factory.binaryEncoder((OutputStream)bbo1, null);
        e1.writeBytes(b1);
        e1.flush();
        BinaryEncoder e2 = e_factory.binaryEncoder((OutputStream)bbo2, null);
        e2.writeBytes(b1);
        e2.flush();
        DirectBinaryDecoder d = new DirectBinaryDecoder((InputStream)new ByteBufferInputStream(bbo1.getBufferList()));
        ByteBuffer bb1 = d.readBytes(null);
        Assertions.assertEquals((int)b1.length, (int)(bb1.limit() - bb1.position()));
        d.configure((InputStream)new ByteBufferInputStream(bbo2.getBufferList()));
        ByteBuffer bb2 = d.readBytes(null);
        Assertions.assertEquals((int)b1.length, (int)(bb2.limit() - bb2.position()));
    }

    @BeforeAll
    public static void generateData() throws IOException {
        int seed = (int)System.currentTimeMillis();
        String jsonSchema = "{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"intField\", \"type\":\"int\"},{\"name\":\"bytesField\", \"type\":\"bytes\"},{\"name\":\"booleanField\", \"type\":\"boolean\"},{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"floatField\", \"type\":\"float\"},{\"name\":\"doubleField\", \"type\":\"double\"},{\"name\":\"arrayField\", \"type\": {\"type\":\"array\", \"items\":\"boolean\"}},{\"name\":\"longField\", \"type\":\"long\"}]}";
        schema = new Schema.Parser().parse(jsonSchema);
        GenericDatumWriter writer = new GenericDatumWriter();
        writer.setSchema(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        BinaryEncoder encoder = e_factory.binaryEncoder((OutputStream)baos, null);
        for (Object datum : new RandomData(schema, 200, (long)seed)) {
            writer.write(datum, (Encoder)encoder);
            records.add(datum);
        }
        encoder.flush();
        data = baos.toByteArray();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void decodeFromSources(boolean useDirect) throws IOException {
        GenericDatumReader reader = new GenericDatumReader();
        reader.setSchema(schema);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        ByteArrayInputStream is2 = new ByteArrayInputStream(data);
        ByteArrayInputStream is3 = new ByteArrayInputStream(data);
        BinaryDecoder fromInputStream = this.newDecoder(is, useDirect);
        BinaryDecoder fromArray = this.newDecoder(data, useDirect);
        byte[] data2 = new byte[data.length + 30];
        Arrays.fill(data2, (byte)-1);
        System.arraycopy(data, 0, data2, 15, data.length);
        BinaryDecoder fromOffsetArray = this.newDecoder(data2, 15, data.length, useDirect);
        BinaryDecoder initOnInputStream = this.newDecoder(new byte[50], 0, 30, useDirect);
        initOnInputStream = this.newDecoder(is2, initOnInputStream, useDirect);
        BinaryDecoder initOnArray = this.newDecoder(is3, null, useDirect);
        initOnArray = this.newDecoder(data, initOnArray, useDirect);
        for (Object datum : records) {
            Assertions.assertEquals((Object)datum, (Object)reader.read(null, (Decoder)fromInputStream), (String)"InputStream based BinaryDecoder result does not match");
            Assertions.assertEquals((Object)datum, (Object)reader.read(null, (Decoder)fromArray), (String)"Array based BinaryDecoder result does not match");
            Assertions.assertEquals((Object)datum, (Object)reader.read(null, (Decoder)fromOffsetArray), (String)"offset Array based BinaryDecoder result does not match");
            Assertions.assertEquals((Object)datum, (Object)reader.read(null, (Decoder)initOnInputStream), (String)"InputStream initialized BinaryDecoder result does not match");
            Assertions.assertEquals((Object)datum, (Object)reader.read(null, (Decoder)initOnArray), (String)"Array initialized BinaryDecoder result does not match");
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void inputStreamProxy(boolean useDirect) throws IOException {
        BinaryDecoder d = this.newDecoder(data, useDirect);
        if (d != null) {
            BinaryDecoder bd = d;
            InputStream test = bd.inputStream();
            ByteArrayInputStream check = new ByteArrayInputStream(data);
            this.validateInputStreamReads(test, check);
            bd = this.newDecoder(data, bd, useDirect);
            test = bd.inputStream();
            check = new ByteArrayInputStream(data);
            this.validateInputStreamSkips(test, check);
            bd = this.newDecoder(new ByteArrayInputStream(data), bd, useDirect);
            test = bd.inputStream();
            check = new ByteArrayInputStream(data);
            this.validateInputStreamReads(test, check);
            bd = this.newDecoder(new ByteArrayInputStream(data), bd, useDirect);
            test = bd.inputStream();
            check = new ByteArrayInputStream(data);
            this.validateInputStreamSkips(test, check);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void inputStreamProxyDetached(boolean useDirect) throws IOException {
        BinaryDecoder bd = this.newDecoder(data, useDirect);
        InputStream test = bd.inputStream();
        ByteArrayInputStream check = new ByteArrayInputStream(data);
        this.newDecoder(new byte[56], useDirect);
        try (InputStream bad = bd.inputStream();
             ByteArrayInputStream check2 = new ByteArrayInputStream(data);){
            this.validateInputStreamReads(test, check);
            Assertions.assertNotEquals((int)bad.read(), (int)((InputStream)check2).read());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void inputStreamPartiallyUsed(boolean useDirect) throws IOException {
        ByteArrayInputStream check;
        InputStream test;
        BinaryDecoder bd;
        block2: {
            bd = this.newDecoder(new ByteArrayInputStream(data), useDirect);
            test = bd.inputStream();
            check = new ByteArrayInputStream(data);
            try {
                Assertions.assertFalse((boolean)bd.isEnd());
            }
            catch (UnsupportedOperationException e) {
                if (bd.getClass() == DirectBinaryDecoder.class) break block2;
                throw e;
            }
        }
        bd.readFloat();
        ((InputStream)check).skip(4L);
        this.validateInputStreamReads(test, check);
    }

    private void validateInputStreamReads(InputStream test, InputStream check) throws IOException {
        int t;
        byte[] bt = new byte[7];
        byte[] bc = new byte[7];
        do {
            t = test.read();
            int c = check.read();
            Assertions.assertEquals((int)c, (int)t);
            if (-1 == t) break;
            t = test.read(bt);
            c = check.read(bc);
            Assertions.assertEquals((int)c, (int)t);
            Assertions.assertArrayEquals((byte[])bt, (byte[])bc);
            if (-1 == t) break;
            t = test.read(bt, 1, 4);
            c = check.read(bc, 1, 4);
            Assertions.assertEquals((int)c, (int)t);
            Assertions.assertArrayEquals((byte[])bt, (byte[])bc);
        } while (-1 != t);
        Assertions.assertEquals((long)0L, (long)test.skip(5L));
        Assertions.assertEquals((int)0, (int)test.available());
        Assertions.assertFalse((test.getClass() != ByteArrayInputStream.class && test.markSupported() ? 1 : 0) != 0);
        test.close();
    }

    private void validateInputStreamSkips(InputStream test, InputStream check) throws IOException {
        long t2;
        do {
            t2 = test.skip(19L);
            long c2 = check.skip(19L);
            Assertions.assertEquals((long)c2, (long)t2);
        } while (0L != t2);
        Assertions.assertEquals((int)-1, (int)test.read());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void badIntEncoding(boolean useDirect) throws IOException {
        byte[] badint = new byte[5];
        Arrays.fill(badint, (byte)-1);
        BinaryDecoder bd = this.newDecoder(badint, useDirect);
        String message = "";
        try {
            bd.readInt();
        }
        catch (IOException ioe) {
            message = ioe.getMessage();
        }
        Assertions.assertEquals((Object)"Invalid int encoding", (Object)message);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void badLongEncoding(boolean useDirect) throws IOException {
        byte[] badint = new byte[10];
        Arrays.fill(badint, (byte)-1);
        BinaryDecoder bd = this.newDecoder(badint, useDirect);
        String message = "";
        try {
            bd.readLong();
        }
        catch (IOException ioe) {
            message = ioe.getMessage();
        }
        Assertions.assertEquals((Object)"Invalid long encoding", (Object)message);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStringNegativeLength(boolean useDirect) throws IOException {
        Exception ex = (Exception)Assertions.assertThrows(AvroRuntimeException.class, () -> ((BinaryDecoder)this.newDecoder(useDirect, -1L)).readString());
        Assertions.assertEquals((Object)"Malformed data. Length is negative: -1", (Object)ex.getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStringVmMaxSize(boolean useDirect) throws IOException {
        Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> ((BinaryDecoder)this.newDecoder(useDirect, 0x7FFFFFF8L)).readString());
        Assertions.assertEquals((Object)"Cannot read strings longer than 2147483639 bytes", (Object)ex.getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStringMaxCustom(boolean useDirect) throws IOException {
        try {
            System.setProperty("org.apache.avro.limits.string.maxLength", Long.toString(128L));
            TestSystemLimitException.resetLimits();
            Exception ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> ((BinaryDecoder)this.newDecoder(useDirect, 129L)).readString());
            Assertions.assertEquals((Object)"String length 129 exceeds maximum allowed", (Object)ex.getMessage());
        }
        finally {
            System.clearProperty("org.apache.avro.limits.string.maxLength");
            TestSystemLimitException.resetLimits();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBytesNegativeLength(boolean useDirect) throws IOException {
        Exception ex = (Exception)Assertions.assertThrows(AvroRuntimeException.class, () -> this.newDecoder(useDirect, -1L).readBytes(null));
        Assertions.assertEquals((Object)"Malformed data. Length is negative: -1", (Object)ex.getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBytesVmMaxSize(boolean useDirect) throws IOException {
        Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.newDecoder(useDirect, 0x7FFFFFF8L).readBytes(null));
        Assertions.assertEquals((Object)"Cannot read arrays longer than 2147483639 bytes in Java library", (Object)ex.getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBytesMaxCustom(boolean useDirect) throws IOException {
        try {
            System.setProperty("org.apache.avro.limits.bytes.maxLength", Long.toString(128L));
            TestSystemLimitException.resetLimits();
            Exception ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> this.newDecoder(useDirect, 129L).readBytes(null));
            Assertions.assertEquals((Object)"Bytes length 129 exceeds maximum allowed", (Object)ex.getMessage());
        }
        finally {
            System.clearProperty("org.apache.avro.limits.bytes.maxLength");
            TestSystemLimitException.resetLimits();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArrayVmMaxSize(boolean useDirect) throws IOException {
        Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.newDecoder(useDirect, 0x7FFFFFF8L).readArrayStart());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.newDecoder(useDirect, 0x7FFFFFF8L).arrayNext());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
        BinaryDecoder bd = this.newDecoder(useDirect, 2147483539L, Long.MAX_VALUE);
        Assertions.assertEquals((long)2147483539L, (long)bd.readArrayStart());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> ((Decoder)bd).arrayNext());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
        bd = this.newDecoder(useDirect, 2147483539L, 100L, 1L);
        Assertions.assertEquals((long)2147483539L, (long)bd.readArrayStart());
        Assertions.assertEquals((long)100L, (long)bd.arrayNext());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> ((Decoder)bd).arrayNext());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
        bd = this.newDecoder(useDirect, -2147483539L, 999L, -100L, 999L, 1L);
        Assertions.assertEquals((long)2147483539L, (long)bd.readArrayStart());
        Assertions.assertEquals((long)100L, (long)bd.arrayNext());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> ((Decoder)bd).arrayNext());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArrayMaxCustom(boolean useDirect) throws IOException {
        try {
            System.setProperty("org.apache.avro.limits.collectionItems.maxLength", Long.toString(128L));
            TestSystemLimitException.resetLimits();
            Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.newDecoder(useDirect, 0x7FFFFFF8L).readArrayStart());
            Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
            BinaryDecoder bd = this.newDecoder(useDirect, 118L, 10L, 1L);
            Assertions.assertEquals((long)118L, (long)bd.readArrayStart());
            Assertions.assertEquals((long)10L, (long)bd.arrayNext());
            ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> ((Decoder)bd).arrayNext());
            Assertions.assertEquals((Object)"Collection length 129 exceeds maximum allowed", (Object)ex.getMessage());
            bd = this.newDecoder(useDirect, -118L, 999L, -10L, 999L, 1L);
            Assertions.assertEquals((long)118L, (long)bd.readArrayStart());
            Assertions.assertEquals((long)10L, (long)bd.arrayNext());
            ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> ((Decoder)bd).arrayNext());
            Assertions.assertEquals((Object)"Collection length 129 exceeds maximum allowed", (Object)ex.getMessage());
        }
        finally {
            System.clearProperty("org.apache.avro.limits.collectionItems.maxLength");
            TestSystemLimitException.resetLimits();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMapVmMaxSize(boolean useDirect) throws IOException {
        Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.newDecoder(useDirect, 0x7FFFFFF8L).readMapStart());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.newDecoder(useDirect, 0x7FFFFFF8L).mapNext());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
        BinaryDecoder bd = this.newDecoder(useDirect, 2147483539L, 100L, 1L);
        Assertions.assertEquals((long)2147483539L, (long)bd.readMapStart());
        Assertions.assertEquals((long)100L, (long)bd.mapNext());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> ((Decoder)bd).mapNext());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
        bd = this.newDecoder(useDirect, -2147483539L, 999L, -100L, 999L, 1L);
        Assertions.assertEquals((long)2147483539L, (long)bd.readMapStart());
        Assertions.assertEquals((long)100L, (long)bd.mapNext());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> ((Decoder)bd).mapNext());
        Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMapMaxCustom(boolean useDirect) throws IOException {
        try {
            System.setProperty("org.apache.avro.limits.collectionItems.maxLength", Long.toString(128L));
            TestSystemLimitException.resetLimits();
            Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.newDecoder(useDirect, 0x7FFFFFF8L).readMapStart());
            Assertions.assertEquals((Object)"Cannot read collections larger than 2147483639 items in Java library", (Object)ex.getMessage());
            BinaryDecoder bd = this.newDecoder(useDirect, 118L, 10L, 1L);
            Assertions.assertEquals((long)118L, (long)bd.readMapStart());
            Assertions.assertEquals((long)10L, (long)bd.mapNext());
            ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> ((Decoder)bd).mapNext());
            Assertions.assertEquals((Object)"Collection length 129 exceeds maximum allowed", (Object)ex.getMessage());
            bd = this.newDecoder(useDirect, -118L, 999L, -10L, 999L, 1L);
            Assertions.assertEquals((long)118L, (long)bd.readMapStart());
            Assertions.assertEquals((long)10L, (long)bd.mapNext());
            ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> ((Decoder)bd).mapNext());
            Assertions.assertEquals((Object)"Collection length 129 exceeds maximum allowed", (Object)ex.getMessage());
        }
        finally {
            System.clearProperty("org.apache.avro.limits.collectionItems.maxLength");
            TestSystemLimitException.resetLimits();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void longLengthEncoding(boolean useDirect) {
        byte[] bad = new byte[]{-128, -128, -128, -128, 16};
        BinaryDecoder bd = this.newDecoder(bad, useDirect);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((Decoder)bd).readString());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void intTooShort(boolean useDirect) {
        byte[] badint = new byte[4];
        Arrays.fill(badint, (byte)-1);
        Assertions.assertThrows(EOFException.class, () -> this.newDecoder(badint, useDirect).readInt());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void longTooShort(boolean useDirect) {
        byte[] badint = new byte[9];
        Arrays.fill(badint, (byte)-1);
        Assertions.assertThrows(EOFException.class, () -> this.newDecoder(badint, useDirect).readLong());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void floatTooShort(boolean useDirect) {
        byte[] badint = new byte[3];
        Arrays.fill(badint, (byte)-1);
        Assertions.assertThrows(EOFException.class, () -> this.newDecoder(badint, useDirect).readInt());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void doubleTooShort(boolean useDirect) {
        byte[] badint = new byte[7];
        Arrays.fill(badint, (byte)-1);
        Assertions.assertThrows(EOFException.class, () -> this.newDecoder(badint, useDirect).readLong());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void skipping(boolean useDirect) throws IOException {
        block5: {
            BinaryDecoder bd;
            block4: {
                bd = this.newDecoder(data, useDirect);
                this.skipGenerated((Decoder)bd);
                try {
                    Assertions.assertTrue((boolean)bd.isEnd());
                }
                catch (UnsupportedOperationException e) {
                    if (bd.getClass() == DirectBinaryDecoder.class) break block4;
                    throw e;
                }
            }
            bd = this.newDecoder(new ByteArrayInputStream(data), bd, useDirect);
            this.skipGenerated((Decoder)bd);
            try {
                Assertions.assertTrue((boolean)bd.isEnd());
            }
            catch (UnsupportedOperationException e) {
                if (bd.getClass() == DirectBinaryDecoder.class) break block5;
                throw e;
            }
        }
    }

    private void skipGenerated(Decoder bd) throws IOException {
        for (int i = 0; i < records.size(); ++i) {
            bd.readInt();
            bd.skipBytes();
            bd.skipFixed(1);
            bd.skipString();
            bd.skipFixed(4);
            bd.skipFixed(8);
            long leftover = bd.skipArray();
            bd.skipFixed((int)leftover + 1);
            bd.skipFixed(0);
            bd.skipFixed(-8);
            bd.readLong();
        }
        EOFException eof = null;
        try {
            bd.skipFixed(4);
        }
        catch (EOFException e) {
            eof = e;
        }
        Assertions.assertNotNull((Object)eof);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void eof(boolean useDirect) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
        e.writeLong(0x10000000000000L);
        e.flush();
        BinaryDecoder d = this.newDecoder(new ByteArrayInputStream(baos.toByteArray()), useDirect);
        Assertions.assertEquals((long)0x10000000000000L, (long)d.readLong());
        Assertions.assertThrows(EOFException.class, () -> TestBinaryDecoder.lambda$eof$22((Decoder)d));
    }

    @Test
    void testFloatPrecision() throws Exception {
        String def = "{\"type\":\"record\",\"name\":\"X\",\"fields\":[{\"type\":\"float\",\"name\":\"n\"}]}";
        Schema schema = new Schema.Parser().parse(def);
        GenericDatumReader reader = new GenericDatumReader(schema);
        float value = 33.33f;
        GenericData.Record record = new GenericData.Record(schema);
        record.put(0, (Object)Float.valueOf(value));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        writer.write((Object)record, (Encoder)encoder);
        encoder.flush();
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)new ByteArrayInputStream(out.toByteArray()), null);
        GenericRecord r = (GenericRecord)reader.read(null, (Decoder)decoder);
        Assertions.assertEquals((double)((double)value + 0.0), (double)((double)((Float)r.get("n")).floatValue() + 0.0));
    }

    private static /* synthetic */ void lambda$eof$22(Decoder d) throws Throwable {
        d.readInt();
    }
}

