/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.io;

import org.apache.avro.io.BinaryData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBinaryData {
    @Test
    void skipLong() {
        byte[] b = new byte[10];
        BinaryData.encodeLong((long)Long.MAX_VALUE, (byte[])b, (int)0);
        int nextIndex = BinaryData.skipLong((byte[])b, (int)0);
        Assertions.assertEquals((int)nextIndex, (int)10);
    }

    @Test
    void testIntLongVleEquality() {
        byte[] intResult = new byte[9];
        byte[] longResult = new byte[9];
        BinaryData.encodeInt((int)0, (byte[])intResult, (int)0);
        BinaryData.encodeLong((long)0L, (byte[])longResult, (int)0);
        Assertions.assertArrayEquals((byte[])intResult, (byte[])longResult);
        BinaryData.encodeInt((int)42, (byte[])intResult, (int)0);
        BinaryData.encodeLong((long)42L, (byte[])longResult, (int)0);
        Assertions.assertArrayEquals((byte[])intResult, (byte[])longResult);
        BinaryData.encodeInt((int)-24, (byte[])intResult, (int)0);
        BinaryData.encodeLong((long)-24L, (byte[])longResult, (int)0);
        Assertions.assertArrayEquals((byte[])intResult, (byte[])longResult);
        BinaryData.encodeInt((int)Integer.MAX_VALUE, (byte[])intResult, (int)0);
        BinaryData.encodeLong((long)Integer.MAX_VALUE, (byte[])longResult, (int)0);
        Assertions.assertArrayEquals((byte[])intResult, (byte[])longResult);
        BinaryData.encodeInt((int)Integer.MIN_VALUE, (byte[])intResult, (int)0);
        BinaryData.encodeLong((long)Integer.MIN_VALUE, (byte[])longResult, (int)0);
        Assertions.assertArrayEquals((byte[])intResult, (byte[])longResult);
    }
}

