/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.CustomType;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.util.TimePeriod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestGenericLogicalTypes {
    @TempDir
    public File temp;
    public static final GenericData GENERIC = new GenericData();

    @BeforeAll
    public static void addLogicalTypes() {
        GENERIC.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        GENERIC.addLogicalTypeConversion((Conversion)new Conversions.UUIDConversion());
        GENERIC.addLogicalTypeConversion((Conversion)new Conversions.DurationConversion());
        GENERIC.addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMicrosConversion());
        GENERIC.addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMillisConversion());
    }

    @Test
    public void readUUID() throws IOException {
        Schema uuidSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        LogicalTypes.uuid().addToSchema(uuidSchema);
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        List<UUID> expected = Arrays.asList(u1, u2);
        File test = this.write(Schema.create((Schema.Type)Schema.Type.STRING), u1.toString(), u2.toString());
        Assertions.assertEquals(expected, this.read(GENERIC.createDatumReader(uuidSchema), test), (String)"Should convert Strings to UUIDs");
    }

    @Test
    public void writeUUID() throws IOException {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        stringSchema.addProp("avro.java.string", "String");
        Schema uuidSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        LogicalTypes.uuid().addToSchema(uuidSchema);
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        List<String> expected = Arrays.asList(u1.toString(), u2.toString());
        File test = this.write(GENERIC, uuidSchema, u1, u2);
        Assertions.assertEquals(expected, this.read(GenericData.get().createDatumReader(stringSchema), test), (String)"Should read UUIDs as Strings");
    }

    @Test
    public void writeNullableUUID() throws IOException {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        stringSchema.addProp("avro.java.string", "String");
        Schema nullableStringSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), stringSchema});
        Schema uuidSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        LogicalTypes.uuid().addToSchema(uuidSchema);
        Schema nullableUuidSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), uuidSchema});
        UUID u1 = UUID.randomUUID();
        UUID u2 = UUID.randomUUID();
        List<String> expected = Arrays.asList(u1.toString(), u2.toString());
        File test = this.write(GENERIC, nullableUuidSchema, u1, u2);
        Assertions.assertEquals(expected, this.read(GenericData.get().createDatumReader(nullableStringSchema), test), (String)"Should read UUIDs as Strings");
    }

    @Test
    public void readWriteDuration() throws IOException {
        Schema fixedSchema = Schema.createFixed((String)"bare.Fixed", null, null, (int)12);
        Schema durationSchema = Schema.createFixed((String)"time.Duration", null, null, (int)12);
        LogicalTypes.duration().addToSchema(durationSchema);
        fixedSchema.addAlias(durationSchema.getFullName());
        durationSchema.addAlias(fixedSchema.getFullName());
        Random rng = new Random();
        TimePeriod d1 = TimePeriod.of((long)rng.nextInt(1000), (long)rng.nextInt(1000), (long)rng.nextInt(1000));
        ByteBuffer b1 = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN).putInt((int)d1.getMonths()).putInt((int)d1.getDays()).putInt((int)d1.getMillis());
        GenericData.Fixed f1 = new GenericData.Fixed(fixedSchema, b1.array());
        TimePeriod d2 = TimePeriod.of((long)rng.nextInt(1000), (long)rng.nextInt(1000), (long)rng.nextInt(1000));
        ByteBuffer b2 = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN).putInt((int)d2.getMonths()).putInt((int)d2.getDays()).putInt((int)d2.getMillis());
        GenericData.Fixed f2 = new GenericData.Fixed(fixedSchema, b2.array());
        File test = this.write(fixedSchema, f1, f2);
        Assertions.assertEquals(Arrays.asList(d1, d2), this.read(GENERIC.createDatumReader(durationSchema), test), (String)"Should convert fixed bytes to durations");
        test = this.write(GENERIC, durationSchema, d2, d1);
        Assertions.assertEquals(Arrays.asList(f2, f1), this.read(GenericData.get().createDatumReader(fixedSchema), test), (String)"Should convert durations to fixed bytes");
    }

    @Test
    public void readDecimalFixed() throws IOException {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema fixedSchema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        Schema decimalSchema = decimal.addToSchema(Schema.createFixed((String)"aFixed", null, null, (int)4));
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        List<BigDecimal> expected = Arrays.asList(d1, d2);
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericFixed d1fixed = conversion.toFixed((Object)d1, fixedSchema, (LogicalType)decimal);
        GenericFixed d2fixed = conversion.toFixed((Object)d2, fixedSchema, (LogicalType)decimal);
        File test = this.write(fixedSchema, d1fixed, d2fixed);
        Assertions.assertEquals(expected, this.read(GENERIC.createDatumReader(decimalSchema), test), (String)"Should convert fixed to BigDecimals");
    }

    @Test
    public void writeDecimalFixed() throws IOException {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema fixedSchema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        Schema decimalSchema = decimal.addToSchema(Schema.createFixed((String)"aFixed", null, null, (int)4));
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericFixed d1fixed = conversion.toFixed((Object)d1, fixedSchema, (LogicalType)decimal);
        GenericFixed d2fixed = conversion.toFixed((Object)d2, fixedSchema, (LogicalType)decimal);
        List<GenericFixed> expected = Arrays.asList(d1fixed, d2fixed);
        File test = this.write(GENERIC, decimalSchema, d1, d2);
        Assertions.assertEquals(expected, this.read(GenericData.get().createDatumReader(fixedSchema), test), (String)"Should read BigDecimals as fixed");
    }

    @Test
    public void decimalToFromBytes() {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        ByteBuffer d1bytes = conversion.toBytes((Object)d1, bytesSchema, (LogicalType)decimal);
        ByteBuffer d2bytes = conversion.toBytes((Object)d2, bytesSchema, (LogicalType)decimal);
        MatcherAssert.assertThat((Object)((BigDecimal)conversion.fromBytes(d1bytes, bytesSchema, (LogicalType)decimal)), (Matcher)Matchers.is((Object)d1));
        MatcherAssert.assertThat((Object)((BigDecimal)conversion.fromBytes(d2bytes, bytesSchema, (LogicalType)decimal)), (Matcher)Matchers.is((Object)d2));
        MatcherAssert.assertThat((String)"Ensure ByteBuffer not consumed by conversion", (Object)((BigDecimal)conversion.fromBytes(d1bytes, bytesSchema, (LogicalType)decimal)), (Matcher)Matchers.is((Object)d1));
    }

    @Test
    public void decimalToFromFixed() {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema fixedSchema = Schema.createFixed((String)"aFixed", null, null, (int)4);
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        GenericFixed d1fixed = conversion.toFixed((Object)d1, fixedSchema, (LogicalType)decimal);
        GenericFixed d2fixed = conversion.toFixed((Object)d2, fixedSchema, (LogicalType)decimal);
        MatcherAssert.assertThat((Object)((BigDecimal)conversion.fromFixed(d1fixed, fixedSchema, (LogicalType)decimal)), (Matcher)Matchers.is((Object)d1));
        MatcherAssert.assertThat((Object)((BigDecimal)conversion.fromFixed(d2fixed, fixedSchema, (LogicalType)decimal)), (Matcher)Matchers.is((Object)d2));
    }

    @Test
    public void readDecimalBytes() throws IOException {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        Schema decimalSchema = decimal.addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        List<BigDecimal> expected = Arrays.asList(d1, d2);
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        ByteBuffer d1bytes = conversion.toBytes((Object)d1, bytesSchema, (LogicalType)decimal);
        ByteBuffer d2bytes = conversion.toBytes((Object)d2, bytesSchema, (LogicalType)decimal);
        File test = this.write(bytesSchema, d1bytes, d2bytes);
        Assertions.assertEquals(expected, this.read(GENERIC.createDatumReader(decimalSchema), test), (String)"Should convert bytes to BigDecimals");
    }

    @Test
    public void writeDecimalBytes() throws IOException {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)9, (int)2);
        Schema bytesSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
        Schema decimalSchema = decimal.addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        BigDecimal d1 = new BigDecimal("-34.34");
        BigDecimal d2 = new BigDecimal("117230.00");
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        ByteBuffer d1bytes = conversion.toBytes((Object)d1, bytesSchema, (LogicalType)decimal);
        ByteBuffer d2bytes = conversion.toBytes((Object)d2, bytesSchema, (LogicalType)decimal);
        List<ByteBuffer> expected = Arrays.asList(d1bytes, d2bytes);
        File test = this.write(GENERIC, decimalSchema, d1bytes, d2bytes);
        Assertions.assertEquals(expected, this.read(GenericData.get().createDatumReader(bytesSchema), test), (String)"Should read BigDecimals as bytes");
    }

    private <D> List<D> read(DatumReader<D> reader, File file) throws IOException {
        ArrayList data = new ArrayList();
        try (DataFileReader fileReader = new DataFileReader(file, reader);){
            for (Object datum : fileReader) {
                data.add(datum);
            }
        }
        return data;
    }

    @SafeVarargs
    private final <D> File write(Schema schema, D ... data) throws IOException {
        return this.write(GenericData.get(), schema, data);
    }

    private <D> File write(GenericData model, Schema schema, D ... data) throws IOException {
        File file = new File(this.temp, "out.avro");
        DatumWriter writer = model.createDatumWriter(schema);
        try (DataFileWriter fileWriter = new DataFileWriter(writer);){
            fileWriter.create(schema, file);
            for (D datum : data) {
                fileWriter.append(datum);
            }
        }
        return file;
    }

    @Test
    public void copyUuid() {
        this.testCopy(LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING)), UUID.randomUUID(), GENERIC);
    }

    @Test
    public void copyUuidRaw() {
        this.testCopy(LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING)), UUID.randomUUID().toString(), GenericData.get());
    }

    @Test
    public void copyDecimal() {
        this.testCopy(LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)), new BigDecimal("-34.34"), GENERIC);
    }

    @Test
    public void copyDecimalRaw() {
        this.testCopy(LogicalTypes.decimal((int)9, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES)), ByteBuffer.wrap(new BigDecimal("-34.34").unscaledValue().toByteArray()), GenericData.get());
    }

    private void testCopy(Schema schema, Object value, GenericData model) {
        this.checkCopy(value, model.deepCopy(schema, value), false);
        Schema recordSchema = Schema.createRecord((String)"X", (String)"", (String)"test", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("x", schema, "", null));
        recordSchema.setFields(fields);
        GenericRecordBuilder builder = new GenericRecordBuilder(recordSchema);
        builder.set("x", value);
        GenericData.Record record = builder.build();
        this.checkCopy(record, model.deepCopy(recordSchema, (Object)record), true);
        Schema arraySchema = Schema.createArray((Schema)schema);
        ArrayList<Object> array = new ArrayList<Object>(Collections.singletonList(value));
        this.checkCopy(array, model.deepCopy(arraySchema, array), true);
        Schema recordArraySchema = Schema.createArray((Schema)recordSchema);
        ArrayList<GenericData.Record> recordArray = new ArrayList<GenericData.Record>(Collections.singletonList(record));
        this.checkCopy(recordArray, model.deepCopy(recordArraySchema, recordArray), true);
    }

    private void checkCopy(Object original, Object copy, boolean notSame) {
        if (notSame) {
            Assertions.assertNotSame((Object)original, (Object)copy);
        }
        Assertions.assertEquals((Object)original, (Object)copy);
    }

    @Test
    public void readLocalTimestampMillis() throws IOException {
        LogicalTypes.LocalTimestampMillis timestamp = LogicalTypes.localTimestampMillis();
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema timestampSchema = timestamp.addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        LocalDateTime i1 = LocalDateTime.of(1986, 6, 26, 12, 7, 11, 42000000);
        LocalDateTime i2 = LocalDateTime.ofInstant(Instant.ofEpochMilli(0L), ZoneOffset.UTC);
        List<LocalDateTime> expected = Arrays.asList(i1, i2);
        TimeConversions.LocalTimestampMillisConversion conversion = new TimeConversions.LocalTimestampMillisConversion();
        Long i1long = conversion.toLong((Object)i1, longSchema, (LogicalType)timestamp);
        Long i2long = 0L;
        File test = this.write(longSchema, i1long, i2long);
        Assertions.assertEquals(expected, this.read(GENERIC.createDatumReader(timestampSchema), test), (String)"Should convert long to LocalDateTime");
    }

    @Test
    public void writeLocalTimestampMillis() throws IOException {
        LogicalTypes.LocalTimestampMillis timestamp = LogicalTypes.localTimestampMillis();
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema timestampSchema = timestamp.addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        LocalDateTime i1 = LocalDateTime.of(1986, 6, 26, 12, 7, 11, 42000000);
        LocalDateTime i2 = LocalDateTime.ofInstant(Instant.ofEpochMilli(0L), ZoneOffset.UTC);
        TimeConversions.LocalTimestampMillisConversion conversion = new TimeConversions.LocalTimestampMillisConversion();
        Long d1long = conversion.toLong((Object)i1, longSchema, (LogicalType)timestamp);
        Long d2long = 0L;
        List<Long> expected = Arrays.asList(d1long, d2long);
        File test = this.write(GENERIC, timestampSchema, i1, i2);
        Assertions.assertEquals(expected, this.read(GenericData.get().createDatumReader(timestampSchema), test), (String)"Should read LocalDateTime as longs");
    }

    @Test
    public void readLocalTimestampMicros() throws IOException {
        LogicalTypes.LocalTimestampMicros timestamp = LogicalTypes.localTimestampMicros();
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema timestampSchema = timestamp.addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        LocalDateTime i1 = LocalDateTime.of(1986, 6, 26, 12, 7, 11, 420000);
        LocalDateTime i2 = LocalDateTime.ofInstant(Instant.ofEpochSecond(0L, 4000L), ZoneOffset.UTC);
        List<LocalDateTime> expected = Arrays.asList(i1, i2);
        TimeConversions.LocalTimestampMicrosConversion conversion = new TimeConversions.LocalTimestampMicrosConversion();
        Long i1long = conversion.toLong((Object)i1, longSchema, (LogicalType)timestamp);
        Long i2long = conversion.toLong((Object)i2, longSchema, (LogicalType)timestamp);
        File test = this.write(longSchema, i1long, i2long);
        Assertions.assertEquals(expected, this.read(GENERIC.createDatumReader(timestampSchema), test), (String)"Should convert long to LocalDateTime");
    }

    @Test
    public void writeLocalTimestampMicros() throws IOException {
        LogicalTypes.LocalTimestampMicros timestamp = LogicalTypes.localTimestampMicros();
        Schema longSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema timestampSchema = timestamp.addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        LocalDateTime i1 = LocalDateTime.of(1986, 6, 26, 12, 7, 11, 420000);
        LocalDateTime i2 = LocalDateTime.ofInstant(Instant.ofEpochSecond(0L, 4000L), ZoneOffset.UTC);
        TimeConversions.LocalTimestampMicrosConversion conversion = new TimeConversions.LocalTimestampMicrosConversion();
        Long d1long = conversion.toLong((Object)i1, longSchema, (LogicalType)timestamp);
        Long d2long = conversion.toLong((Object)i2, longSchema, (LogicalType)timestamp);
        List<Long> expected = Arrays.asList(d1long, d2long);
        File test = this.write(GENERIC, timestampSchema, i1, i2);
        Assertions.assertEquals(expected, this.read(GenericData.get().createDatumReader(timestampSchema), test), (String)"Should read LocalDateTime as longs");
    }

    @Test
    public void testReadAutomaticallyRegisteredUri() throws IOException {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        GenericData.setStringType((Schema)stringSchema, (GenericData.StringType)GenericData.StringType.String);
        LogicalType customType = ((LogicalTypes.LogicalTypeFactory)LogicalTypes.getCustomRegisteredTypes().get("custom")).fromSchema(stringSchema);
        Schema customTypeSchema = customType.addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        CustomType ct1 = new CustomType("foo");
        CustomType ct2 = new CustomType("bar");
        List<CustomType> expected = Arrays.asList(ct1, ct2);
        Conversion conversion = GENERIC.getConversionFor(customType);
        CharSequence ct1String = conversion.toCharSequence((Object)ct1, stringSchema, customType);
        CharSequence ct2String = conversion.toCharSequence((Object)ct2, stringSchema, customType);
        File test = this.write(stringSchema, ct1String, ct2String);
        Assertions.assertEquals(expected, this.read(GENERIC.createDatumReader(customTypeSchema), test), (String)"Should convert string to CustomType");
    }

    @Test
    public void testWriteAutomaticallyRegisteredUri() throws IOException {
        Schema stringSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        GenericData.setStringType((Schema)stringSchema, (GenericData.StringType)GenericData.StringType.String);
        LogicalType customType = ((LogicalTypes.LogicalTypeFactory)LogicalTypes.getCustomRegisteredTypes().get("custom")).fromSchema(stringSchema);
        Schema customTypeSchema = customType.addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        CustomType ct1 = new CustomType("foo");
        CustomType ct2 = new CustomType("bar");
        Conversion conversion = GENERIC.getConversionFor(customType);
        CharSequence ct1String = conversion.toCharSequence((Object)ct1, stringSchema, customType);
        CharSequence ct2String = conversion.toCharSequence((Object)ct2, stringSchema, customType);
        List<CharSequence> expected = Arrays.asList(ct1String, ct2String);
        File test = this.write(GENERIC, customTypeSchema, ct1, ct2);
        Assertions.assertEquals(expected, this.read(GenericData.get().createDatumReader(stringSchema), test), (String)"Should read CustomType as strings");
    }
}

