/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGenericDatumReader {
    private static final Random r = new Random(System.currentTimeMillis());
    private List<Schema> list = new ArrayList<Schema>();

    @Test
    void readerCache() {
        GenericDatumReader.ReaderCache cache = new GenericDatumReader.ReaderCache(this::findStringClass);
        List<Thread> threads = IntStream.rangeClosed(1, 200).mapToObj(index -> {
            Schema schema = this.build(index);
            WithSchema s = new WithSchema(schema, cache);
            return () -> s.test();
        }).map(Thread::new).collect(Collectors.toList());
        threads.forEach(Thread::start);
        threads.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    void newInstanceFromString() {
        GenericDatumReader.ReaderCache cache = new GenericDatumReader.ReaderCache(this::findStringClass);
        Object object = cache.newInstanceFromString(StringBuilder.class, "Hello");
        Assertions.assertEquals(StringBuilder.class, object.getClass());
        StringBuilder builder = (StringBuilder)object;
        Assertions.assertEquals((Object)"Hello", (Object)builder.toString());
    }

    private Schema build(int index) {
        int schemaNum = (index - 1) % 50;
        if (index <= 50) {
            Schema schema = Schema.createRecord((String)("record_" + schemaNum), (String)"doc", (String)"namespace", (boolean)false, Arrays.asList(new Schema.Field("field" + schemaNum, Schema.create((Schema.Type)Schema.Type.STRING))));
            this.list.add(schema);
        }
        return this.list.get(schemaNum);
    }

    private Class findStringClass(Schema schema) {
        this.sleep();
        if (schema.getType() == Schema.Type.INT) {
            return Integer.class;
        }
        if (schema.getType() == Schema.Type.STRING) {
            return String.class;
        }
        if (schema.getType() == Schema.Type.LONG) {
            return Long.class;
        }
        if (schema.getType() == Schema.Type.FLOAT) {
            return Float.class;
        }
        return String.class;
    }

    private void sleep() {
        long timeToSleep = (long)r.nextInt(30) + 10L;
        if (timeToSleep > 25L) {
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class WithSchema {
        private final Schema schema;
        private final GenericDatumReader.ReaderCache cache;

        public WithSchema(Schema schema, GenericDatumReader.ReaderCache cache) {
            this.schema = schema;
            this.cache = cache;
        }

        public void test() {
            this.cache.getStringClass(this.schema);
        }
    }
}

