/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSeekableInputStream {
    @Test
    void readingData() throws IOException {
        byte[] data = "0123456789ABCD".getBytes(StandardCharsets.UTF_8);
        try (DataFileReader.SeekableInputStream sin = new DataFileReader.SeekableInputStream((SeekableInput)new SeekableByteArrayInput(data));){
            byte[] first8 = new byte[8];
            Assertions.assertEquals((int)first8.length, (int)sin.read(first8, 0, 8));
            Assertions.assertArrayEquals((byte[])"01234567".getBytes(StandardCharsets.UTF_8), (byte[])first8);
            sin.seek(4L);
            Assertions.assertEquals((int)10, (int)sin.available());
            Assertions.assertEquals((long)2L, (long)sin.skip(2L));
            Assertions.assertEquals((int)54, (int)sin.read());
            byte[] next4 = new byte[4];
            Assertions.assertEquals((int)next4.length, (int)sin.read(next4));
            Assertions.assertArrayEquals((byte[])"789A".getBytes(StandardCharsets.UTF_8), (byte[])next4);
            Assertions.assertEquals((long)11L, (long)sin.tell());
            Assertions.assertEquals((long)data.length, (long)sin.length());
        }
    }

    @Test
    void illegalSeek() throws IOException {
        try (SeekableByteArrayInput in = new SeekableByteArrayInput("".getBytes(StandardCharsets.UTF_8));
             DataFileReader.SeekableInputStream sin = new DataFileReader.SeekableInputStream((SeekableInput)in);){
            Assert.assertThrows(IOException.class, () -> sin.seek(-5L));
        }
    }
}

