/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.data;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilderBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RecordBuilderBaseTest {
    private static Set<Schema.Type> primitives;
    private static Set<Schema.Type> nonNullPrimitives;

    @BeforeAll
    public static void setUpBeforeClass() {
        primitives = new HashSet<Schema.Type>(Arrays.asList(Schema.Type.values()));
        primitives.removeAll(Arrays.asList(Schema.Type.RECORD, Schema.Type.ENUM, Schema.Type.ARRAY, Schema.Type.MAP, Schema.Type.UNION, Schema.Type.FIXED));
        nonNullPrimitives = new HashSet<Schema.Type>(primitives);
        nonNullPrimitives.remove(Schema.Type.NULL);
    }

    @Test
    void isValidValueWithPrimitives() {
        Schema.Field f;
        for (Schema.Type type : primitives) {
            f = new Schema.Field("f", Schema.create((Schema.Type)type), null, null);
            Assertions.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)f, (Object)new Object()));
        }
        for (Schema.Type type : nonNullPrimitives) {
            f = new Schema.Field("f", Schema.create((Schema.Type)type), null, null);
            Assertions.assertFalse((boolean)RecordBuilderBase.isValidValue((Schema.Field)f, null));
        }
    }

    @Test
    void isValidValueWithNullField() {
        Assertions.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", Schema.create((Schema.Type)Schema.Type.NULL), null, null), null));
    }

    @Test
    void isValidValueWithUnion() {
        Schema unionWithoutNull = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.BOOLEAN)));
        Assertions.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", unionWithoutNull, null, null), (Object)new Object()));
        Assertions.assertFalse((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", unionWithoutNull, null, null), null));
        Schema unionWithNull = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
        Assertions.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", unionWithNull, null, null), (Object)new Object()));
        Assertions.assertTrue((boolean)RecordBuilderBase.isValidValue((Schema.Field)new Schema.Field("f", unionWithNull, null, null), null));
    }
}

