/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.math.BigInteger;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestUuidConversions {
    private Conversions.UUIDConversion uuidConversion = new Conversions.UUIDConversion();
    private Schema fixed = Schema.createFixed((String)"fixed", (String)"doc", (String)"", (int)16);
    private Schema fixedUuid = LogicalTypes.uuid().addToSchema(this.fixed);
    private Schema string = Schema.createFixed((String)"fixed", (String)"doc", (String)"", (int)16);
    private Schema stringUuid = LogicalTypes.uuid().addToSchema(this.string);

    @ParameterizedTest
    @MethodSource(value={"uuidData"})
    void uuidFixed(UUID uuid) {
        GenericFixed value = this.uuidConversion.toFixed(uuid, this.fixedUuid, LogicalTypes.uuid());
        byte[] b = new byte[8];
        System.arraycopy(value.bytes(), 0, b, 0, b.length);
        Assertions.assertEquals((long)uuid.getMostSignificantBits(), (long)new BigInteger(b).longValue());
        System.arraycopy(value.bytes(), 8, b, 0, b.length);
        Assertions.assertEquals((long)uuid.getLeastSignificantBits(), (long)new BigInteger(b).longValue());
        UUID uuid1 = this.uuidConversion.fromFixed(value, this.fixedUuid, LogicalTypes.uuid());
        Assertions.assertEquals((Object)uuid, (Object)uuid1);
    }

    @ParameterizedTest
    @MethodSource(value={"uuidData"})
    void uuidCharSequence(UUID uuid) {
        CharSequence value = this.uuidConversion.toCharSequence(uuid, this.stringUuid, LogicalTypes.uuid());
        Assertions.assertEquals((Object)uuid.toString(), (Object)value.toString());
        UUID uuid1 = this.uuidConversion.fromCharSequence(value, this.stringUuid, LogicalTypes.uuid());
        Assertions.assertEquals((Object)uuid, (Object)uuid1);
    }

    public static Stream<Arguments> uuidData() {
        return Stream.of(Arguments.of((Object[])new Object[]{new UUID(Long.MIN_VALUE, Long.MAX_VALUE)}), Arguments.of((Object[])new Object[]{new UUID(-1L, 0L)}), Arguments.of((Object[])new Object[]{UUID.randomUUID()}), Arguments.of((Object[])new Object[]{UUID.randomUUID()}));
    }
}

