/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.function.Function;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.SystemLimitException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSystemLimitException {
    public static final int MAX_ARRAY_VM_LIMIT = 0x7FFFFFF7;
    public static final String ERROR_NEGATIVE = "Malformed data. Length is negative: -1";
    public static final String ERROR_VM_LIMIT_BYTES = "Cannot read arrays longer than 2147483639 bytes in Java library";
    public static final String ERROR_VM_LIMIT_COLLECTION = "Cannot read collections larger than 2147483639 items in Java library";
    public static final String ERROR_VM_LIMIT_STRING = "Cannot read strings longer than 2147483639 bytes";

    public static void resetLimits() {
        SystemLimitException.resetLimits();
    }

    @AfterEach
    void reset() {
        System.clearProperty("org.apache.avro.limits.bytes.maxLength");
        System.clearProperty("org.apache.avro.limits.collectionItems.maxLength");
        System.clearProperty("org.apache.avro.limits.string.maxLength");
        TestSystemLimitException.resetLimits();
    }

    void helpCheckSystemLimits(Function<Long, Integer> f, String sysProperty, String errorVmLimit, String errorCustomLimit) {
        Assertions.assertEquals((int)0, (Integer)f.apply(0L));
        Assertions.assertEquals((int)1024, (Integer)f.apply(1024L));
        Assertions.assertEquals((int)0x7FFFFFF7, (Integer)f.apply(0x7FFFFFF7L));
        Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> f.apply(Long.MAX_VALUE));
        Assertions.assertEquals((Object)errorVmLimit, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> f.apply(0x7FFFFFF8L));
        Assertions.assertEquals((Object)errorVmLimit, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(AvroRuntimeException.class, () -> f.apply(-1L));
        Assertions.assertEquals((Object)ERROR_NEGATIVE, (Object)ex.getMessage());
        System.setProperty(sysProperty, Long.toString(1000L));
        TestSystemLimitException.resetLimits();
        Assertions.assertEquals((int)0, (Integer)f.apply(0L));
        Assertions.assertEquals((int)102, (Integer)f.apply(102L));
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> f.apply(0x7FFFFFF8L));
        Assertions.assertEquals((Object)errorVmLimit, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> f.apply(1024L));
        Assertions.assertEquals((Object)errorCustomLimit, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(AvroRuntimeException.class, () -> f.apply(-1L));
        Assertions.assertEquals((Object)ERROR_NEGATIVE, (Object)ex.getMessage());
    }

    @Test
    void testCheckMaxBytesLength() {
        this.helpCheckSystemLimits(SystemLimitException::checkMaxBytesLength, "org.apache.avro.limits.bytes.maxLength", ERROR_VM_LIMIT_BYTES, "Bytes length 1024 exceeds maximum allowed");
    }

    @Test
    void testCheckMaxCollectionLengthFromZero() {
        this.helpCheckSystemLimits(l -> SystemLimitException.checkMaxCollectionLength((long)0L, (long)l), "org.apache.avro.limits.collectionItems.maxLength", ERROR_VM_LIMIT_COLLECTION, "Collection length 1024 exceeds maximum allowed");
    }

    @Test
    void testCheckMaxStringLength() {
        this.helpCheckSystemLimits(SystemLimitException::checkMaxStringLength, "org.apache.avro.limits.string.maxLength", ERROR_VM_LIMIT_STRING, "String length 1024 exceeds maximum allowed");
    }

    @Test
    void testCheckMaxCollectionLengthFromNonZero() {
        Assertions.assertEquals((int)10, (int)SystemLimitException.checkMaxCollectionLength((long)10L, (long)0L));
        Assertions.assertEquals((int)0x7FFFFFF7, (int)SystemLimitException.checkMaxCollectionLength((long)10L, (long)2147483629L));
        Assertions.assertEquals((int)0x7FFFFFF7, (int)SystemLimitException.checkMaxCollectionLength((long)2147483629L, (long)10L));
        Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> SystemLimitException.checkMaxCollectionLength((long)10L, (long)0x7FFFFFEEL));
        Assertions.assertEquals((Object)ERROR_VM_LIMIT_COLLECTION, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> SystemLimitException.checkMaxCollectionLength((long)0x7FFFFFEEL, (long)10L));
        Assertions.assertEquals((Object)ERROR_VM_LIMIT_COLLECTION, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> SystemLimitException.checkMaxCollectionLength((long)10L, (long)0x7FFFFFFFFFFFFFF5L));
        Assertions.assertEquals((Object)ERROR_VM_LIMIT_COLLECTION, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> SystemLimitException.checkMaxCollectionLength((long)0x7FFFFFFFFFFFFFF5L, (long)10L));
        Assertions.assertEquals((Object)ERROR_VM_LIMIT_COLLECTION, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> SystemLimitException.checkMaxCollectionLength((long)10L, (long)Long.MAX_VALUE));
        Assertions.assertEquals((Object)ERROR_VM_LIMIT_COLLECTION, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> SystemLimitException.checkMaxCollectionLength((long)Long.MAX_VALUE, (long)10L));
        Assertions.assertEquals((Object)ERROR_VM_LIMIT_COLLECTION, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(AvroRuntimeException.class, () -> SystemLimitException.checkMaxCollectionLength((long)10L, (long)-1L));
        Assertions.assertEquals((Object)ERROR_NEGATIVE, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(AvroRuntimeException.class, () -> SystemLimitException.checkMaxCollectionLength((long)-1L, (long)10L));
        Assertions.assertEquals((Object)ERROR_NEGATIVE, (Object)ex.getMessage());
        System.setProperty("org.apache.avro.limits.collectionItems.maxLength", Long.toString(1000L));
        TestSystemLimitException.resetLimits();
        Assertions.assertEquals((int)10, (int)SystemLimitException.checkMaxCollectionLength((long)10L, (long)0L));
        Assertions.assertEquals((int)102, (int)SystemLimitException.checkMaxCollectionLength((long)10L, (long)92L));
        Assertions.assertEquals((int)102, (int)SystemLimitException.checkMaxCollectionLength((long)92L, (long)10L));
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> SystemLimitException.checkMaxCollectionLength((long)0x7FFFFFF7L, (long)1L));
        Assertions.assertEquals((Object)ERROR_VM_LIMIT_COLLECTION, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> SystemLimitException.checkMaxCollectionLength((long)1L, (long)0x7FFFFFF7L));
        Assertions.assertEquals((Object)ERROR_VM_LIMIT_COLLECTION, (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> SystemLimitException.checkMaxCollectionLength((long)999L, (long)25L));
        Assertions.assertEquals((Object)"Collection length 1024 exceeds maximum allowed", (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> SystemLimitException.checkMaxCollectionLength((long)25L, (long)999L));
        Assertions.assertEquals((Object)"Collection length 1024 exceeds maximum allowed", (Object)ex.getMessage());
    }
}

