/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.avro.Schema;
import org.junit.jupiter.api.Assertions;

public class TestSchemas {
    static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    static final Schema BOOLEAN_SCHEMA = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
    static final Schema INT_SCHEMA = Schema.create((Schema.Type)Schema.Type.INT);
    static final Schema LONG_SCHEMA = Schema.create((Schema.Type)Schema.Type.LONG);
    static final Schema FLOAT_SCHEMA = Schema.create((Schema.Type)Schema.Type.FLOAT);
    static final Schema DOUBLE_SCHEMA = Schema.create((Schema.Type)Schema.Type.DOUBLE);
    static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    static final Schema BYTES_SCHEMA = Schema.create((Schema.Type)Schema.Type.BYTES);
    static final Schema INT_ARRAY_SCHEMA = Schema.createArray((Schema)INT_SCHEMA);
    static final Schema LONG_ARRAY_SCHEMA = Schema.createArray((Schema)LONG_SCHEMA);
    static final Schema STRING_ARRAY_SCHEMA = Schema.createArray((Schema)STRING_SCHEMA);
    static final Schema INT_MAP_SCHEMA = Schema.createMap((Schema)INT_SCHEMA);
    static final Schema LONG_MAP_SCHEMA = Schema.createMap((Schema)LONG_SCHEMA);
    static final Schema STRING_MAP_SCHEMA = Schema.createMap((Schema)STRING_SCHEMA);
    static final Schema ENUM1_AB_SCHEMA = Schema.createEnum((String)"Enum1", null, null, TestSchemas.list("A", "B"));
    static final Schema ENUM1_AB_SCHEMA_DEFAULT = Schema.createEnum((String)"Enum1", null, null, TestSchemas.list("A", "B"), (String)"A");
    public static final Schema ENUM1_AB_SCHEMA_NAMESPACE_1 = Schema.createEnum((String)"Enum1", null, (String)"namespace1", TestSchemas.list("A", "B"));
    public static final Schema ENUM1_AB_SCHEMA_NAMESPACE_2 = Schema.createEnum((String)"Enum1", null, (String)"namespace2", TestSchemas.list("A", "B"));
    static final Schema ENUM1_ABC_SCHEMA = Schema.createEnum((String)"Enum1", null, null, TestSchemas.list("A", "B", "C"));
    static final Schema ENUM1_BC_SCHEMA = Schema.createEnum((String)"Enum1", null, null, TestSchemas.list("B", "C"));
    static final Schema ENUM2_AB_SCHEMA = Schema.createEnum((String)"Enum2", null, null, TestSchemas.list("A", "B"));
    static final Schema ENUM_ABC_ENUM_DEFAULT_A_SCHEMA = Schema.createEnum((String)"Enum", null, null, TestSchemas.list("A", "B", "C"), (String)"A");
    static final Schema ENUM_AB_ENUM_DEFAULT_A_SCHEMA = Schema.createEnum((String)"Enum", null, null, TestSchemas.list("A", "B"), (String)"A");
    static final Schema ENUM_ABC_ENUM_DEFAULT_A_RECORD = Schema.createRecord((String)"Record", null, null, (boolean)false);
    static final Schema ENUM_AB_ENUM_DEFAULT_A_RECORD = Schema.createRecord((String)"Record", null, null, (boolean)false);
    static final Schema ENUM_ABC_FIELD_DEFAULT_B_ENUM_DEFAULT_A_RECORD = Schema.createRecord((String)"Record", null, null, (boolean)false);
    static final Schema ENUM_AB_FIELD_DEFAULT_A_ENUM_DEFAULT_B_RECORD = Schema.createRecord((String)"Record", null, null, (boolean)false);
    static final Schema EMPTY_UNION_SCHEMA;
    static final Schema NULL_UNION_SCHEMA;
    static final Schema INT_UNION_SCHEMA;
    static final Schema LONG_UNION_SCHEMA;
    static final Schema FLOAT_UNION_SCHEMA;
    static final Schema DOUBLE_UNION_SCHEMA;
    static final Schema STRING_UNION_SCHEMA;
    static final Schema BYTES_UNION_SCHEMA;
    static final Schema INT_STRING_UNION_SCHEMA;
    static final Schema STRING_INT_UNION_SCHEMA;
    static final Schema INT_FLOAT_UNION_SCHEMA;
    static final Schema INT_LONG_UNION_SCHEMA;
    static final Schema INT_LONG_FLOAT_DOUBLE_UNION_SCHEMA;
    static final Schema NULL_INT_ARRAY_UNION_SCHEMA;
    static final Schema NULL_INT_MAP_UNION_SCHEMA;
    static final Schema EMPTY_RECORD1;
    static final Schema EMPTY_RECORD2;
    static final Schema A_INT_RECORD1;
    static final Schema A_LONG_RECORD1;
    static final Schema A_INT_B_INT_RECORD1;
    static final Schema A_DINT_RECORD1;
    static final Schema A_INT_B_DINT_RECORD1;
    static final Schema A_DINT_B_DINT_RECORD1;
    static final Schema A_DINT_B_DFIXED_4_BYTES_RECORD1;
    static final Schema A_DINT_B_DFIXED_8_BYTES_RECORD1;
    static final Schema A_DINT_B_DINT_STRING_UNION_RECORD1;
    static final Schema A_DINT_B_DINT_UNION_RECORD1;
    static final Schema A_DINT_B_DENUM_1_RECORD1;
    static final Schema A_DINT_B_DENUM_2_RECORD1;
    static final Schema FIXED_4_BYTES;
    static final Schema FIXED_8_BYTES;
    static final Schema NS_RECORD1;
    static final Schema NS_RECORD2;
    static final Schema NS_INNER_RECORD1;
    static final Schema NS_INNER_RECORD2;
    static final Schema WITHOUT_NS;
    static final Schema WITH_NS;
    static final Schema INT_LIST_RECORD;
    static final Schema LONG_LIST_RECORD;

    static <E> ArrayList<E> list(E ... elements) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, elements);
        return list;
    }

    static void assertSchemaContains(Schema schemaSubset, Schema original) {
        String subset = schemaSubset.toString(false);
        String whole = original.toString(false);
        Assertions.assertTrue((boolean)whole.contains(subset), (String)String.format("Subset '%s' not found in '%s'", subset, whole));
    }

    static {
        ENUM_ABC_ENUM_DEFAULT_A_RECORD.setFields(TestSchemas.list(new Schema.Field("Field", Schema.createEnum((String)"Schema", null, null, TestSchemas.list("A", "B", "C"), (String)"A"), null, null)));
        ENUM_AB_ENUM_DEFAULT_A_RECORD.setFields(TestSchemas.list(new Schema.Field("Field", Schema.createEnum((String)"Schema", null, null, TestSchemas.list("A", "B"), (String)"A"), null, null)));
        ENUM_ABC_FIELD_DEFAULT_B_ENUM_DEFAULT_A_RECORD.setFields(TestSchemas.list(new Schema.Field("Field", Schema.createEnum((String)"Schema", null, null, TestSchemas.list("A", "B", "C"), (String)"A"), null, (Object)"B")));
        ENUM_AB_FIELD_DEFAULT_A_ENUM_DEFAULT_B_RECORD.setFields(TestSchemas.list(new Schema.Field("Field", Schema.createEnum((String)"Schema", null, null, TestSchemas.list("A", "B"), (String)"B"), null, (Object)"A")));
        EMPTY_UNION_SCHEMA = Schema.createUnion(new ArrayList());
        NULL_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(NULL_SCHEMA));
        INT_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(INT_SCHEMA));
        LONG_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(LONG_SCHEMA));
        FLOAT_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(FLOAT_SCHEMA));
        DOUBLE_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(DOUBLE_SCHEMA));
        STRING_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(STRING_SCHEMA));
        BYTES_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(BYTES_SCHEMA));
        INT_STRING_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(INT_SCHEMA, STRING_SCHEMA));
        STRING_INT_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(STRING_SCHEMA, INT_SCHEMA));
        INT_FLOAT_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(INT_SCHEMA, FLOAT_SCHEMA));
        INT_LONG_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(INT_SCHEMA, LONG_SCHEMA));
        INT_LONG_FLOAT_DOUBLE_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(INT_SCHEMA, LONG_SCHEMA, FLOAT_SCHEMA, DOUBLE_SCHEMA));
        NULL_INT_ARRAY_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(NULL_SCHEMA, INT_ARRAY_SCHEMA));
        NULL_INT_MAP_UNION_SCHEMA = Schema.createUnion(TestSchemas.list(NULL_SCHEMA, INT_MAP_SCHEMA));
        EMPTY_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        EMPTY_RECORD2 = Schema.createRecord((String)"Record2", null, null, (boolean)false);
        A_INT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_LONG_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_INT_B_INT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_DINT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_INT_B_DINT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_DINT_B_DINT_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_DINT_B_DFIXED_4_BYTES_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_DINT_B_DFIXED_8_BYTES_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_DINT_B_DINT_STRING_UNION_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_DINT_B_DINT_UNION_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_DINT_B_DENUM_1_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        A_DINT_B_DENUM_2_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        FIXED_4_BYTES = Schema.createFixed((String)"Fixed", null, null, (int)4);
        FIXED_8_BYTES = Schema.createFixed((String)"Fixed", null, null, (int)8);
        NS_RECORD1 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        NS_RECORD2 = Schema.createRecord((String)"Record1", null, null, (boolean)false);
        NS_INNER_RECORD1 = Schema.createRecord((String)"InnerRecord1", null, (String)"ns1", (boolean)false);
        NS_INNER_RECORD2 = Schema.createRecord((String)"InnerRecord1", null, (String)"ns2", (boolean)false);
        WITHOUT_NS = Schema.createRecord((String)"Record", null, null, (boolean)false);
        WITH_NS = Schema.createRecord((String)"ns.Record", null, null, (boolean)false);
        EMPTY_RECORD1.setFields(Collections.emptyList());
        EMPTY_RECORD2.setFields(Collections.emptyList());
        A_INT_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, null)));
        A_LONG_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", LONG_SCHEMA, null, null)));
        A_INT_B_INT_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, null), new Schema.Field("b", INT_SCHEMA, null, null)));
        A_DINT_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0)));
        A_INT_B_DINT_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, null), new Schema.Field("b", INT_SCHEMA, null, (Object)0)));
        A_DINT_B_DINT_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0), new Schema.Field("b", INT_SCHEMA, null, (Object)0)));
        A_DINT_B_DFIXED_4_BYTES_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0), new Schema.Field("b", FIXED_4_BYTES, null, null)));
        A_DINT_B_DFIXED_8_BYTES_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0), new Schema.Field("b", FIXED_8_BYTES, null, null)));
        A_DINT_B_DINT_STRING_UNION_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0), new Schema.Field("b", INT_STRING_UNION_SCHEMA, null, (Object)0)));
        A_DINT_B_DINT_UNION_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0), new Schema.Field("b", INT_UNION_SCHEMA, null, (Object)0)));
        A_DINT_B_DENUM_1_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0), new Schema.Field("b", ENUM1_AB_SCHEMA, null, null)));
        A_DINT_B_DENUM_2_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA, null, (Object)0), new Schema.Field("b", ENUM2_AB_SCHEMA, null, null)));
        NS_INNER_RECORD1.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA)));
        NS_INNER_RECORD2.setFields(TestSchemas.list(new Schema.Field("a", INT_SCHEMA)));
        NS_RECORD1.setFields(TestSchemas.list(new Schema.Field("f1", Schema.createUnion((Schema[])new Schema[]{NULL_SCHEMA, Schema.createArray((Schema)NS_INNER_RECORD1)}))));
        NS_RECORD2.setFields(TestSchemas.list(new Schema.Field("f1", Schema.createUnion((Schema[])new Schema[]{NULL_SCHEMA, Schema.createArray((Schema)NS_INNER_RECORD2)}))));
        WITH_NS.setFields(TestSchemas.list(new Schema.Field("f1", INT_SCHEMA, null, null)));
        WITHOUT_NS.setFields(TestSchemas.list(new Schema.Field("f1", INT_SCHEMA, null, null)));
        INT_LIST_RECORD = Schema.createRecord((String)"List", null, null, (boolean)false);
        LONG_LIST_RECORD = Schema.createRecord((String)"List", null, null, (boolean)false);
        INT_LIST_RECORD.setFields(TestSchemas.list(new Schema.Field("head", INT_SCHEMA, null, null), new Schema.Field("tail", INT_LIST_RECORD, null, null)));
        LONG_LIST_RECORD.setFields(TestSchemas.list(new Schema.Field("head", LONG_SCHEMA, null, null), new Schema.Field("tail", LONG_LIST_RECORD, null, null)));
    }

    static final class ReaderWriter {
        private final Schema mReader;
        private final Schema mWriter;

        public ReaderWriter(Schema reader, Schema writer) {
            this.mReader = reader;
            this.mWriter = writer;
        }

        public Schema getReader() {
            return this.mReader;
        }

        public Schema getWriter() {
            return this.mWriter;
        }
    }
}

