/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.TestSchemaCompatibility;
import org.apache.avro.TestSchemas;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestSchemaCompatibilityFixedSizeMismatch {
    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSchemas.FIXED_4_BYTES, TestSchemas.FIXED_8_BYTES, "expected: 8, found: 4", "/size"}), Arguments.of((Object[])new Object[]{TestSchemas.FIXED_8_BYTES, TestSchemas.FIXED_4_BYTES, "expected: 4, found: 8", "/size"}), Arguments.of((Object[])new Object[]{TestSchemas.A_DINT_B_DFIXED_8_BYTES_RECORD1, TestSchemas.A_DINT_B_DFIXED_4_BYTES_RECORD1, "expected: 4, found: 8", "/fields/1/type/size"}), Arguments.of((Object[])new Object[]{TestSchemas.A_DINT_B_DFIXED_4_BYTES_RECORD1, TestSchemas.A_DINT_B_DFIXED_8_BYTES_RECORD1, "expected: 8, found: 4", "/fields/1/type/size"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void fixedSizeMismatchSchemas(Schema reader, Schema writer, String details, String location) {
        TestSchemaCompatibility.validateIncompatibleSchemas(reader, writer, SchemaCompatibility.SchemaIncompatibilityType.FIXED_SIZE_MISMATCH, details, location);
    }
}

