/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.TestSchemas;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.ResolvingDecoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchemaCompatibilityEnumDefaults {
    @Test
    void enumDefaultNotAppliedWhenWriterFieldMissing() throws Exception {
        Schema writerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field2").type(TestSchemas.ENUM2_AB_SCHEMA).noDefault().endRecord();
        Schema readerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM_AB_ENUM_DEFAULT_A_SCHEMA).noDefault().endRecord();
        GenericData.Record datum = new GenericData.Record(writerSchema);
        datum.put("field2", (Object)new GenericData.EnumSymbol(writerSchema, "B"));
        AvroTypeException avroTypeException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> this.lambda$enumDefaultNotAppliedWhenWriterFieldMissing$0(writerSchema, (GenericRecord)datum, readerSchema));
        Assertions.assertEquals((Object)"Found Record1, expecting Record1, missing required field field1", (Object)avroTypeException.getMessage());
    }

    @Test
    void enumDefaultAppliedWhenNoFieldDefaultDefined() throws Exception {
        Schema writerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM_ABC_ENUM_DEFAULT_A_SCHEMA).noDefault().endRecord();
        Schema readerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM_AB_ENUM_DEFAULT_A_SCHEMA).noDefault().endRecord();
        GenericData.Record datum = new GenericData.Record(writerSchema);
        datum.put("field1", (Object)new GenericData.EnumSymbol(writerSchema, "C"));
        GenericRecord decodedDatum = this.serializeWithWriterThenDeserializeWithReader(writerSchema, (GenericRecord)datum, readerSchema);
        Assertions.assertEquals((Object)"A", (Object)decodedDatum.get("field1").toString());
    }

    @Test
    void enumDefaultNotAppliedWhenCompatibleSymbolIsFound() throws Exception {
        Schema writerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM_ABC_ENUM_DEFAULT_A_SCHEMA).noDefault().endRecord();
        Schema readerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM_AB_ENUM_DEFAULT_A_SCHEMA).noDefault().endRecord();
        GenericData.Record datum = new GenericData.Record(writerSchema);
        datum.put("field1", (Object)new GenericData.EnumSymbol(writerSchema, "B"));
        GenericRecord decodedDatum = this.serializeWithWriterThenDeserializeWithReader(writerSchema, (GenericRecord)datum, readerSchema);
        Assertions.assertEquals((Object)"B", (Object)decodedDatum.get("field1").toString());
    }

    @Test
    void enumDefaultAppliedWhenFieldDefaultDefined() throws Exception {
        Schema writerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM_ABC_ENUM_DEFAULT_A_SCHEMA).noDefault().endRecord();
        Schema readerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM_AB_ENUM_DEFAULT_A_SCHEMA).withDefault((Object)"B").endRecord();
        GenericData.Record datum = new GenericData.Record(writerSchema);
        datum.put("field1", (Object)new GenericData.EnumSymbol(writerSchema, "C"));
        GenericRecord decodedDatum = this.serializeWithWriterThenDeserializeWithReader(writerSchema, (GenericRecord)datum, readerSchema);
        Assertions.assertEquals((Object)"A", (Object)decodedDatum.get("field1").toString());
    }

    @Test
    void fieldDefaultNotAppliedForUnknownSymbol() throws Exception {
        Schema writerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM1_ABC_SCHEMA).noDefault().endRecord();
        Schema readerSchema = (Schema)SchemaBuilder.record((String)"Record1").fields().name("field1").type(TestSchemas.ENUM1_AB_SCHEMA).withDefault((Object)"A").endRecord();
        GenericData.Record datum = new GenericData.Record(writerSchema);
        datum.put("field1", (Object)new GenericData.EnumSymbol(writerSchema, "C"));
        AvroTypeException avroTypeException = (AvroTypeException)Assertions.assertThrows(AvroTypeException.class, () -> this.lambda$fieldDefaultNotAppliedForUnknownSymbol$1(writerSchema, (GenericRecord)datum, readerSchema));
        Assertions.assertEquals((Object)"No match for C", (Object)avroTypeException.getMessage());
    }

    private GenericRecord serializeWithWriterThenDeserializeWithReader(Schema writerSchema, GenericRecord datum, Schema readerSchema) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
        GenericDatumWriter datumWriter = new GenericDatumWriter(writerSchema);
        datumWriter.write((Object)datum, (Encoder)encoder);
        encoder.flush();
        byte[] bytes = baos.toByteArray();
        ResolvingDecoder decoder = DecoderFactory.get().resolvingDecoder(writerSchema, readerSchema, (Decoder)DecoderFactory.get().binaryDecoder(bytes, null));
        GenericDatumReader datumReader = new GenericDatumReader(readerSchema);
        return (GenericRecord)datumReader.read(null, (Decoder)decoder);
    }

    private /* synthetic */ void lambda$fieldDefaultNotAppliedForUnknownSymbol$1(Schema writerSchema, GenericRecord datum, Schema readerSchema) throws Throwable {
        this.serializeWithWriterThenDeserializeWithReader(writerSchema, datum, readerSchema);
    }

    private /* synthetic */ void lambda$enumDefaultNotAppliedWhenWriterFieldMissing$0(Schema writerSchema, GenericRecord datum, Schema readerSchema) throws Throwable {
        this.serializeWithWriterThenDeserializeWithReader(writerSchema, datum, readerSchema);
    }
}

