/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.NameValidator;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.SchemaParseException;
import org.apache.avro.SchemaParser;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSchema {
    @Test
    void splitSchemaBuild() {
        Schema s = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"HandshakeRequest").namespace("org.apache.avro.ipc")).fields().name("clientProtocol").type().optional().stringType()).name("meta").type().optional().map().values().bytesType()).endRecord();
        String schemaString = s.toString();
        int mid = schemaString.length() / 2;
        Schema parsedStringSchema = new Schema.Parser().parse(s.toString());
        Schema parsedArrayOfStringSchema = new Schema.Parser().parse(schemaString.substring(0, mid), new String[]{schemaString.substring(mid)});
        Assertions.assertNotNull((Object)parsedStringSchema);
        Assertions.assertNotNull((Object)parsedArrayOfStringSchema);
        Assertions.assertEquals((Object)parsedStringSchema.toString(), (Object)parsedArrayOfStringSchema.toString());
    }

    @Test
    void defaultRecordWithDuplicateFieldName() {
        String recordName = "name";
        Schema schema = Schema.createRecord((String)recordName, (String)"doc", (String)"namespace", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("field_name", Schema.create((Schema.Type)Schema.Type.NULL), null, null));
        fields.add(new Schema.Field("field_name", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        try {
            schema.setFields(fields);
            Assertions.fail((String)"Should not be able to create a record with duplicate field name.");
        }
        catch (AvroRuntimeException are) {
            Assertions.assertTrue((boolean)are.getMessage().contains("Duplicate field field_name in record " + recordName));
        }
    }

    @Test
    void createUnionVarargs() {
        ArrayList<Schema> types = new ArrayList<Schema>();
        types.add(Schema.create((Schema.Type)Schema.Type.NULL));
        types.add(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema expected = Schema.createUnion(types);
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)});
        Assertions.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    void recordWithNullDoc() {
        Schema schema = Schema.createRecord((String)"name", null, (String)"namespace", (boolean)false);
        String schemaString = schema.toString();
        Assertions.assertNotNull((Object)schemaString);
    }

    @Test
    void recordWithNullNamespace() {
        Schema schema = Schema.createRecord((String)"name", (String)"doc", null, (boolean)false);
        String schemaString = schema.toString();
        Assertions.assertNotNull((Object)schemaString);
    }

    @Test
    void emptyRecordSchema() {
        Schema schema = this.createDefaultRecord();
        String schemaString = schema.toString();
        Assertions.assertNotNull((Object)schemaString);
    }

    @Test
    void parseEmptySchema() {
        Assertions.assertThrows(SchemaParseException.class, () -> new Schema.Parser().parse(""));
    }

    @Test
    void schemaWithFields() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("field_name1", Schema.create((Schema.Type)Schema.Type.NULL), null, null));
        fields.add(new Schema.Field("field_name2", Schema.create((Schema.Type)Schema.Type.INT), null, null));
        Schema schema = this.createDefaultRecord();
        schema.setFields(fields);
        String schemaString = schema.toString();
        Assertions.assertNotNull((Object)schemaString);
        Assertions.assertEquals((int)2, (int)schema.getFields().size());
    }

    @Test
    void schemaWithNullFields() {
        Assertions.assertThrows(NullPointerException.class, () -> Schema.createRecord((String)"name", (String)"doc", (String)"namespace", (boolean)false, null));
    }

    @Test
    void isUnionOnUnionWithMultipleElements() {
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)});
        Assertions.assertTrue((boolean)schema.isUnion());
    }

    @Test
    void isUnionOnUnionWithOneElement() {
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.LONG)});
        Assertions.assertTrue((boolean)schema.isUnion());
    }

    @Test
    void isUnionOnRecord() {
        Schema schema = this.createDefaultRecord();
        Assertions.assertFalse((boolean)schema.isUnion());
    }

    @Test
    void isUnionOnArray() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.LONG));
        Assertions.assertFalse((boolean)schema.isUnion());
    }

    @Test
    void isUnionOnEnum() {
        Schema schema = Schema.createEnum((String)"name", (String)"doc", (String)"namespace", Collections.singletonList("value"));
        Assertions.assertFalse((boolean)schema.isUnion());
    }

    @Test
    void isUnionOnFixed() {
        Schema schema = Schema.createFixed((String)"name", (String)"doc", (String)"space", (int)10);
        Assertions.assertFalse((boolean)schema.isUnion());
    }

    @Test
    void isUnionOnMap() {
        Schema schema = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.LONG));
        Assertions.assertFalse((boolean)schema.isUnion());
    }

    @Test
    void isNullableOnUnionWithNull() {
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)});
        Assertions.assertTrue((boolean)schema.isNullable());
    }

    @Test
    void isNullableOnUnionWithoutNull() {
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.LONG)});
        Assertions.assertFalse((boolean)schema.isNullable());
    }

    @Test
    void isNullableOnRecord() {
        Schema schema = this.createDefaultRecord();
        Assertions.assertFalse((boolean)schema.isNullable());
    }

    private Schema createDefaultRecord() {
        return Schema.createRecord((String)"name", (String)"doc", (String)"namespace", (boolean)false);
    }

    @Test
    void serialization() throws IOException, ClassNotFoundException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);
             InputStream jsonSchema = this.getClass().getResourceAsStream("/SchemaBuilder.avsc");){
            Schema payload = new Schema.Parser().parse(jsonSchema);
            oos.writeObject(payload);
            try (ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                 ObjectInputStream ois = new ObjectInputStream(bis);){
                Schema sp = (Schema)ois.readObject();
                Assertions.assertEquals((Object)payload, (Object)sp);
            }
        }
    }

    @Test
    void reconstructSchemaStringWithoutInlinedChildReference() {
        String child = "{\"type\":\"record\",\"name\":\"Child\",\"namespace\":\"org.apache.avro.nested\",\"fields\":[{\"name\":\"childField\",\"type\":\"string\"}]}";
        String parent = "{\"type\":\"record\",\"name\":\"Parent\",\"namespace\":\"org.apache.avro.nested\",\"fields\":[{\"name\":\"child\",\"type\":\"Child\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema childSchema = parser.parse(child);
        Schema parentSchema = parser.parse(parent);
        String parentWithoutInlinedChildReference = parentSchema.toString(Collections.singleton(childSchema), false);
        Assertions.assertEquals((Object)parent, (Object)parentWithoutInlinedChildReference);
    }

    @Test
    void intDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.INT), "doc", (Object)1);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)1, (Object)field.defaultVal());
        Assertions.assertEquals((Object)1, (Object)GenericData.get().getDefaultValue(field));
        field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.INT), "doc", (Object)Integer.MIN_VALUE);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Integer.MIN_VALUE, (Object)field.defaultVal());
        Assertions.assertEquals((Object)Integer.MIN_VALUE, (Object)GenericData.get().getDefaultValue(field));
        field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.INT), "doc", (Object)Integer.MAX_VALUE);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)field.defaultVal());
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void validLongAsIntDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.INT), "doc", (Object)1L);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)1, (Object)field.defaultVal());
        Assertions.assertEquals((Object)1, (Object)GenericData.get().getDefaultValue(field));
        field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.INT), "doc", (Object)Integer.MIN_VALUE);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Integer.MIN_VALUE, (Object)field.defaultVal());
        Assertions.assertEquals((Object)Integer.MIN_VALUE, (Object)GenericData.get().getDefaultValue(field));
        field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.INT), "doc", (Object)Integer.MAX_VALUE);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)field.defaultVal());
        Assertions.assertEquals((Object)Integer.MAX_VALUE, (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void invalidLongAsIntDefaultValue() {
        Assertions.assertThrows(AvroTypeException.class, () -> new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.INT), "doc", (Object)0x80000000L));
    }

    @Test
    void doubleAsIntDefaultValue() {
        Assertions.assertThrows(AvroTypeException.class, () -> new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.INT), "doc", (Object)1.0));
    }

    @Test
    void longDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.LONG), "doc", (Object)1L);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)1L, (Object)field.defaultVal());
        Assertions.assertEquals((Object)1L, (Object)GenericData.get().getDefaultValue(field));
        field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.LONG), "doc", (Object)Long.MIN_VALUE);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Long.MIN_VALUE, (Object)field.defaultVal());
        Assertions.assertEquals((Object)Long.MIN_VALUE, (Object)GenericData.get().getDefaultValue(field));
        field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.LONG), "doc", (Object)Long.MAX_VALUE);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)field.defaultVal());
        Assertions.assertEquals((Object)Long.MAX_VALUE, (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void intAsLongDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.LONG), "doc", (Object)1);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)1L, (Object)field.defaultVal());
        Assertions.assertEquals((Object)1L, (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void doubleAsLongDefaultValue() {
        Assertions.assertThrows(AvroTypeException.class, () -> new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.LONG), "doc", (Object)1.0));
    }

    @Test
    void doubleDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.DOUBLE), "doc", (Object)1.0);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)1.0, (Object)field.defaultVal());
        Assertions.assertEquals((Object)1.0, (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void intAsDoubleDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.DOUBLE), "doc", (Object)1);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)1.0, (Object)field.defaultVal());
        Assertions.assertEquals((Object)1.0, (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void longAsDoubleDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.DOUBLE), "doc", (Object)1L);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)1.0, (Object)field.defaultVal());
        Assertions.assertEquals((Object)1.0, (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void floatAsDoubleDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.DOUBLE), "doc", (Object)Float.valueOf(1.0f));
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)1.0, (Object)field.defaultVal());
        Assertions.assertEquals((Object)1.0, (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void floatDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.FLOAT), "doc", (Object)Float.valueOf(1.0f));
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)field.defaultVal());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void intAsFloatDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.FLOAT), "doc", (Object)1);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)field.defaultVal());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void longAsFloatDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.FLOAT), "doc", (Object)1L);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)field.defaultVal());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void doubleAsFloatDefaultValue() {
        Schema.Field field = new Schema.Field("myField", Schema.create((Schema.Type)Schema.Type.FLOAT), "doc", (Object)1.0);
        Assertions.assertTrue((boolean)field.hasDefaultValue());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)field.defaultVal());
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)GenericData.get().getDefaultValue(field));
    }

    @Test
    void enumSymbolAsNull() {
        Assertions.assertThrows(SchemaParseException.class, () -> Schema.createEnum((String)"myField", (String)"doc", (String)"namespace", Collections.singletonList(null)));
    }

    @Test
    void schemaFieldWithoutSchema() {
        Assertions.assertThrows(NullPointerException.class, () -> new Schema.Field("f", null));
    }

    @Test
    void parseRecordWithNameAsType() {
        String schemaString = "{\n  \"type\" : \"record\",\n  \"name\" : \"ns.int\",\n  \"fields\" : [ \n    {\"name\" : \"value\", \"type\" : \"int\"}, \n    {\"name\" : \"next\", \"type\" : [ \"null\", \"ns.int\" ]}\n  ]\n}";
        Schema schema = new Schema.Parser().parse("{\n  \"type\" : \"record\",\n  \"name\" : \"ns.int\",\n  \"fields\" : [ \n    {\"name\" : \"value\", \"type\" : \"int\"}, \n    {\"name\" : \"next\", \"type\" : [ \"null\", \"ns.int\" ]}\n  ]\n}");
        String toString = schema.toString(true);
        Schema schema2 = new Schema.Parser().parse(toString);
        Assertions.assertEquals((Object)schema, (Object)schema2);
    }

    @Test
    void qualifiedName() {
        Arrays.stream(Schema.Type.values()).forEach(t -> {
            Schema.Name name = new Schema.Name(t.getName(), "space");
            Assertions.assertEquals((Object)("space." + t.getName()), (Object)name.getQualified("space"));
            Assertions.assertEquals((Object)("space." + t.getName()), (Object)name.getQualified("otherdefault"));
        });
        Schema.Name name = new Schema.Name("name", "space");
        Assertions.assertEquals((Object)"name", (Object)name.getQualified("space"));
        Assertions.assertEquals((Object)"space.name", (Object)name.getQualified("otherdefault"));
        Schema.Name nameInt = new Schema.Name("Int", "space");
        Assertions.assertEquals((Object)"Int", (Object)nameInt.getQualified("space"));
    }

    @Test
    void validValue() {
        Schema nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        Assertions.assertTrue((boolean)nullSchema.isValidDefault((JsonNode)JsonNodeFactory.instance.nullNode()));
        Schema intSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Assertions.assertTrue((boolean)intSchema.isValidDefault((JsonNode)JsonNodeFactory.instance.numberNode(12)));
        Schema strSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Assertions.assertTrue((boolean)strSchema.isValidDefault((JsonNode)new TextNode("textNode")));
        Schema arraySchema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        ArrayNode arrayValue = JsonNodeFactory.instance.arrayNode();
        Assertions.assertTrue((boolean)arraySchema.isValidDefault((JsonNode)arrayValue));
        arrayValue.add("Hello");
        arrayValue.add("World");
        Assertions.assertTrue((boolean)arraySchema.isValidDefault((JsonNode)arrayValue));
        arrayValue.add(5);
        Assertions.assertFalse((boolean)arraySchema.isValidDefault((JsonNode)arrayValue));
        Schema unionSchema = Schema.createUnion((Schema[])new Schema[]{strSchema, intSchema, nullSchema});
        Assertions.assertTrue((boolean)unionSchema.isValidDefault((JsonNode)JsonNodeFactory.instance.textNode("Hello")));
        Assertions.assertTrue((boolean)unionSchema.isValidDefault((JsonNode)new IntNode(23)));
        Assertions.assertTrue((boolean)unionSchema.isValidDefault((JsonNode)JsonNodeFactory.instance.nullNode()));
        Assertions.assertFalse((boolean)unionSchema.isValidDefault((JsonNode)arrayValue));
        Schema arrayUnion = Schema.createArray((Schema)unionSchema);
        ArrayNode arrayUnionValue = JsonNodeFactory.instance.arrayNode();
        arrayUnionValue.add("Hello");
        arrayUnionValue.add((JsonNode)NullNode.getInstance());
        Assertions.assertTrue((boolean)arrayUnion.isValidDefault((JsonNode)arrayUnionValue));
        Schema unionStrBytes = Schema.createUnion((Schema[])new Schema[]{strSchema, Schema.create((Schema.Type)Schema.Type.BYTES)});
        Assertions.assertTrue((boolean)unionStrBytes.isValidDefault((JsonNode)JsonNodeFactory.instance.textNode("Hello")));
        Assertions.assertFalse((boolean)unionStrBytes.isValidDefault((JsonNode)JsonNodeFactory.instance.numberNode(123)));
    }

    @Test
    void enumLateDefine() {
        String schemaString = "{\n    \"type\":\"record\",\n    \"name\": \"Main\",\n    \"fields\":[\n        {\n            \"name\":\"f1\",\n            \"type\":\"Sub\"\n        },\n        {\n            \"name\":\"f2\",\n            \"type\":{\n                \"type\":\"enum\",\n                \"name\":\"Sub\",\n                \"symbols\":[\"OPEN\",\"CLOSE\"]\n            }\n        }\n    ]\n}";
        Schema schema = new Schema.Parser().parse(schemaString);
        Schema f1Schema = schema.getField("f1").schema();
        Schema f2Schema = schema.getField("f2").schema();
        Assertions.assertSame((Object)f1Schema, (Object)f2Schema);
        Assertions.assertEquals((Object)Schema.Type.ENUM, (Object)f1Schema.getType());
        String stringSchema = schema.toString();
        int definitionIndex = stringSchema.indexOf("\"symbols\":[\"OPEN\",\"CLOSE\"]");
        int usageIndex = stringSchema.indexOf("\"type\":\"Sub\"");
        Assertions.assertTrue((definitionIndex < usageIndex ? 1 : 0) != 0, (String)"usage is before definition");
    }

    @Test
    public void testRecordInArray() {
        String schemaString = "{\n  \"type\": \"record\",\n  \"name\": \"TestRecord\",\n  \"fields\": [\n    {\n      \"name\": \"value\",\n      \"type\": {\n        \"type\": \"record\",\n        \"name\": \"Container\",\n        \"fields\": [\n          {\n            \"name\": \"Optional\",\n            \"type\": {\n              \"type\": \"array\",\n              \"items\": [\n                {\n                  \"type\": \"record\",\n                  \"name\": \"optional_field_0\",\n                  \"namespace\": \"\",\n                  \"doc\": \"\",\n                  \"fields\": [\n                    {\n                      \"name\": \"optional_field_1\",\n                      \"type\": \"long\",\n                      \"doc\": \"\",\n                      \"default\": 0\n                    }\n                  ]\n                }\n              ]\n            }\n          }\n        ]\n      }\n    }\n  ]\n}";
        Schema schema = new Schema.Parser().parse(schemaString);
        Assertions.assertNotNull((Object)schema);
    }

    @Test
    public void testUnionFieldType() {
        String schemaString = "{\"type\": \"record\", \"name\": \"Lisp\", \"fields\": [{\"name\":\"value\", \"type\":[\"null\", \"string\",{\"type\": \"record\", \"name\": \"Cons\", \"fields\": [{\"name\":\"car\", \"type\":\"Lisp\"},{\"name\":\"cdr\", \"type\":\"Lisp\"}]}]}]}";
        Schema schema = new Schema.Parser().parse(schemaString);
        Schema.Field value = schema.getField("value");
        Schema fieldSchema = value.schema();
        Schema subSchema = fieldSchema.getTypes().stream().filter(s -> s.getType() == Schema.Type.RECORD).findFirst().get();
        Assertions.assertTrue((boolean)subSchema.hasFields());
    }

    @Test
    public void parseAliases() throws JsonProcessingException {
        String s1 = "{ \"aliases\" : [\"a1\",  \"b1\"]}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode j1 = mapper.readTree(s1);
        Set aliases = Schema.parseAliases((JsonNode)j1);
        Assertions.assertEquals((int)2, (int)aliases.size());
        Assertions.assertTrue((boolean)aliases.contains("a1"));
        Assertions.assertTrue((boolean)aliases.contains("b1"));
        String s2 = "{ \"aliases\" : {\"a1\": \"b1\"}}";
        JsonNode j2 = mapper.readTree(s2);
        SchemaParseException ex = (SchemaParseException)Assertions.assertThrows(SchemaParseException.class, () -> Schema.parseAliases((JsonNode)j2));
        Assertions.assertTrue((boolean)ex.getMessage().contains("aliases not an array"));
        String s3 = "{ \"aliases\" : [11,  \"b1\"]}";
        JsonNode j3 = mapper.readTree(s3);
        SchemaParseException ex3 = (SchemaParseException)Assertions.assertThrows(SchemaParseException.class, () -> Schema.parseAliases((JsonNode)j3));
        Assertions.assertTrue((boolean)ex3.getMessage().contains("alias not a string"));
    }

    @Test
    void testContentAfterAvsc() {
        Schema.Parser parser = new Schema.Parser(NameValidator.UTF_VALIDATOR);
        parser.setValidateDefaults(true);
        Assertions.assertThrows(SchemaParseException.class, () -> parser.parse("{\"type\": \"string\"}; DROP TABLE STUDENTS"));
    }

    @Test
    void testContentAfterAvscInInputStream() throws Exception {
        Schema.Parser parser = new Schema.Parser(NameValidator.UTF_VALIDATOR);
        parser.setValidateDefaults(true);
        String avsc = "{\"type\": \"string\"}; DROP TABLE STUDENTS";
        ByteArrayInputStream is = new ByteArrayInputStream(avsc.getBytes(StandardCharsets.UTF_8));
        Schema schema = parser.parse((InputStream)is);
        Assertions.assertNotNull((Object)schema);
    }

    @Test
    void testContentAfterAvscInFile() throws Exception {
        File avscFile = Files.createTempFile("testContentAfterAvscInFile", null, new FileAttribute[0]).toFile();
        try (FileWriter writer = new FileWriter(avscFile);){
            writer.write("{\"type\": \"string\"}; DROP TABLE STUDENTS");
            writer.flush();
        }
        Schema.Parser parser = new Schema.Parser(NameValidator.UTF_VALIDATOR);
        parser.setValidateDefaults(true);
        Assertions.assertThrows(SchemaParseException.class, () -> parser.parse(avscFile));
    }

    @Test
    void testParseMultipleFile() throws IOException {
        URL directory = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("multipleFile"));
        File f1 = new File(directory.getPath(), "ApplicationEvent.avsc");
        File f2 = new File(directory.getPath(), "DocumentInfo.avsc");
        File f3 = new File(directory.getPath(), "MyResponse.avsc");
        Assertions.assertTrue((boolean)f1.exists(), (String)("File not exist for test " + f1.getPath()));
        Assertions.assertTrue((boolean)f2.exists(), (String)("File not exist for test " + f2.getPath()));
        Assertions.assertTrue((boolean)f3.exists(), (String)("File not exist for test " + f3.getPath()));
        SchemaParser parser = new SchemaParser();
        parser.parse(f1);
        parser.parse(f2);
        parser.parse(f3);
        List schemas = parser.getParsedNamedSchemas();
        Assertions.assertEquals((int)3, (int)schemas.size());
        Schema schemaAppEvent = (Schema)schemas.get(0);
        Schema schemaDocInfo = (Schema)schemas.get(1);
        Schema schemaResponse = (Schema)schemas.get(2);
        Assertions.assertNotNull((Object)schemaAppEvent);
        Assertions.assertEquals((int)3, (int)schemaAppEvent.getFields().size());
        Schema.Field documents = schemaAppEvent.getField("documents");
        Schema docSchema = ((Schema)documents.schema().getTypes().get(1)).getElementType();
        Assertions.assertEquals((Object)docSchema, (Object)schemaDocInfo);
        Assertions.assertNotNull((Object)schemaDocInfo);
        Assertions.assertNotNull((Object)schemaResponse);
    }

    @Test
    void add_types() {
        String schemaRecord2 = "{\"type\":\"record\", \"name\":\"record2\", \"fields\": [  {\"name\":\"f1\", \"type\":\"record1\" }]}";
        Schema schemaRecord1 = Schema.createRecord((String)"record1", (String)"doc", (String)"", (boolean)false);
        schemaRecord1.setFields(Collections.singletonList(new Schema.Field("name", Schema.create((Schema.Type)Schema.Type.STRING))));
        Schema.Parser parser = new Schema.Parser().addTypes(Collections.singleton(schemaRecord1));
        Schema schema = parser.parse(schemaRecord2);
        Schema.Field f1 = schema.getField("f1");
        Assertions.assertNotNull((Object)f1);
        Assertions.assertEquals((Object)schemaRecord1, (Object)f1.schema());
    }

    @Test
    void testParserNullValidate() {
        new Schema.Parser((NameValidator)null).parse("{\"type\":\"record\",\"name\":\"\",\"fields\":[]}");
    }

    @Test
    void enumWriteUnknownField() throws IOException {
        Schema schema = Schema.createRecord((String)"record1", (String)"doc", (String)"", (boolean)false);
        String goodValue = "HELLO";
        Schema enumSchema = Schema.createEnum((String)"enum1", (String)"doc", (String)"", Arrays.asList(goodValue));
        Schema.Field field1 = new Schema.Field("field1", enumSchema);
        schema.setFields(Collections.singletonList(field1));
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        String badValue = "GOODBYE";
        builder.set(field1, (Object)new GenericData.EnumSymbol(enumSchema, badValue));
        GenericData.Record record = builder.build();
        try {
            datumWriter.write((Object)record, (Encoder)encoder);
            Assertions.fail((String)"should have thrown");
        }
        catch (AvroTypeException ate) {
            Assertions.assertTrue((boolean)ate.getMessage().contains(goodValue));
            Assertions.assertTrue((boolean)ate.getMessage().contains(badValue));
        }
    }
}

