/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.avro.InvalidAvroMagicException;
import org.apache.avro.NameValidator;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestDataFileReader {
    @TempDir
    public Path dataDir;

    @Test
    void forLeakingFileDescriptors() throws IOException {
        StringBuilder sb = new StringBuilder();
        int maxTries = 3;
        for (int tries = 0; tries < maxTries; ++tries) {
            Path emptyFile = Files.createTempFile("empty", ".avro", new FileAttribute[0]);
            Files.deleteIfExists(emptyFile);
            Files.createFile(emptyFile, new FileAttribute[0]);
            long openFilesBeforeOperation = this.getNumberOfOpenFileDescriptors();
            try (DataFileReader reader2 = new DataFileReader(emptyFile.toFile(), (DatumReader)new GenericDatumReader());){
                Assertions.fail((String)"Reading on empty file is supposed to fail.");
            }
            catch (IOException reader2) {
                // empty catch block
            }
            Files.delete(emptyFile);
            long openFilesAfterOperation = this.getNumberOfOpenFileDescriptors();
            if (openFilesBeforeOperation == openFilesAfterOperation) {
                return;
            }
            sb.append(openFilesBeforeOperation).append("!=").append(openFilesAfterOperation).append(",");
        }
        Assertions.fail((String)("File descriptor leaked from new DataFileReader() over " + maxTries + " tries: (" + sb.substring(0, sb.length() - 1) + ")"));
    }

    private long getNumberOfOpenFileDescriptors() {
        OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        if (osMxBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)osMxBean).getOpenFileDescriptorCount();
        }
        return 0L;
    }

    @Test
    void throttledInputStream() throws IOException {
        Schema legacySchema = new Schema.Parser(NameValidator.NO_VALIDATION).setValidateDefaults(false).parse("{\"type\": \"record\", \"name\": \"TestSchema\", \"fields\": [ {\"name\": \"id\", \"type\": [\"long\", \"null\"], \"default\": null}]}");
        File f = this.dataDir.resolve("testThrottledInputStream.avro").toFile();
        try (DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            w.create(legacySchema, f);
            w.flush();
        }
        DataFileReader r = new DataFileReader(this.throttledInputStream(f), (DatumReader)new GenericDatumReader());
        Assertions.assertEquals((Object)"TestSchema", (Object)r.getSchema().getName());
        FileReader r2 = DataFileReader.openReader((SeekableInput)this.throttledInputStream(f), (DatumReader)new GenericDatumReader());
        Assertions.assertEquals((Object)"TestSchema", (Object)r2.getSchema().getName());
    }

    private SeekableInput throttledInputStream(File f) throws IOException {
        final SeekableFileInput input = new SeekableFileInput(f);
        return new SeekableInput(){

            public void close() throws IOException {
                input.close();
            }

            public void seek(long p) throws IOException {
                input.seek(p);
            }

            public long tell() throws IOException {
                return input.tell();
            }

            public long length() throws IOException {
                return input.length();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                if (len == 1) {
                    return input.read(b, off, len);
                }
                return input.read(b, off, len - 1);
            }
        };
    }

    @Test
    void inputStreamEOF() throws IOException {
        Assertions.assertThrows(EOFException.class, () -> {
            Schema legacySchema = new Schema.Parser(NameValidator.NO_VALIDATION).setValidateDefaults(false).parse("{\"type\": \"record\", \"name\": \"TestSchema\", \"fields\": [ {\"name\": \"id\", \"type\": [\"long\", \"null\"], \"default\": null}]}");
            File f = this.dataDir.resolve("testInputStreamEOF.avro").toFile();
            try (DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
                w.create(legacySchema, f);
                w.flush();
            }
            DataFileReader.openReader((SeekableInput)this.eofInputStream(f), (DatumReader)new GenericDatumReader());
        });
    }

    private SeekableInput eofInputStream(File f) throws IOException {
        final SeekableFileInput input = new SeekableFileInput(f);
        return new SeekableInput(){

            public void close() throws IOException {
                input.close();
            }

            public void seek(long p) throws IOException {
                input.seek(p);
            }

            public long tell() throws IOException {
                return input.tell();
            }

            public long length() throws IOException {
                return input.length();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return -1;
            }
        };
    }

    @Test
    void ignoreSchemaValidationOnRead() throws IOException {
        Schema legacySchema = new Schema.Parser(NameValidator.NO_VALIDATION).setValidateDefaults(false).parse("{\"type\": \"record\", \"name\": \"InvalidAcc\u00ebntWithInvalidNull\", \"fields\": [ {\"name\": \"id\", \"type\": [\"long\", \"null\"], \"default\": null}]}");
        File f = this.dataDir.resolve("testIgnoreSchemaValidationOnRead.avro").toFile();
        try (DataFileWriter w = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            w.create(legacySchema, f);
            w.flush();
        }
        try (DataFileStream r = new DataFileStream((InputStream)new FileInputStream(f), (DatumReader)new GenericDatumReader());){
            Assertions.assertEquals((Object)legacySchema, (Object)r.getSchema());
        }
    }

    @Test
    void invalidMagicLength() throws IOException {
        File f = this.dataDir.resolve("testInvalidMagicLength.avro").toFile();
        try (FileWriter w = new FileWriter(f);){
            w.write("-");
        }
        try (SeekableFileInput fileInput = new SeekableFileInput(f);){
            Assertions.assertThrows(InvalidAvroMagicException.class, () -> DataFileReader.openReader((SeekableInput)fileInput, (DatumReader)new GenericDatumReader()));
        }
    }

    @Test
    void invalidMagicBytes() throws IOException {
        File f = this.dataDir.resolve("testInvalidMagicBytes.avro").toFile();
        try (FileWriter w = new FileWriter(f);){
            w.write("invalid");
        }
        try (SeekableFileInput fileInput = new SeekableFileInput(f);){
            Assertions.assertThrows(InvalidAvroMagicException.class, () -> DataFileReader.openReader((SeekableInput)fileInput, (DatumReader)new GenericDatumReader()));
        }
    }
}

