/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.file.Syncable;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.RandomData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataFile.class);
    @TempDir
    public File DIR;
    private static final int COUNT = Integer.parseInt(System.getProperty("test.count", "200"));
    private static final boolean VALIDATE = !"false".equals(System.getProperty("test.validate", "true"));
    private static final long SEED = System.currentTimeMillis();
    private static final String SCHEMA_JSON = "{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}";
    private static final Schema SCHEMA = new Schema.Parser().parse("{\"type\": \"record\", \"name\": \"Test\", \"fields\": [{\"name\":\"stringField\", \"type\":\"string\"},{\"name\":\"longField\", \"type\":\"long\"}]}");
    private static final Object LAST_RECORD;

    public static Stream<Arguments> codecs() {
        ArrayList<Object[]> r = new ArrayList<Object[]>();
        r.add(new Object[]{null});
        r.add(new Object[]{CodecFactory.deflateCodec((int)0)});
        r.add(new Object[]{CodecFactory.deflateCodec((int)1)});
        r.add(new Object[]{CodecFactory.deflateCodec((int)9)});
        r.add(new Object[]{CodecFactory.nullCodec()});
        r.add(new Object[]{CodecFactory.snappyCodec()});
        r.add(new Object[]{CodecFactory.xzCodec((int)0)});
        r.add(new Object[]{CodecFactory.xzCodec((int)1)});
        r.add(new Object[]{CodecFactory.xzCodec((int)6)});
        r.add(new Object[]{CodecFactory.zstandardCodec((int)-5)});
        r.add(new Object[]{CodecFactory.zstandardCodec((int)0, (boolean)true)});
        r.add(new Object[]{CodecFactory.zstandardCodec((int)5, (boolean)false)});
        r.add(new Object[]{CodecFactory.zstandardCodec((int)18, (boolean)true)});
        r.add(new Object[]{CodecFactory.zstandardCodec((int)0, (boolean)false, (boolean)false)});
        r.add(new Object[]{CodecFactory.zstandardCodec((int)0, (boolean)false, (boolean)true)});
        return r.stream().map(Arguments::of);
    }

    private File makeFile(CodecFactory codec) {
        return new File(this.DIR, "test-" + codec + ".avro");
    }

    @ParameterizedTest
    @MethodSource(value={"codecs"})
    public void runTestsInOrder(CodecFactory codec) throws Exception {
        ArrayList<Function<OutputStream, BinaryEncoder>> encoders = new ArrayList<Function<OutputStream, BinaryEncoder>>();
        encoders.add(b -> new EncoderFactory().directBinaryEncoder(b, null));
        encoders.add(b -> new EncoderFactory().blockingDirectBinaryEncoder(b, null));
        for (Function function : encoders) {
            LOG.info("Running with codec: {}", (Object)codec);
            this.testGenericWrite(codec, function);
            this.testGenericRead(codec);
            this.testSplits(codec);
            this.testSyncDiscovery(codec);
            this.testReadLastRecord(codec);
            this.testGenericAppend(codec, function);
            this.testReadWithHeader(codec);
            this.testFSync(codec, function, false);
            this.testFSync(codec, function, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGenericWrite(CodecFactory codec, Function<OutputStream, BinaryEncoder> encoderFunc) throws IOException {
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter()).setSyncInterval(100);
        if (codec != null) {
            writer.setCodec(codec);
        }
        writer.setEncoder(encoderFunc);
        writer.create(SCHEMA, this.makeFile(codec));
        try {
            int count = 0;
            for (Object datum : new RandomData(SCHEMA, COUNT, SEED)) {
                writer.append(datum);
                if (++count % (COUNT / 3) == 0) {
                    writer.sync();
                }
                if (count != 5) continue;
                boolean threwProperly = false;
                try {
                    GenericData.Record record = (GenericData.Record)datum;
                    record.put(1, null);
                    threwProperly = true;
                    writer.append((Object)record);
                    threwProperly = false;
                }
                catch (DataFileWriter.AppendWriteException e) {
                    System.out.println("Ignoring: " + e);
                }
                Assertions.assertTrue((boolean)threwProperly, (String)"failed to throw when expected");
            }
        }
        finally {
            writer.close();
        }
        Exception doubleCloseEx = null;
        try {
            writer.close();
        }
        catch (Exception e) {
            doubleCloseEx = e;
        }
        Assertions.assertNull((Object)doubleCloseEx, (String)"Double close() threw an unexpected exception");
    }

    private void testGenericRead(CodecFactory codec) throws IOException {
        try (DataFileReader reader = new DataFileReader(this.makeFile(codec), (DatumReader)new GenericDatumReader());){
            Object datum = null;
            if (VALIDATE) {
                for (Object expected : new RandomData(SCHEMA, COUNT, SEED)) {
                    datum = reader.next(datum);
                    Assertions.assertEquals(expected, (Object)datum);
                }
            } else {
                for (int i = 0; i < COUNT; ++i) {
                    datum = reader.next(datum);
                }
            }
        }
    }

    private void testSplits(CodecFactory codec) throws IOException {
        File file = this.makeFile(codec);
        try (DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());){
            int length;
            int start;
            int end;
            Random rand = new Random(SEED);
            int splits = 10;
            int count = 0;
            for (int remaining = end = (length = (int)file.length()); remaining > 0; remaining -= end - start) {
                start = Math.max(0, end - rand.nextInt(2 * length / splits));
                reader.sync((long)start);
                while (!reader.pastSync((long)end)) {
                    reader.next();
                    ++count;
                }
                end = start;
            }
            Assertions.assertEquals((int)COUNT, (int)count);
        }
    }

    private void testSyncDiscovery(CodecFactory codec) throws IOException {
        File file = this.makeFile(codec);
        try (DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());){
            ArrayList<Long> syncs = new ArrayList<Long>();
            long previousSync = -1L;
            while (reader.hasNext()) {
                if (reader.previousSync() != previousSync) {
                    previousSync = reader.previousSync();
                    syncs.add(previousSync);
                }
                reader.next();
            }
            reader.sync(0L);
            Assertions.assertEquals((long)reader.previousSync(), (long)((Long)syncs.get(0)));
            for (Long sync : syncs) {
                reader.seek(sync.longValue());
                Assertions.assertNotNull((Object)reader.next());
            }
            reader.sync(0L);
            ArrayList<Long> syncs2 = new ArrayList<Long>();
            while (reader.hasNext()) {
                syncs2.add(reader.previousSync());
                reader.nextBlock();
            }
            Assertions.assertEquals(syncs, syncs2);
        }
    }

    private void testReadLastRecord(CodecFactory codec) throws IOException {
        File file = this.makeFile(codec);
        try (DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());){
            long lastBlockStart = -1L;
            while (reader.hasNext()) {
                lastBlockStart = reader.previousSync();
                reader.nextBlock();
            }
            reader.seek(lastBlockStart);
            Object lastRecord = null;
            while (reader.hasNext()) {
                lastRecord = reader.next(lastRecord);
            }
            Assertions.assertEquals((Object)LAST_RECORD, lastRecord);
        }
    }

    private void testGenericAppend(CodecFactory codec, Function<OutputStream, BinaryEncoder> encoderFunc) throws IOException {
        File file = this.makeFile(codec);
        long start = file.length();
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter()).appendTo(file);){
            writer.setEncoder(encoderFunc);
            for (Object datum : new RandomData(SCHEMA, COUNT, SEED + 1L)) {
                writer.append(datum);
            }
        }
        try (DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());){
            reader.seek(start);
            Object datum = null;
            if (VALIDATE) {
                for (Object expected : new RandomData(SCHEMA, COUNT, SEED + 1L)) {
                    datum = reader.next(datum);
                    Assertions.assertEquals(expected, (Object)datum);
                }
            } else {
                for (int i = 0; i < COUNT; ++i) {
                    datum = reader.next(datum);
                }
            }
        }
    }

    private void testReadWithHeader(CodecFactory codec) throws IOException {
        File file = this.makeFile(codec);
        try (DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());){
            DataFileStream.Header header = reader.getHeader();
            SeekableFileInput sin = new SeekableFileInput(file);
            sin.seek(sin.length() / 2L);
            try (DataFileReader readerTrue = DataFileReader.openReader((SeekableInput)sin, (DatumReader)new GenericDatumReader(), (DataFileStream.Header)header, (boolean)true);){
                Assertions.assertNotNull((Object)readerTrue.next(), (String)"Should be able to reopen from arbitrary point");
                long validPos = readerTrue.previousSync();
                sin.seek(validPos);
                try (DataFileReader readerFalse = DataFileReader.openReader((SeekableInput)sin, (DatumReader)new GenericDatumReader(), (DataFileStream.Header)header, (boolean)false);){
                    Assertions.assertEquals((long)validPos, (long)sin.tell(), (String)"Should not move from sync point on reopen");
                    Assertions.assertNotNull((Object)readerFalse.next(), (String)"Should be able to reopen at sync point");
                }
            }
        }
    }

    @Test
    public void syncInHeader() throws IOException {
        try (DataFileReader reader = new DataFileReader(new File("target/test-classes/share/test/data/syncInMeta.avro"), (DatumReader)new GenericDatumReader());){
            reader.sync(0L);
            for (Object datum : reader) {
                Assertions.assertNotNull(datum);
            }
        }
    }

    @Test
    public void test12() throws IOException {
        TestDataFile.readFile(new File("target/test-classes/share/test/data/test.avro12"), (DatumReader<? extends Object>)new GenericDatumReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void flushCount() throws IOException {
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        writer.setFlushOnEveryBlock(false);
        TestingByteArrayOutputStream out = new TestingByteArrayOutputStream();
        writer.create(SCHEMA, (OutputStream)out);
        int currentCount = 0;
        int flushCounter = 0;
        try {
            for (Object datum : new RandomData(SCHEMA, COUNT, SEED + 1L)) {
                writer.append(datum);
                writer.sync();
                if (++currentCount % 10 != 0) continue;
                ++flushCounter;
                writer.flush();
            }
        }
        finally {
            writer.close();
        }
        System.out.println("Total number of flushes: " + out.flushCount);
        Assertions.assertTrue((out.flushCount < currentCount && out.flushCount >= flushCounter ? 1 : 0) != 0);
    }

    private void testFSync(CodecFactory codec, Function<OutputStream, BinaryEncoder> encoderFunc, boolean useFile) throws IOException {
        try (DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());){
            writer.setEncoder(encoderFunc);
            writer.setFlushOnEveryBlock(false);
            TestingByteArrayOutputStream out = new TestingByteArrayOutputStream();
            if (useFile) {
                File f = this.makeFile(codec);
                try (SeekableFileInput in = new SeekableFileInput(f);){
                    writer.appendTo((SeekableInput)in, (OutputStream)out);
                }
            } else {
                writer.create(SCHEMA, (OutputStream)out);
            }
            int currentCount = 0;
            int syncCounter = 0;
            for (Object datum : new RandomData(SCHEMA, COUNT, SEED + 1L)) {
                writer.append(datum);
                if (++currentCount % 10 != 0) continue;
                writer.fSync();
                ++syncCounter;
            }
            System.out.println("Total number of syncs: " + out.syncCount);
            Assertions.assertEquals((int)syncCounter, (int)out.syncCount);
        }
    }

    static void readFile(File f, DatumReader<? extends Object> datumReader) throws IOException {
        try (FileReader reader = DataFileReader.openReader((File)f, datumReader);){
            for (Object datum : reader) {
                Assertions.assertNotNull(datum);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        Schema projection = null;
        if (args.length > 1) {
            projection = new Schema.Parser().parse(new File(args[1]));
        }
        TestDataFile.readFile(input, (DatumReader<? extends Object>)new GenericDatumReader(null, projection));
        long start = System.currentTimeMillis();
        for (int i = 0; i < 4; ++i) {
            TestDataFile.readFile(input, (DatumReader<? extends Object>)new GenericDatumReader(null, projection));
        }
        System.out.println("Time: " + (System.currentTimeMillis() - start));
    }

    static {
        Object lastValue = null;
        for (Object object : new RandomData(SCHEMA, COUNT, SEED)) {
            lastValue = object;
        }
        LAST_RECORD = lastValue;
    }

    private static class TestingByteArrayOutputStream
    extends ByteArrayOutputStream
    implements Syncable {
        private int flushCount = 0;
        private int syncCount = 0;

        private TestingByteArrayOutputStream() {
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            ++this.flushCount;
        }

        public void sync() throws IOException {
            ++this.syncCount;
        }
    }
}

