/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.stream.Stream;
import org.apache.avro.NameValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SchemaNameValidatorTest {
    SchemaNameValidatorTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void validator(NameValidator validator, String input, boolean expectedResult) {
        NameValidator.Result result = validator.validate(input);
        Assertions.assertEquals((Object)expectedResult, (Object)result.isOK(), (String)result.getErrors());
    }

    static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, null, false}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, null, false}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "", false}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "", false}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "Hello world", false}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "Hello world", false}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "H&", false}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "H&", false}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "H=", false}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "H=", false}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "H]", false}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "H]", false}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "Hello_world", true}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "Hello_world", true}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "\u00e9\u00e0\u00e7\u00f4", true}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "\u00e9\u00e0\u00e7\u00f4", false}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "5\u00e9\u00e0\u00e7\u00f4", false}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "5\u00e9\u00e0\u00e7\u00f4", false}), Arguments.of((Object[])new Object[]{NameValidator.UTF_VALIDATOR, "_Hello_world", true}), Arguments.of((Object[])new Object[]{NameValidator.STRICT_VALIDATOR, "_Hello_world", true}));
    }
}

