/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.util.internal.JacksonUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestJacksonUtils {
    @Test
    void testToJsonNode() {
        Assertions.assertNull((Object)JacksonUtils.toJsonNode(null));
        Assertions.assertEquals((Object)NullNode.getInstance(), (Object)JacksonUtils.toJsonNode((Object)JsonProperties.NULL_VALUE));
        Assertions.assertEquals((Object)BooleanNode.TRUE, (Object)JacksonUtils.toJsonNode((Object)true));
        Assertions.assertEquals((Object)IntNode.valueOf((int)1), (Object)JacksonUtils.toJsonNode((Object)1));
        Assertions.assertEquals((Object)LongNode.valueOf((long)2L), (Object)JacksonUtils.toJsonNode((Object)2L));
        Assertions.assertEquals((Object)FloatNode.valueOf((float)1.0f), (Object)JacksonUtils.toJsonNode((Object)Float.valueOf(1.0f)));
        Assertions.assertEquals((Object)FloatNode.valueOf((float)33.33f), (Object)JacksonUtils.toJsonNode((Object)Float.valueOf(33.33f)));
        Assertions.assertEquals((Object)DoubleNode.valueOf((double)2.0), (Object)JacksonUtils.toJsonNode((Object)2.0));
        Assertions.assertEquals((Object)BinaryNode.valueOf((byte[])new byte[]{1, 2}), (Object)JacksonUtils.toJsonNode((Object)new byte[]{1, 2}));
        Assertions.assertEquals((Object)TextNode.valueOf((String)"a"), (Object)JacksonUtils.toJsonNode((Object)"a"));
        Assertions.assertEquals((Object)TextNode.valueOf((String)"UP"), (Object)JacksonUtils.toJsonNode((Object)((Object)Direction.UP)));
        Assertions.assertEquals((Object)BigIntegerNode.valueOf((BigInteger)BigInteger.ONE), (Object)JacksonUtils.toJsonNode((Object)BigInteger.ONE));
        Assertions.assertEquals((Object)DecimalNode.valueOf((BigDecimal)BigDecimal.ONE), (Object)JacksonUtils.toJsonNode((Object)BigDecimal.ONE));
        ArrayNode an = JsonNodeFactory.instance.arrayNode();
        an.add(1);
        Assertions.assertEquals((Object)an, (Object)JacksonUtils.toJsonNode(Collections.singletonList(1)));
        ObjectNode on = JsonNodeFactory.instance.objectNode();
        on.put("a", 1);
        Assertions.assertEquals((Object)on, (Object)JacksonUtils.toJsonNode(Collections.singletonMap("a", 1)));
    }

    @Test
    void testToObject() {
        Assertions.assertNull((Object)JacksonUtils.toObject(null));
        Assertions.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)JacksonUtils.toObject((JsonNode)NullNode.getInstance()));
        Assertions.assertEquals((Object)true, (Object)JacksonUtils.toObject((JsonNode)BooleanNode.TRUE));
        Assertions.assertEquals((Object)1, (Object)JacksonUtils.toObject((JsonNode)IntNode.valueOf((int)1)));
        Assertions.assertEquals((Object)2L, (Object)JacksonUtils.toObject((JsonNode)IntNode.valueOf((int)2), (Schema)Schema.create((Schema.Type)Schema.Type.LONG)));
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)JacksonUtils.toObject((JsonNode)DoubleNode.valueOf((double)1.0), (Schema)Schema.create((Schema.Type)Schema.Type.FLOAT)));
        Assertions.assertEquals((Object)2.0, (Object)JacksonUtils.toObject((JsonNode)DoubleNode.valueOf((double)2.0)));
        Assertions.assertEquals((Object)BinaryNode.valueOf((byte[])new byte[]{1, 2}), (Object)JacksonUtils.toJsonNode((Object)new byte[]{1, 2}));
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])((byte[])JacksonUtils.toObject((JsonNode)TextNode.valueOf((String)"\u0001\u0002"), (Schema)Schema.create((Schema.Type)Schema.Type.BYTES))));
        Assertions.assertEquals((Object)"a", (Object)JacksonUtils.toObject((JsonNode)TextNode.valueOf((String)"a")));
        Assertions.assertEquals((Object)"UP", (Object)JacksonUtils.toObject((JsonNode)TextNode.valueOf((String)"UP"), (Schema)((Schema)SchemaBuilder.enumeration((String)"Direction").symbols(new String[]{"UP", "DOWN"}))));
        ArrayNode an = JsonNodeFactory.instance.arrayNode();
        an.add(1);
        Assertions.assertEquals(Collections.singletonList(1), (Object)JacksonUtils.toObject((JsonNode)an));
        ObjectNode on = JsonNodeFactory.instance.objectNode();
        on.put("a", 1);
        Assertions.assertEquals(Collections.singletonMap("a", 1), (Object)JacksonUtils.toObject((JsonNode)on));
        Assertions.assertEquals(Collections.singletonMap("a", 1L), (Object)JacksonUtils.toObject((JsonNode)on, (Schema)((Schema)SchemaBuilder.record((String)"r").fields().requiredLong("a").endRecord())));
        Assertions.assertEquals((Object)JsonProperties.NULL_VALUE, (Object)JacksonUtils.toObject((JsonNode)NullNode.getInstance(), (Schema)((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().intType()).endUnion())));
        Assertions.assertEquals((Object)"a", (Object)JacksonUtils.toObject((JsonNode)TextNode.valueOf((String)"a"), (Schema)((Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().stringType()).and().intType()).endUnion())));
    }

    @ParameterizedTest
    @MethodSource(value={"nodes"})
    void cycle(JsonNode input) {
        Object object = JacksonUtils.toObject((JsonNode)input);
        JsonNode node = JacksonUtils.toJsonNode((Object)object);
        Assertions.assertEquals((Object)input, (Object)node);
    }

    public static Stream<Arguments> nodes() {
        ObjectNode o1 = JsonNodeFactory.instance.objectNode();
        o1.put("intField", 123);
        o1.put("floatField", 33.33f);
        o1.put("doubleField", 33.330001831054695);
        return Stream.of(JsonNodeFactory.instance.numberNode(33.33f), JsonNodeFactory.instance.binaryNode("Hello".getBytes(StandardCharsets.ISO_8859_1)), JsonNodeFactory.instance.arrayNode().add(1).add("Hello").add((JsonNode)o1)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    static enum Direction {
        UP,
        DOWN;

    }
}

