/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.util.WeakIdentityHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WeakIdentityHashMapTest {
    private static final int TEST_SIZE = 4001;
    List<String> data = new ArrayList<String>(4001);
    final WeakIdentityHashMap<String, String> map = new WeakIdentityHashMap();
    List<RuntimeException> exceptions = new ArrayList<RuntimeException>(4001);

    WeakIdentityHashMapTest() {
    }

    @Test
    void stressMap() {
        for (int i = 1; i <= 4001; ++i) {
            this.data.add("Data_" + i);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>(80);
        for (int i = 0; i <= 80; ++i) {
            int seed = (i + 1) * 100;
            Runnable runnable = () -> this.rundata(seed);
            Thread t2 = new Thread(runnable);
            threads.add(t2);
        }
        threads.forEach(Thread::start);
        threads.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertTrue((boolean)this.exceptions.isEmpty());
    }

    void rundata(int seed) {
        try {
            for (int i = 1; i <= 4001; ++i) {
                String keyValue = this.data.get((i + seed) % 4001);
                this.map.put((Object)keyValue, (Object)keyValue);
                if (i % 200 == 0) {
                    this.sleep();
                }
                String keyValueRemove = this.data.get((i + seed) * 3 % 4001);
                this.map.remove((Object)keyValueRemove);
            }
        }
        catch (RuntimeException ex) {
            this.exceptions.add(ex);
        }
    }

    void sleep() {
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

