/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.avro.SystemLimitException;
import org.apache.avro.TestSystemLimitException;
import org.apache.avro.util.Utf8;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUtf8 {
    @Test
    void byteConstructor() throws Exception {
        byte[] bs = "Foo".getBytes(StandardCharsets.UTF_8);
        Utf8 u = new Utf8(bs);
        Assertions.assertEquals((int)bs.length, (int)u.getByteLength());
        for (int i = 0; i < bs.length; ++i) {
            Assertions.assertEquals((byte)bs[i], (byte)u.getBytes()[i]);
        }
    }

    @Test
    void arrayReusedWhenLargerThanRequestedSize() {
        byte[] bs = "55555".getBytes(StandardCharsets.UTF_8);
        Utf8 u = new Utf8(bs);
        Assertions.assertEquals((int)5, (int)u.getByteLength());
        byte[] content = u.getBytes();
        u.setByteLength(3);
        Assertions.assertEquals((int)3, (int)u.getByteLength());
        Assertions.assertSame((Object)content, (Object)u.getBytes());
        u.setByteLength(4);
        Assertions.assertEquals((int)4, (int)u.getByteLength());
        Assertions.assertSame((Object)content, (Object)u.getBytes());
    }

    @Test
    void hashCodeReused() {
        Assertions.assertEquals((int)1, (int)new Utf8().hashCode());
        Assertions.assertEquals((int)128, (int)new Utf8("a").hashCode());
        Assertions.assertEquals((int)4865, (int)new Utf8("zz").hashCode());
        Assertions.assertEquals((int)153, (int)new Utf8("z").hashCode());
        Assertions.assertEquals((int)127791473, (int)new Utf8("hello").hashCode());
        Assertions.assertEquals((int)4122302, (int)new Utf8("hell").hashCode());
        Utf8 u = new Utf8("a");
        Assertions.assertEquals((int)128, (int)u.hashCode());
        Assertions.assertEquals((int)128, (int)u.hashCode());
        u.set("a");
        Assertions.assertEquals((int)128, (int)u.hashCode());
        u.setByteLength(1);
        Assertions.assertEquals((int)128, (int)u.hashCode());
        u.setByteLength(2);
        Assertions.assertNotEquals((int)128, (int)u.hashCode());
        u.set("zz");
        Assertions.assertEquals((int)4865, (int)u.hashCode());
        u.setByteLength(1);
        Assertions.assertEquals((int)153, (int)u.hashCode());
        u.set("hello");
        Assertions.assertEquals((int)127791473, (int)u.hashCode());
        u.setByteLength(4);
        Assertions.assertEquals((int)4122302, (int)u.hashCode());
        u.set(new Utf8("zz"));
        Assertions.assertEquals((int)4865, (int)u.hashCode());
        u.setByteLength(1);
        Assertions.assertEquals((int)153, (int)u.hashCode());
        u.set(new Utf8("hello"));
        Assertions.assertEquals((int)127791473, (int)u.hashCode());
        u.setByteLength(4);
        Assertions.assertEquals((int)4122302, (int)u.hashCode());
    }

    @Test
    void hashCodeBasedOnCapacity() {
        Utf8 fullCapacity = new Utf8("abcdefgh", 8);
        Utf8 partialCapacity = new Utf8("abcdefghX", 8);
        Assertions.assertEquals((int)fullCapacity.hashCode(), (int)partialCapacity.hashCode());
    }

    @Test
    void oversizeUtf8() {
        Utf8 u = new Utf8();
        u.setByteLength(1024);
        Assertions.assertEquals((int)1024, (int)u.getByteLength());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> u.setByteLength(0x7FFFFFF8));
        try {
            System.setProperty("org.apache.avro.limits.string.maxLength", Long.toString(1000L));
            TestSystemLimitException.resetLimits();
            Exception ex = (Exception)Assertions.assertThrows(SystemLimitException.class, () -> u.setByteLength(1024));
            Assertions.assertEquals((Object)"String length 1024 exceeds maximum allowed", (Object)ex.getMessage());
        }
        finally {
            System.clearProperty("org.apache.avro.limits.string.maxLength");
            TestSystemLimitException.resetLimits();
        }
    }

    @Test
    void serialization() throws IOException, ClassNotFoundException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            Utf8 originalEmpty = new Utf8();
            Utf8 originalBytes = new Utf8("originalBytes".getBytes(StandardCharsets.UTF_8));
            Utf8 originalString = new Utf8("originalString");
            oos.writeObject(originalEmpty);
            oos.writeObject(originalBytes);
            oos.writeObject(originalString);
            oos.flush();
            try (ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                 ObjectInputStream ois = new ObjectInputStream(bis);){
                MatcherAssert.assertThat((Object)ois.readObject(), (Matcher)Matchers.is((Object)originalEmpty));
                MatcherAssert.assertThat((Object)ois.readObject(), (Matcher)Matchers.is((Object)originalBytes));
                MatcherAssert.assertThat((Object)ois.readObject(), (Matcher)Matchers.is((Object)originalString));
            }
        }
    }
}

