/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import org.apache.avro.Schema;
import org.apache.avro.util.SchemaVisitor;
import org.apache.avro.util.Schemas;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemas {
    @Test
    public void testVisit1() {
        String s1 = "{\"type\": \"record\", \"name\": \"t1\", \"fields\": [{\"name\": \"f1\", \"type\": \"int\"}]}";
        Assert.assertEquals((Object)"t1.", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s1), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit2() {
        String s2 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": \"int\"}]}";
        Assert.assertEquals((Object)"c1.\"int\"!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s2), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit3() {
        String s3 = "{\"type\": \"record\", \"name\": \"ss1\", \"fields\": [{\"name\": \"f1\", \"type\": \"int\"}]}";
        Assert.assertEquals((Object)"ss1.", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s3), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit4() {
        String s4 = "{\"type\": \"record\", \"name\": \"st1\", \"fields\": [{\"name\": \"f1\", \"type\": \"int\"}]}";
        Assert.assertEquals((Object)"st1.!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s4), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit5() {
        String s5 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"c2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.c2.\"int\"!\"long\"!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s5), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit6() {
        String s6 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"ss2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.ss2.!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s6), (SchemaVisitor)new TestVisitor()));
    }

    @Test
    public void testVisit7() {
        String s7 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"css2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.css2.\"int\"!!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s7), (SchemaVisitor)new TestVisitor()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testVisit8() {
        String s8 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"cst2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"int\"}]}";
        Schemas.visit((Schema)new Schema.Parser().parse(s8), (SchemaVisitor)new TestVisitor());
    }

    @Test
    public void testVisit9() {
        String s9 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"ct2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.ct2.\"int\"!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s9), (SchemaVisitor)new TestVisitor()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testVisit10() {
        String s10 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"ct2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"int\"}]}";
        Schemas.visit((Schema)new Schema.Parser().parse(s10), (SchemaVisitor)new TestVisitor(){

            @Override
            public SchemaVisitor.SchemaVisitorAction visitTerminal(Schema terminal) {
                return SchemaVisitor.SchemaVisitorAction.SKIP_SUBTREE;
            }
        });
    }

    @Test
    public void testVisit11() {
        String s11 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"c2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"},{\"name\": \"f12\", \"type\": \"double\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.c2.\"int\".!\"long\".!", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s11), (SchemaVisitor)new TestVisitor(){

            @Override
            public SchemaVisitor.SchemaVisitorAction visitTerminal(Schema terminal) {
                this.sb.append(terminal).append('.');
                return SchemaVisitor.SchemaVisitorAction.SKIP_SIBLINGS;
            }
        }));
    }

    @Test
    public void testVisit12() {
        String s12 = "{\"type\": \"record\", \"name\": \"c1\", \"fields\": [{\"name\": \"f1\", \"type\": {\"type\": \"record\", \"name\": \"ct2\", \"fields\": [{\"name\": \"f11\", \"type\": \"int\"}]}},{\"name\": \"f2\", \"type\": \"long\"}]}";
        Assert.assertEquals((Object)"c1.ct2.\"int\".", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s12), (SchemaVisitor)new TestVisitor(){

            @Override
            public SchemaVisitor.SchemaVisitorAction visitTerminal(Schema terminal) {
                this.sb.append(terminal).append('.');
                return SchemaVisitor.SchemaVisitorAction.TERMINATE;
            }
        }));
    }

    @Test
    public void testVisit13() {
        String s12 = "{\"type\": \"int\"}";
        Assert.assertEquals((Object)"\"int\".", (Object)Schemas.visit((Schema)new Schema.Parser().parse(s12), (SchemaVisitor)new TestVisitor(){

            @Override
            public SchemaVisitor.SchemaVisitorAction visitTerminal(Schema terminal) {
                this.sb.append(terminal).append('.');
                return SchemaVisitor.SchemaVisitorAction.SKIP_SIBLINGS;
            }
        }));
    }

    private static class TestVisitor
    implements SchemaVisitor<String> {
        StringBuilder sb = new StringBuilder();

        private TestVisitor() {
        }

        public SchemaVisitor.SchemaVisitorAction visitTerminal(Schema terminal) {
            this.sb.append(terminal);
            return SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitor.SchemaVisitorAction visitNonTerminal(Schema nonTerminal) {
            String n = nonTerminal.getName();
            this.sb.append(n).append('.');
            if (n.startsWith("t")) {
                return SchemaVisitor.SchemaVisitorAction.TERMINATE;
            }
            if (n.startsWith("ss")) {
                return SchemaVisitor.SchemaVisitorAction.SKIP_SIBLINGS;
            }
            if (n.startsWith("st")) {
                return SchemaVisitor.SchemaVisitorAction.SKIP_SUBTREE;
            }
            return SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        public SchemaVisitor.SchemaVisitorAction afterVisitNonTerminal(Schema nonTerminal) {
            this.sb.append("!");
            String n = nonTerminal.getName();
            if (n.startsWith("ct")) {
                return SchemaVisitor.SchemaVisitorAction.TERMINATE;
            }
            if (n.startsWith("css")) {
                return SchemaVisitor.SchemaVisitorAction.SKIP_SIBLINGS;
            }
            if (n.startsWith("cst")) {
                return SchemaVisitor.SchemaVisitorAction.SKIP_SUBTREE;
            }
            return SchemaVisitor.SchemaVisitorAction.CONTINUE;
        }

        public String get() {
            return this.sb.toString();
        }
    }
}

